/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class FRA_StreetBuilder
extends GenericStreetBuilder {
    protected FRA_GeoInfoIndexFile m_geoIndex;
    private FRA_GeoInfoPreLoadedDataHelper m_geoInfoHelper = new FRA_GeoInfoPreLoadedDataHelper();
    private static Set<String> m_missingGeoInfoKeys = new HashSet<String>();

    public void initGeoInfoExactLookupIndex(String dataSetPath) {
        try {
            this.m_geoIndex = new FRA_GeoInfoIndexFile();
            this.m_geoIndex.open(StringUtilities.appendToPath((String)dataSetPath, (String)"geoinfo.jdx"));
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open geoinfo files.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            throw new RuntimeException("ERROR: Unable to open geoinfo files.", IOEx);
        }
    }

    protected void populateLocalStreetInfo(MultiSegmentStreet record, IDataFileDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        super.populateLocalStreetInfo(record, item, metadata);
        GenericStreet street = (GenericStreet)item;
        try {
            if (street.hasString(3)) {
                street.removeString(3);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to remove GenericField4 from data item: " + street);
        }
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        this.m_geoInfoHelper.populateLocalGeoInfo(record, geoInfoItem, metadata);
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)segmentItem;
        try {
            boolean hasLeftGeoinfo = false;
            boolean hasRightGeoinfo = false;
            if (this.m_geoIndex != null) {
                String leftAreaNames = this.buildAreaNameString(segmentRecord, true);
                String rightAreaNames = this.buildAreaNameString(segmentRecord, false);
                MapMarkerIndexSingleValue val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)new MiStringIndexKey(leftAreaNames));
                if (leftAreaNames.equalsIgnoreCase(rightAreaNames)) {
                    if (val != null && val.getOffset() != 0L) {
                        segment.putLong(0, val.getOffset());
                        this.removeCommonAreaStrings(segment);
                        hasRightGeoinfo = true;
                        hasLeftGeoinfo = true;
                    } else if (val == null) {
                        if (!StringUtilities.isEmpty((String)leftAreaNames)) {
                            m_missingGeoInfoKeys.add(leftAreaNames + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("\n\nERROR: Unable to get offset for geoinfo record with key: " + leftAreaNames + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                    }
                } else {
                    if (val != null && val.getOffset() != 0L) {
                        segment.putLong(32, val.getOffset());
                        this.removeLeftAreaStrings(segment);
                        hasLeftGeoinfo = true;
                    } else if (val == null) {
                        if (!StringUtilities.isEmpty((String)leftAreaNames)) {
                            m_missingGeoInfoKeys.add(leftAreaNames + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("\n\nERROR: Unable to get offset for geoinfo record with key: " + leftAreaNames + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                    }
                    val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)new MiStringIndexKey(rightAreaNames));
                    if (val != null && val.getOffset() != 0L) {
                        segment.putLong(33, val.getOffset());
                        this.removeRightAreaStrings(segment);
                        hasRightGeoinfo = true;
                    } else if (val == null) {
                        if (!StringUtilities.isEmpty((String)rightAreaNames)) {
                            m_missingGeoInfoKeys.add(rightAreaNames + " (" + segmentRecord.getRightAreaName1() + "," + segmentRecord.getRightAreaName2() + "," + segmentRecord.getRightAreaName3() + "," + segmentRecord.getRightAreaName4() + "," + segmentRecord.getRightPostalCode1() + ")");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("\n\nUnable to get offset for geoinfo record with key: " + rightAreaNames + " (" + segmentRecord.getRightAreaName1() + "," + segmentRecord.getRightAreaName2() + "," + segmentRecord.getRightAreaName3() + "," + segmentRecord.getRightAreaName4() + "," + segmentRecord.getRightPostalCode1() + ")");
                    }
                }
            }
            if (!hasLeftGeoinfo || !hasRightGeoinfo) {
                this.setOriginalNameAndStandardize(segment);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    private void removeCommonAreaStrings(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        this.removeAreaName(segment, 14);
        this.removeAreaName(segment, 15);
        this.removeAreaName(segment, 16);
        this.removeAreaName(segment, 17);
        this.removeAreaName(segment, 12);
    }

    private void removeLeftAreaStrings(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        String shared = this.removeAreaName(segment, 14);
        if (shared != null) {
            segment.putString(5, shared);
        } else {
            this.removeAreaName(segment, 4);
        }
        shared = this.removeAreaName(segment, 15);
        if (shared != null) {
            segment.putString(7, shared);
        } else {
            this.removeAreaName(segment, 6);
        }
        shared = this.removeAreaName(segment, 16);
        if (shared != null) {
            segment.putString(9, shared);
        } else {
            this.removeAreaName(segment, 8);
        }
        shared = this.removeAreaName(segment, 17);
        if (shared != null) {
            segment.putString(11, shared);
        } else {
            this.removeAreaName(segment, 10);
        }
        shared = this.removeAreaName(segment, 12);
        if (shared != null) {
            segment.putString(1, shared);
        } else {
            this.removeAreaName(segment, 0);
        }
    }

    private void removeRightAreaStrings(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        String shared = this.removeAreaName(segment, 14);
        if (shared != null) {
            segment.putString(4, shared);
        } else {
            this.removeAreaName(segment, 5);
        }
        shared = this.removeAreaName(segment, 15);
        if (shared != null) {
            segment.putString(6, shared);
        } else {
            this.removeAreaName(segment, 7);
        }
        shared = this.removeAreaName(segment, 16);
        if (shared != null) {
            segment.putString(8, shared);
        } else {
            this.removeAreaName(segment, 9);
        }
        shared = this.removeAreaName(segment, 17);
        if (shared != null) {
            segment.putString(10, shared);
        } else {
            this.removeAreaName(segment, 11);
        }
        shared = this.removeAreaName(segment, 12);
        if (shared != null) {
            segment.putString(0, shared);
        } else {
            this.removeAreaName(segment, 1);
        }
    }

    private String removeAreaName(GenericSegment segment, int field) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(field)) {
            return segment.removeString(field);
        }
        return null;
    }

    private void setOriginalNameAndStandardize(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        this.setOriginalNameAndStandardize(segment, 14, 32);
        this.setOriginalNameAndStandardize(segment, 4, 36);
        this.setOriginalNameAndStandardize(segment, 5, 40);
        this.setOriginalNameAndStandardize(segment, 15, 33);
        this.setOriginalNameAndStandardize(segment, 6, 37);
        this.setOriginalNameAndStandardize(segment, 7, 41);
        this.setOriginalNameAndStandardize(segment, 16, 34);
        this.setOriginalNameAndStandardize(segment, 8, 38);
        this.setOriginalNameAndStandardize(segment, 9, 42);
        this.setOriginalNameAndStandardize(segment, 17, 35);
        this.setOriginalNameAndStandardize(segment, 10, 39);
        this.setOriginalNameAndStandardize(segment, 11, 43);
        this.storePostCodeAsInt(segment, 12, 32);
        this.storePostCodeAsInt(segment, 0, 33);
        this.storePostCodeAsInt(segment, 1, 34);
    }

    private void setOriginalNameAndStandardize(GenericSegment segment, int actualField, int originalNameField) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(actualField)) {
            String areaname = segment.getString(actualField);
            segment.putString(originalNameField, areaname);
            areaname = FRA_Standardizer.standardizeAreaName(areaname);
            segment.putString(actualField, areaname);
        }
    }

    private void storePostCodeAsInt(GenericSegment segment, int stringField, int intField) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(stringField)) {
            String postcode = segment.removeString(stringField);
            segment.putInt(intField, Integer.parseInt(postcode));
        }
    }

    private String buildAreaNameString(MMJSegmentRecord record, boolean isLeft) {
        String tmp;
        StringBuilder sb = new StringBuilder();
        String string = tmp = isLeft ? record.getLeftAreaName1() : record.getRightAreaName1();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string2 = tmp = isLeft ? record.getLeftAreaName2() : record.getRightAreaName2();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string3 = tmp = isLeft ? record.getLeftAreaName3() : record.getRightAreaName3();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string4 = tmp = isLeft ? record.getLeftAreaName4() : record.getRightAreaName4();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string5 = tmp = isLeft ? record.getLeftPostalCode1() : record.getRightPostalCode1();
        if (tmp != null) {
            sb.append(tmp);
        }
        return sb.toString().toUpperCase();
    }

    public static Set<String> getMissingGeoInfoKeys() {
        return m_missingGeoInfoKeys;
    }
}

