/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary.index;

import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class FRA_GeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    private FRA_GeoInfoPreLoadedDataHelper m_geoInfoHelper = new FRA_GeoInfoPreLoadedDataHelper();

    public FRA_GeoInfoSoundexIndexer() {
        this.sndx = new FRAFrenchSoundex();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        FRA_GeoInfoRecord record;
        try {
            record = (FRA_GeoInfoRecord)((Object)this.m_geoInfoHelper.makeDataRecord((IDataFileDataItem)item, (MMJDataFileMetadata)metadata));
        }
        catch (LocalizationException e) {
            DataCreationLogger.getLogger().logError("Error converting data item into FRA_GeoInfoRecord.");
            throw new DataCreationException((Throwable)e);
        }
        HashSet keys = new HashSet();
        keys.addAll(this.makeKeysForArea(record.getAreaName3()));
        keys.addAll(this.makeKeysForArea(record.getAltAreaName3Array()));
        keys.addAll(this.makeKeysForArea(record.getAreaName4()));
        keys.addAll(this.makeKeysForArea(record.getAltAreaName4Array()));
        if (keys.size() == 0) {
            keys.addAll(this.makeKeysForArea(record.getAreaName2()));
            keys.addAll(this.makeKeysForArea(record.getAltAreaName2Array()));
        }
        if (keys.size() == 0) {
            keys.addAll(this.makeKeysForArea(record.getAreaName1()));
            keys.addAll(this.makeKeysForArea(record.getAltAreaName1Array()));
        }
        if (keys.size() == 0) {
            DataCreationLogger.getLogger().logError("No soundex keys created!");
        }
        return new ArrayList(keys);
    }

    private Collection makeKeysForArea(String[] areaname) {
        HashSet keys = new HashSet();
        for (int i = 0; areaname != null && i < areaname.length; ++i) {
            keys.addAll(this.makeKeysForArea(areaname[i]));
        }
        return keys;
    }

    private Collection makeKeysForArea(String areaname) {
        HashSet<ISoundexKey> keys = new HashSet<ISoundexKey>();
        if (!StringUtilities.isEmpty((String)areaname)) {
            ISoundexKey key = this.sndx.getSoundex(areaname);
            if (key != null) {
                keys.add(key);
                if (((FRA_SoundexKey)key).getFirstChar() == '\u0000') {
                    DataCreationLogger.getLogger().logInternalError("Null first char in string key! AreaName = " + areaname);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Null soundex key created! AreaName: " + areaname);
            }
            if ((key = FRAFrenchSoundex.getStringKey(areaname)) != null) {
                keys.add(key);
                if (((FRA_SoundexKey)key).getFirstChar() == '\u0000') {
                    DataCreationLogger.getLogger().logInternalError("Null first char in string key! AreaName = " + areaname);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Null string key created! AreaName: " + areaname);
            }
        }
        return keys;
    }
}

