/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary.index;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.ByteSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerCharSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class FRA_MultiLevelSoundexIndexKey
implements MapMarkerMultiLevelIndexKey {
    private static final int LEVELS = 3;
    private MapMarkerIndexKey[] m_keys = new MapMarkerIndexKey[3];

    public FRA_MultiLevelSoundexIndexKey() {
        this.m_keys[0] = new ByteSubIndexKey();
        this.m_keys[1] = new MapMarkerCharSubIndexKey();
        this.m_keys[2] = new MapMarkerIntSubIndexKey();
    }

    public FRA_MultiLevelSoundexIndexKey(FRA_SoundexKey key) {
        this.m_keys[0] = new ByteSubIndexKey(key.getKeyType());
        this.m_keys[1] = new MapMarkerCharSubIndexKey(key.getFirstChar());
        this.m_keys[2] = new MapMarkerIntSubIndexKey(key.getNumericValue());
    }

    public int getLevels() {
        return 3;
    }

    public MapMarkerIndexKey getKeyAt(int level) {
        return this.m_keys[level];
    }

    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < 3; ++i) {
            this.m_keys[i].write(out);
        }
    }

    public void read(DataInput in) throws IOException {
        for (int i = 0; i < 3; ++i) {
            this.m_keys[i].read(in);
        }
    }

    public boolean equals(Object that) {
        FRA_MultiLevelSoundexIndexKey thatKey = (FRA_MultiLevelSoundexIndexKey)that;
        return Arrays.equals(this.m_keys, thatKey.m_keys);
    }

    public int compareTo(Object that) {
        FRA_MultiLevelSoundexIndexKey thatKey = (FRA_MultiLevelSoundexIndexKey)that;
        for (int i = 0; i < 3; ++i) {
            if (this.m_keys[i].equals(thatKey.m_keys[i])) continue;
            return this.m_keys[i].compareTo((Object)thatKey.m_keys[i]);
        }
        return 0;
    }
}

