/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.ud;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.FRA_AddressUtils;
import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoBase;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.FRA.dp.ud.FRA_UDGeo2SacData;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class FRA_UDStreetDataSourceRecordConvertor
extends UDStreetDataSourceRecordConvertor {
    public FRA_UDStreetDataSourceRecordConvertor(Properties dataProperties, UDPost2SacDataHandler post2SacHandler, UDGeo2SacDataHandler geo2SacHandler, Soundex soundex, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler geoInfoHandler) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
        String dataSetPath = dataProperties.getProperty("dataSetPath");
        if (dataSetPath != null) {
            try {
                this.m_geo2sac = new FRA_UDGeo2SacData(this.makeGeo2SacDataRecordType(), new SacMetadata(), dataSetPath);
            }
            catch (IOException e) {
                throw new DataCreationException(-1, (Throwable)e);
            }
            catch (MMJEDataCorruptedException e) {
                throw new DataCreationException(-1, (Throwable)e);
            }
        }
        this.verifyInitialization();
    }

    protected void verifyInitialization() throws DataCreationException {
        if (this.m_geo2sac == null) {
            throw new DataCreationException(700);
        }
        if (this.m_post2sac == null) {
            throw new DataCreationException(800);
        }
    }

    protected IPostalBase makePostalBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String postcode = null;
        if (left && input.hasLeftPostCode1() && this.stringExists(input.getLeftPostCode1())) {
            postcode = input.getLeftPostCode1().trim();
        }
        if (!left && input.hasRightPostCode1() && this.stringExists(input.getRightPostCode1())) {
            postcode = input.getRightPostCode1().trim();
        }
        StandardPostalBase base = null;
        if (!FRA_AddressUtils.isEmpty(postcode)) {
            if (postcode.length() > 3) {
                postcode = postcode.substring(0, 3);
            }
            base = new StandardPostalBase(postcode);
        }
        return base;
    }

    private IGeoBase[] makeGeoBases(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        return this.makeGeoBases(this.getAreaName3(input, left), FRA_GeoBase.AREA_LEVEL_AN3);
    }

    private IGeoBase[] makeGeoBases(String areaName, byte type) {
        HashSet<FRA_GeoBase> bases = new HashSet<FRA_GeoBase>();
        if (!StringUtilities.isEmpty((String)(areaName = FRA_Standardizer.standardizeAreaName(areaName)))) {
            ISoundexKey sndxKey = FRAFrenchSoundex.getStringKey(areaName);
            if (sndxKey != null) {
                bases.add(new FRA_GeoBase((FRA_SoundexKey)sndxKey, areaName, type));
            }
            if ((sndxKey = this.m_soundex.getSoundex(areaName)) != null) {
                bases.add(new FRA_GeoBase((FRA_SoundexKey)sndxKey, areaName, type));
            }
        }
        return bases.toArray(new FRA_GeoBase[bases.size()]);
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) {
        throw new UnsupportedOperationException();
    }

    private String getAreaName3(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3 = null;
        if (left && input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
            areaName3 = input.getLeftAreaName3();
        } else if (!left && input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
            areaName3 = input.getRightAreaName3();
        }
        return areaName3;
    }

    protected int[] getSacsFromGeo2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IGeoBase[] bases = this.makeGeoBases(input.getSegment(), left);
        if (bases == null || bases.length == 0) {
            return new int[]{this.NO_SAC};
        }
        IntArray sacs = new IntArray();
        for (int i = 0; i < bases.length; ++i) {
            int[] tmp = this.getGeo2Sac(bases[i]);
            for (int j = 0; tmp != null && j < tmp.length; ++j) {
                if (sacs.contains(tmp[j])) continue;
                sacs.add(tmp[j]);
            }
        }
        return sacs.asArray();
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyBase = alternateBrowseString;
        int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
        char c = FRA_ScoringHelper.getFirstNormChar(keyBase);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        String keyString = address.getGenericField4();
        if (StringUtilities.isEmpty((String)keyString)) {
            keyString = address.getMainAddress();
        }
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[]{new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey)};
        return keys;
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        if (range == null || StringUtilities.isEmpty((String)range.getPlaceName())) {
            return;
        }
        MapMarkerIndexKey searchKey = this.makeSoundexSearchKey(range.getPlaceName(), sac);
        MapMarkerIndexKey browseKey = this.makeAlternateStreetBrowseKey(range.getPlaceName(), sac);
        AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
        AlternateDataItem alternateItem = new AlternateDataItem(0, alternateDataRecord, searchKey, browseKey);
        range.addAlternateDataItem(alternateItem);
    }

    protected MapMarkerIndexKey makeSoundexSearchKey(String soundexString, int sac) {
        FRA_SoundexKey sndxKey = (FRA_SoundexKey)this.makeSoundexKey(soundexString);
        if (sndxKey == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)new MiSoundexKey((MiSoundexKey)sndxKey));
    }

    protected MapMarkerIndexKey makeAlternateStreetBrowseKey(String str, int sac) {
        String keyString = str.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = FRA_InternalCandidateAddress.reconstructAddress((Address)new InternalCandidateAddress(parsed));
        boolean result = parsed_street.equalsIgnoreCase(original_street);
        return result;
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        int i;
        boolean useAlternate;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
        List addressList = null;
        try {
            if (!input.hasMainAddress() || !this.stringExists(input.getMainAddress())) {
                DataCreationLogger.getLogger().logInternalError("FRA_UDStreetDataSourceRecordConvertorImpl:: All streets should have main addresses.");
                return null;
            }
            addressList = this.getAllPossibleMainAddresses(input);
            if (addressList == null || addressList.size() == 0) {
                DataCreationLogger.getLogger().logInternalError("FRA_UDStreetDataSourceRecordConvertorImpl:: No main adddress found.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        int[] leftSacs = this.getLeftSacs(input);
        int[] rightSacs = this.getRightSacs(input);
        int[] commonSacs = this.getCommonSacs(leftSacs, rightSacs);
        int uniqueLeftSacs = this.getNumberOfNonNoSacs(leftSacs);
        int uniqueRightSacs = this.getNumberOfNonNoSacs(rightSacs);
        int uniqueCommonSacs = this.getNumberOfNonNoSacs(commonSacs);
        int uniqueSacs = uniqueLeftSacs + uniqueRightSacs + uniqueCommonSacs;
        if (uniqueSacs == 0) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No unique sacs on either side of the street.");
            return null;
        }
        boolean bl = useAlternate = addressList.size() > 1;
        if (uniqueSacs == 1 && !useAlternate) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
        } else {
            this.m_dataRecords = new Object[uniqueSacs * addressList.size() - 1];
        }
        MMJStreetRecord record = null;
        this.m_nextDataRecordIndex = 0;
        int dataRecordsIndex = 0;
        if (commonSacs != null) {
            for (i = 0; i < commonSacs.length; ++i) {
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueLeftSacs > 0) {
            for (i = 0; i < leftSacs.length; ++i) {
                if (leftSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueRightSacs > 0) {
            for (i = 0; i < rightSacs.length; ++i) {
                if (rightSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (useAlternate) {
            try {
                for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                    this.m_dataRecords[uniqueSacs + altNum - 1] = this.createAlternateStreetRecord(record, input, (Address)addressList.get(altNum + 1));
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
            for (i = 1; i < uniqueSacs; ++i) {
                try {
                    for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                        this.m_dataRecords[uniqueSacs + i + altNum - 1] = this.createAlternateStreetRecord((MMJStreetRecord)this.m_dataRecords[i + altNum - 1], input, (Address)addressList.get(altNum + 1));
                    }
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        return record;
    }

    private int getNumberOfNonNoSacs(int[] sacs) {
        if (sacs == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sacs.length; ++i) {
            if (sacs[i] == this.NO_SAC) continue;
            ++count;
        }
        return count;
    }

    private int[] getCommonSacs(int[] leftSacs, int[] rightSacs) {
        int[] finalCommonSacs;
        int[] tempCommonSacs = leftSacs.length < rightSacs.length ? new int[leftSacs.length] : new int[rightSacs.length];
        for (int i = 0; i < tempCommonSacs.length; ++i) {
            tempCommonSacs[i] = this.NO_SAC;
        }
        int commonIndex = 0;
        boolean foundCommon = false;
        for (int l = 0; l < leftSacs.length; ++l) {
            for (int r = 0; r < rightSacs.length; ++r) {
                if (leftSacs[l] != rightSacs[r] || leftSacs[l] == this.NO_SAC) continue;
                foundCommon = true;
                tempCommonSacs[commonIndex] = leftSacs[l];
                ++commonIndex;
                leftSacs[l] = rightSacs[r] = this.NO_SAC;
            }
        }
        if (foundCommon) {
            int commonCount = 0;
            int totalCommonSacs = this.getNumberOfNonNoSacs(tempCommonSacs);
            finalCommonSacs = new int[totalCommonSacs];
            for (int i = 0; i < tempCommonSacs.length; ++i) {
                if (tempCommonSacs[i] == this.NO_SAC) continue;
                finalCommonSacs[commonCount] = tempCommonSacs[i];
                ++commonCount;
            }
        } else {
            return null;
        }
        return finalCommonSacs;
    }

    @Override
    protected MMJGeo2SacRecord makeGeo2SacDataRecordType(int sac, IGeoBase base) {
        return new FRA_Geo2SacRecord(sac, (FRA_GeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new FRA_Geo2SacRecord();
    }

    protected Address getParsedStreet(IStreetDataSourceRecord input, Address inputStreetAddress) throws DataSourceException {
        StringBuffer buf = new StringBuffer(100);
        if (inputStreetAddress.getMainAddress().startsWith("100 ")) {
            buf.append(inputStreetAddress.getMainAddress());
            buf.insert(3, 'A');
        } else {
            buf.append("100A ");
            buf.append(inputStreetAddress.getMainAddress());
        }
        inputStreetAddress.setMainAddress(buf.toString());
        Address parsedAddress = this.parseStreet(inputStreetAddress);
        if (parsedAddress == null) {
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + inputStreetAddress.getMainAddress());
            return null;
        }
        if (parsedAddress.getMainAddress() == null) {
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.");
            return null;
        }
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && parsedAddress.getUnitValue() == null && parsedAddress.getUnitType() == null) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        buf.append(" APP 1");
        inputStreetAddress.setMainAddress(buf.toString());
        parsedAddress = this.parseStreet(inputStreetAddress);
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && this.stringExists(parsedAddress.getUnitType()) && parsedAddress.getUnitType().equalsIgnoreCase("APP") && this.stringExists(parsedAddress.getUnitValue()) && parsedAddress.getUnitValue().equalsIgnoreCase("1")) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        buf.insert(5, "COTE ");
        inputStreetAddress.setMainAddress(buf.toString());
        parsedAddress = this.parseStreet(inputStreetAddress);
        if (this.stringExists(parsedAddress.getAddressNumber()) && parsedAddress.getAddressNumber().equals("100A") && this.stringExists(parsedAddress.getPreThoroughfareType()) && parsedAddress.getPreThoroughfareType().equalsIgnoreCase("COTE") && this.stringExists(parsedAddress.getUnitType()) && parsedAddress.getUnitType().equalsIgnoreCase("APP") && this.stringExists(parsedAddress.getUnitValue()) && parsedAddress.getUnitValue().equalsIgnoreCase("1")) {
            parsedAddress.setAddressNumber((String)null);
            parsedAddress.setPreThoroughfareType(null);
            parsedAddress.setUnitType(null);
            parsedAddress.setUnitValue(null);
            return parsedAddress;
        }
        DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: getParsedAddress(): \n" + inputStreetAddress.toString() + " \n did not parse properly.  Unable to proceed.");
        return null;
    }

    protected MapMarkerIndexKey makeStreetSearchKey(Address address, int sac) {
        FRA_SoundexKey sndxKey;
        String keyString = address.getGenericField4();
        if (StringUtilities.isEmpty((String)keyString)) {
            keyString = address.getMainAddress();
        }
        if ((sndxKey = (FRA_SoundexKey)this.makeSoundexKey(keyString)) == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)new MiSoundexKey((MiSoundexKey)sndxKey));
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address parsedAddress = this.getParsedStreet(input, preParsed);
        List possibleAddrs = this.getAllPossibleMainAddresses(parsedAddress);
        return possibleAddrs;
    }

    private List getAllPossibleMainAddresses(Address parsedAddress) {
        if (parsedAddress == null) {
            return Collections.EMPTY_LIST;
        }
        String primaryName = parsedAddress.getGenericField1();
        if (primaryName == null || primaryName.length() == 0) {
            primaryName = parsedAddress.getMainAddress();
            DataCreationLogger.getLogger().logInternalError("FRA_StreetDataSourceConvertor:: makeAllPossibleMainAddresses(): No GenericField1 in parsed address. (MainAddress: " + primaryName + ")");
        }
        List<String> uniqueMainAddrLines = this.createUniqueStreetNamesForSoundexGeneration(primaryName);
        ArrayList<AddressImpl> list = new ArrayList<AddressImpl>();
        for (String s : uniqueMainAddrLines) {
            AddressImpl tmp = new AddressImpl(parsedAddress);
            tmp.setGenericField4(s);
            list.add(tmp);
        }
        return list;
    }

    public List<String> createUniqueStreetNamesForSoundexGeneration(String main) {
        if (!StringUtilities.isEmpty((String)main)) {
            ISoundexKey key;
            String temp;
            int idx;
            ISoundexKey key2;
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<ISoundexKey> uniqueSoundexKeys = new ArrayList<ISoundexKey>();
            if (!list.contains(main = FRA_Standardizer.standardizeString(main)) && !uniqueSoundexKeys.contains(key2 = this.makeSoundexKey(main))) {
                list.add(main);
                uniqueSoundexKeys.add(key2);
            }
            if ((idx = (temp = main).lastIndexOf(32)) > 0 && !list.contains(temp = temp.substring(idx + 1)) && !uniqueSoundexKeys.contains(key = this.makeSoundexKey(temp))) {
                list.add(temp);
                uniqueSoundexKeys.add(key);
            }
            if (!(StringUtilities.isEmpty((String)(temp = FRA_Standardizer.stripDigitsAndOrdinals(main))) || list.contains(temp) || uniqueSoundexKeys.contains(key = this.makeSoundexKey(temp)))) {
                list.add(temp);
                uniqueSoundexKeys.add(key);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }
}

