/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.filters;

import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class BetterCandidateFilterRule
implements ICloseMatchFilterRule {
    private static final double BETTER_MAIN_ADDRESS_THRESHHOLD = 0.2;
    private static final double BETTER_AREANAME1_THRESHHOLD = 0.2;
    private static final double BETTER_AREANAME2_THRESHHOLD = 0.2;
    private static final double BETTER_AREANAME3_THRESHHOLD = 0.2;
    private static final double BETTER_AREANAME4_THRESHHOLD = 0.2;
    private static final double BETTER_PLACE_NAME_THRESHHOLD = 0.2;

    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        FRA_InternalCandidateAddress best = (FRA_InternalCandidateAddress)bestCandidate;
        FRA_InternalCandidateAddress other = (FRA_InternalCandidateAddress)otherCandidate;
        boolean useAN4 = best.isScoredAN3againstAN4() || other.isScoredAN3againstAN4() || !StringUtilities.isEmpty((String)inputAddresses[0].getAreaName4());
        boolean bestIsBetter = false;
        CompareResult result = this.compare(best.getMainAddress(), best.getMainAddressScore(), other.getMainAddress(), other.getMainAddressScore(), 0.2);
        if (!(!(bestIsBetter |= result == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getAddressNumberScore(), other.getAddressNumberScore())) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getPreThoroughfareTypeScore(), other.getPreThoroughfareTypeScore())) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getPostThoroughfareTypeScore(), other.getPostThoroughfareTypeScore())) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getPostDirectionalScore(), other.getPostDirectionalScore())) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getAreaName1(), best.getAreaName1Score(), other.getAreaName1(), other.getAreaName1Score(), 0.2)) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getAreaName2(), best.getAreaName2Score(), other.getAreaName2(), other.getAreaName2Score(), 0.2)) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getAreaName3(), best.getAreaName3Score(), other.getAreaName3(), other.getAreaName3Score(), 0.2)) == CompareResult.BETTER) && result != CompareResult.EQUAL || useAN4 && !(bestIsBetter |= (result = this.compare(best.getAreaName4(), best.getAreaName4Score(), other.getAreaName4(), other.getAreaName4Score(), 0.2)) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.comparePostCodes(best.getPostCode1(), best.getPostCode1Score(), other.getPostCode1(), other.getPostCode1Score(), inputAddresses[0].getPostCode1())) == CompareResult.BETTER) && result != CompareResult.EQUAL || !(bestIsBetter |= (result = this.compare(best.getPlaceName(), best.getPlaceNameScore(), other.getPlaceName(), other.getPlaceNameScore(), 0.2)) == CompareResult.BETTER) && result != CompareResult.EQUAL)) {
            return bestIsBetter;
        }
        return false;
    }

    private CompareResult compare(String string1, double score1, String string2, double score2, double threshhold) {
        if (score1 - score2 >= threshhold) {
            return CompareResult.BETTER;
        }
        if (score1 == score2 && score1 == 0.0) {
            return CompareResult.EQUAL;
        }
        if (score1 == score2) {
            if (string1 != null) {
                return string1.equals(string2) ? CompareResult.EQUAL : CompareResult.NOT_BETTER;
            }
            if (string2 == null) {
                return CompareResult.EQUAL;
            }
        } else if (score1 == 1.0) {
            return CompareResult.BETTER;
        }
        return CompareResult.NOT_BETTER;
    }

    private CompareResult compare(double score1, double score2) {
        if (score1 > score2) {
            return CompareResult.BETTER;
        }
        if (score1 == score2) {
            return CompareResult.EQUAL;
        }
        return CompareResult.NOT_BETTER;
    }

    private CompareResult comparePostCodes(String pc1, double score1, String pc2, double score2, String inputPC) {
        if (pc1 != null && !pc1.equals(pc2)) {
            if (score1 == 1.0) {
                return CompareResult.BETTER;
            }
            if (score2 == 1.0) {
                return CompareResult.NOT_BETTER;
            }
            if (this.isPartialPostcodeMatch(inputPC, pc1)) {
                if (!this.isPartialPostcodeMatch(inputPC, pc2)) {
                    return CompareResult.BETTER;
                }
            } else if (this.isPartialPostcodeMatch(inputPC, pc2)) {
                return CompareResult.NOT_BETTER;
            }
        } else if (pc1 == null && pc2 != null) {
            return CompareResult.NOT_BETTER;
        }
        return CompareResult.EQUAL;
    }

    private boolean isPartialPostcodeMatch(String inputPC, String candPC) {
        if (inputPC != null && inputPC.length() == 5 && candPC != null && candPC.length() == 5) {
            return inputPC.substring(0, 2).equals(candPC.substring(0, 2));
        }
        return false;
    }

    private static enum CompareResult {
        BETTER,
        EQUAL,
        NOT_BETTER;

    }
}

