/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class FRA_FinalDemoteDuplicateRecordsFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        if (!this.scoresMatch(best, other)) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getFormattedLocationAddress(), (String)other.getFormattedLocationAddress()) || !StringUtilities.equalStrings((String)best.getFormattedStreetAddress(), (String)other.getFormattedStreetAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getPlaceName(), (String)other.getPlaceName())) {
            return false;
        }
        if (!this.areaNamesMatch(best, other)) {
            return false;
        }
        if (!this.additionalFieldsMatch(best, other)) {
            return false;
        }
        return StringUtilities.equalStrings((String)best.getAddressNumber(), (String)other.getAddressNumber());
    }

    private boolean scoresMatch(InternalCandidateAddress best, InternalCandidateAddress other) {
        return best.getCombinedAddressScore() == other.getCombinedAddressScore() && best.getMainAddressScore() == other.getMainAddressScore() && best.getAreaName1Score() == other.getAreaName1Score() && best.getAreaName2Score() == other.getAreaName2Score() && best.getAreaName3Score() == other.getAreaName3Score() && best.getAreaName4Score() == other.getAreaName4Score() && best.getPostCode1Score() == other.getPostCode1Score() && best.getPostCode2Score() == other.getPostCode2Score() && best.getGenericField1Score() == other.getGenericField1Score() && best.getGenericField2Score() == other.getGenericField2Score() && best.getGenericField3Score() == other.getGenericField3Score() && best.getGenericField4Score() == other.getGenericField4Score() && best.getPlaceNameScore() == other.getPlaceNameScore() && best.getPostAddressScore() == other.getPostAddressScore() && best.getPreAddressScore() == other.getPreAddressScore() && best.getPreThoroughfareTypeScore() == other.getPreThoroughfareTypeScore() && best.getPostThoroughfareTypeScore() == other.getPostThoroughfareTypeScore() && best.getUnitTypeScore() == other.getUnitTypeScore() && best.getAdditionalParserFieldsScore() == other.getAdditionalParserFieldsScore() && best.getCombinedAdditionalFieldScore() == other.getCombinedAdditionalFieldScore() && best.getCntAddressNumberFieldsMatched() == other.getCntAddressNumberFieldsMatched() && best.getDictionaryPriority() == other.getDictionaryPriority();
    }

    private boolean areaNamesMatch(InternalCandidateAddress best, InternalCandidateAddress other) {
        return StringUtilities.equalStrings((String)best.getAreaName1(), (String)other.getAreaName1()) && StringUtilities.equalStrings((String)best.getAreaName2(), (String)other.getAreaName2()) && StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3()) && StringUtilities.equalStrings((String)best.getAreaName4(), (String)other.getAreaName4());
    }

    private boolean additionalFieldsMatch(InternalCandidateAddress best, InternalCandidateAddress other) {
        HashMap bestMap = best.getAdditionalFields();
        HashMap otherMap = other.getAdditionalFields();
        if (!bestMap.keySet().equals(otherMap.keySet())) {
            return false;
        }
        for (String key : bestMap.keySet()) {
            if (StringUtilities.equalStrings((String)((String)bestMap.get(key)), (String)((String)otherMap.get(key)))) continue;
            return false;
        }
        return true;
    }
}

