/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class InputCompoundNumberFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        InternalCandidateAddress best = (InternalCandidateAddress)bestCandidate;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCandidate;
        ParsedNumber inputNumber = inputAddresses[0].getParsedAddressNumber();
        if (inputNumber == null || inputNumber.getSuffixNumber() == 0L) {
            return false;
        }
        if (best.hasMatchingRange() && other.hasMatchingRange() && StringUtilities.equalStrings((String)best.getMainAddress(), (String)other.getMainAddress()) && StringUtilities.equalStrings((String)best.getPreThoroughfareType(), (String)other.getPreThoroughfareType()) && StringUtilities.equalStrings((String)best.getPostThoroughfareType(), (String)other.getPostThoroughfareType()) && StringUtilities.equalStrings((String)best.getPostDirectional(), (String)other.getPostDirectional()) && StringUtilities.equalStrings((String)best.getAreaName1(), (String)other.getAreaName1()) && StringUtilities.equalStrings((String)best.getAreaName2(), (String)other.getAreaName2()) && StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3()) && StringUtilities.equalStrings((String)best.getAreaName4(), (String)other.getAreaName4()) && best.getPlaceNameScore() == other.getPlaceNameScore() && StringUtilities.equalStrings((String)best.getPostCode1(), (String)other.getPostCode1())) {
            Range bestRange = best.getSegment().getRangeAt(best.getMatchedRangeNumber(), best.getSegmentSide());
            Range otherRange = other.getSegment().getRangeAt(other.getMatchedRangeNumber(), other.getSegmentSide());
            if (bestRange != null && otherRange != null) {
                ParsedNumber bestNum = bestRange.getMatchedRangeNumber();
                ParsedNumber otherNum = otherRange.getMatchedRangeNumber();
                if (bestNum.getAddressNumber() != otherNum.getAddressNumber() && bestNum.getAddressNumber() == inputNumber.getAddressNumber()) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

