/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.filters;

import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class RemoveEquidistantHouseNumberFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        boolean useAN4;
        FRA_InternalCandidateAddress best = (FRA_InternalCandidateAddress)bestCandidate;
        FRA_InternalCandidateAddress other = (FRA_InternalCandidateAddress)otherCandidate;
        ParsedNumber inputNumber = inputAddresses[0].getParsedAddressNumber();
        boolean bl = useAN4 = best.isScoredAN3againstAN4() || other.isScoredAN3againstAN4() || !StringUtilities.isEmpty((String)inputAddresses[0].getAreaName4());
        if (best.getMainAddressScore() >= other.getMainAddressScore() && best.getPlaceNameScore() == other.getPlaceNameScore() && best.getAreaName1Score() == other.getAreaName1Score() && best.getAreaName2Score() == other.getAreaName2Score() && best.getAreaName3Score() == other.getAreaName3Score() && (!useAN4 || best.getAreaName4Score() == other.getAreaName4Score()) && best.getPostCode1Score() >= other.getPostCode1Score() && StringUtilities.equalStrings((String)best.getPreThoroughfareType(), (String)other.getPreThoroughfareType()) && StringUtilities.equalStrings((String)best.getPostThoroughfareType(), (String)other.getPostThoroughfareType()) && StringUtilities.equalStrings((String)best.getPostDirectional(), (String)other.getPostDirectional())) {
            ParsedNumber bestNumber;
            if (inputNumber == null || best.hasMatchingRange() || other.hasMatchingRange()) {
                return false;
            }
            if (!inputNumber.isEmpty() && (bestNumber = best.getParsedAddressNumber()) != null && !bestNumber.isEmpty()) {
                ParsedNumber otherNumber = other.getParsedAddressNumber();
                if (otherNumber == null || otherNumber.isEmpty()) {
                    return true;
                }
                long bestOffset = inputNumber.computeDifference(bestNumber, 1);
                long otherOffset = inputNumber.computeDifference(otherNumber, 1);
                long best2 = 0L;
                long other2 = 0L;
                if (inputNumber.getSuffixNumberExists()) {
                    ParsedNumber secondHalf = new ParsedNumber(inputNumber.getSuffixNumber());
                    best2 = secondHalf.computeDifference(bestNumber, 1);
                    other2 = secondHalf.computeDifference(otherNumber, 1);
                }
                if (bestOffset <= otherOffset && best.getPostCode1Score() >= other.getPostCode1Score() && best.getPostCode2Score() >= other.getPostCode2Score() && best2 <= other2) {
                    return true;
                }
            }
        }
        return false;
    }
}

