/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.parser;

import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FRA_ParsePostAddressRule
implements IParseRule {
    private static final String TAG_CITY = "CITY";
    private static final String TAG_REGION = "REGION";
    private static final String TAG_POSTCODE = "POSTCODE";
    private static final String TAG_CEDEX = "CEDEX";
    private static final String TAG_MILITARY = "MILITARY";
    private static final List<String> citiesWithArrondissements;
    private static final Pattern POSTCODE_REGEX;
    private static final Pattern CEDEX_REGEX;
    private static final int CEDEX_NUMBER_REGEX_GROUP = 2;
    private static final Pattern MILITARY_REGEX;
    private static final int MAX_REGION_WORD_LENGTH = 5;
    private static final Set m_regionEndings;
    private static final Map m_regionNames;
    private String m_savedCedexNumber = null;
    private String m_savedMilitary = null;
    public static final String SECONDARY_INPUT_TOWN = "SECONDARY_INPUT_TOWN";

    static void populateRegionNames(Map names) {
        names.put("ALSACE", "ALSACE");
        names.put("AQUITAINE", "AQUITAINE");
        names.put("AUVERGNE", "AUVERGNE");
        names.put("BASSE NORMANDIE", "BASSE NORMANDIE");
        names.put("BOURGOGNE", "BOURGOGNE");
        names.put("BRETAGNE", "BRETAGNE");
        names.put("CENTRE", "CENTRE");
        names.put("CHAMPAGNE ARDENNE", "CHAMPAGNE ARDENNE");
        names.put("CORSE", "CORSE");
        names.put("FRANCHE COMTE", "FRANCHE COMTE");
        names.put("HAUTE NORMANDIE", "HAUTE NORMANDIE");
        names.put("ILE DE FRANCE", "ILE FRANCE");
        names.put("ILE FRANCE", "ILE FRANCE");
        names.put("LANGUEDOC ROUSSILLON", "LANGUEDOC ROUSSILLON");
        names.put("LIMOUSIN", "LIMOUSIN");
        names.put("LORRAINE", "LORRAINE");
        names.put("MIDI PYRENEES", "MIDI PYRENEES");
        names.put("NORD PAS DE CALAIS", "NORD PAS CALAIS");
        names.put("NORD PAS CALAIS", "NORD PAS CALAIS");
        names.put("PAYS DE LA LOIRE", "PAYS LOIRE");
        names.put("PAYS LOIRE", "PAYS LOIRE");
        names.put("PICARDIE", "PICARDIE");
        names.put("POITOU CHARENTES", "POITOU CHARENTES");
        names.put("PROVENCE ALPES COTE D'AZUR", "PROVENCE ALPES COTE AZUR");
        names.put("PROVENCE ALPES COTE D AZUR", "PROVENCE ALPES COTE AZUR");
        names.put("PROVENCE ALPES COTE AZUR", "PROVENCE ALPES COTE AZUR");
        names.put("RHONE ALPES", "RHONE ALPES");
    }

    public void parse(Address orig, Address pa, IConstraints constraints) throws ParserException {
        String tmp;
        this.RemoveBadCharsLastLine(pa);
        String postAddress = orig.getPostAddress();
        TaggedTokenList tokens = null;
        if (postAddress != null) {
            pa.setPostAddress(null);
            postAddress = FRA_Standardizer.toUpperCaseWithoutAccents(postAddress);
            postAddress = postAddress.replaceAll(",", " , ");
            tokens = new TaggedTokenList(new StringTokenizer(postAddress, " ()-"));
        } else {
            tokens = new TaggedTokenList();
        }
        pa.setAreaName1(FRA_Standardizer.toUpperCaseWithoutAccents(pa.getAreaName1()));
        pa.setAreaName3(FRA_Standardizer.toUpperCaseWithoutAccents(pa.getAreaName3()));
        this.tagPostCode(pa, tokens);
        this.tagSpecialWords(pa, tokens);
        this.tagRegion(pa, tokens);
        this.tagCity(pa, tokens);
        this.setPostCode(orig, pa, tokens);
        this.setRegion(orig, pa, tokens);
        this.setCity(orig, pa, tokens);
        this.setSpecialWords(pa, tokens);
        String an = pa.getAreaName2();
        if (!StringUtilities.isEmpty((String)an)) {
            tmp = FRA_Standardizer.standardizeAreaName(an);
            if (!StringUtilities.isEmpty((String)tmp)) {
                pa.setAreaName2(tmp);
            } else {
                pa.setAreaName2(an.toUpperCase());
            }
        }
        if (!StringUtilities.isEmpty((String)(an = pa.getAreaName4()))) {
            tmp = FRA_Standardizer.standardizeAreaName(an);
            if (!StringUtilities.isEmpty((String)tmp)) {
                pa.setAreaName4(tmp);
            } else {
                pa.setAreaName4(an.toUpperCase());
            }
        }
        String cedexVal = null;
        for (int j = 0; j < tokens.size(); ++j) {
            String val;
            if (!tokens.get(j).isTagged() || !tokens.get(j).getTag().equals(TAG_CEDEX) || (val = tokens.get(j).getValue()).equals(TAG_CEDEX.toString())) continue;
            cedexVal = val;
            break;
        }
        if (cedexVal != null || this.m_savedCedexNumber != null) {
            pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2, TAG_CEDEX);
            if (cedexVal != null) {
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2_NUMBER, cedexVal);
            } else {
                pa.getAdditionalFields().put(AddressImpl.KEY_POBOX2_NUMBER, this.m_savedCedexNumber);
            }
        }
    }

    protected void tagPostCode(Address pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        for (int idx = 0; idx < tokens.size(); ++idx) {
            String currentValue;
            TaggedToken currentToken = tokens.get(idx);
            if (currentToken.isTagged() || !FRA_ParsePostAddressRule.isValidPostcode(currentValue = currentToken.getValue())) continue;
            currentToken.setTag(TAG_POSTCODE);
            return;
        }
    }

    protected void setPostCode(Address ura, Address pa, TaggedTokenList tokens) {
        String tmp = pa.getPostCode1();
        if (tmp != null) {
            if (!FRA_ParsePostAddressRule.isValidPostcode(tmp = tmp.trim())) {
                TaggedTokenList postalTokens = new TaggedTokenList(new StringTokenizer(FRA_Standardizer.toUpperCaseWithoutAccents(tmp).replaceAll(",", " , "), " ()-"));
                this.tagPostCode(pa, postalTokens);
                tmp = postalTokens.getTaggedTokenString(TAG_POSTCODE).trim();
            }
        } else {
            tmp = tokens.getTaggedTokenString(TAG_POSTCODE).trim();
        }
        if (tmp != null && tmp.length() == 4) {
            tmp = 0 + tmp;
        }
        pa.setPostCode1(tmp);
        pa.setPostCode2("");
    }

    protected void tagRegion(Address pa, TaggedTokenList tokens) {
        for (int idx = tokens.size() - 1; idx >= 0; --idx) {
            TaggedToken currentToken = tokens.get(idx);
            if (currentToken.isTagged()) continue;
            String testState = currentToken.getValue();
            tokens.setTag(idx, TAG_REGION);
            int tokensConsidered = 1;
            if (idx > 0 && m_regionEndings.contains(testState)) {
                int tmpIdx;
                for (int i = 1; i <= 5 && (tmpIdx = idx - i) >= 0 && !tokens.isTagged(tmpIdx); ++i) {
                    tokens.setTag(tmpIdx, TAG_REGION);
                    ++tokensConsidered;
                }
            }
            while (tokensConsidered > 0) {
                String regionName = tokens.getTaggedTokenString(TAG_REGION);
                if (!StringUtilities.isEmpty((String)regionName) && m_regionNames.get(regionName) != null) {
                    return;
                }
                tokens.setTag(idx - --tokensConsidered, null);
            }
        }
    }

    protected void setRegion(Address ura, Address pa, TaggedTokenList tokens) {
        String region = pa.getAreaName1();
        if (!StringUtilities.isEmpty((String)region)) {
            String tmp = FRA_Standardizer.standardizeAreaName(region);
            tmp = !StringUtilities.isEmpty((String)tmp) ? this.getRegionName(tmp) : this.getRegionName(region);
            if (!StringUtilities.isEmpty((String)tmp)) {
                pa.setAreaName1(tmp);
            } else {
                pa.setAreaName1(region.toUpperCase());
            }
            return;
        }
        region = tokens.getTaggedTokenString(TAG_REGION);
        if (!StringUtilities.isEmpty((String)region)) {
            region = this.getRegionName(region);
        }
        if (!StringUtilities.isEmpty((String)region)) {
            pa.setAreaName1(region);
        }
    }

    protected void tagCity(Address pa, TaggedTokenList tokens) {
        if (tokens == null || tokens.size() == 0) {
            return;
        }
        int startPosition = tokens.indexOfFirstUntaggedToken();
        if (startPosition >= 0 && startPosition < tokens.size()) {
            TaggedToken t;
            for (int i = startPosition; i < tokens.size() && !(t = tokens.get(i)).isTagged(); ++i) {
                t.setTag(TAG_CITY);
            }
        }
    }

    protected void setCity(Address ura, Address pa, TaggedTokenList tokens) {
        String tmp;
        String city;
        block13: {
            int idx;
            city = pa.getAreaName3();
            if (StringUtilities.isEmpty((String)city) && StringUtilities.isEmpty((String)(city = tokens.getTaggedTokenString(TAG_CITY))) && StringUtilities.isEmpty((String)pa.getPostCode1()) && StringUtilities.isEmpty((String)ura.getAreaName1()) && !StringUtilities.isEmpty((String)pa.getAreaName1())) {
                city = pa.getAreaName1();
                pa.setAreaName1(null);
            }
            if (!StringUtilities.isEmpty((String)city)) {
                idx = -1;
                idx = city.lastIndexOf(32);
                if (idx > 0) {
                    String tmpcity;
                    tmp = city.substring(idx + 1);
                    if (StringUtilities.isNumeric((String)tmp)) {
                        tmpcity = city.substring(0, idx);
                        if (this.populateCityAndArrondissement(tmpcity, tmp, pa)) {
                            city = tmpcity;
                        }
                    } else {
                        idx = city.indexOf(32);
                        tmp = city.substring(0, idx);
                        if (StringUtilities.isNumeric((String)tmp) && this.populateCityAndArrondissement(tmpcity = city.substring(idx + 1), tmp, pa)) {
                            city = tmpcity;
                        }
                    }
                }
            }
            idx = -1;
            if (!StringUtilities.isEmpty((String)city) && (idx = city.indexOf(",")) != -1) {
                String lastPart = city;
                do {
                    String firstPart = FRA_Standardizer.standardizeAreaName(lastPart.substring(0, idx));
                    lastPart = lastPart.substring(idx + 1);
                    if (StringUtilities.isEmpty((String)firstPart)) continue;
                    city = firstPart;
                    pa.getAdditionalFields().put(SECONDARY_INPUT_TOWN, FRA_Standardizer.standardizeAreaName(lastPart));
                    break block13;
                } while ((idx = lastPart.indexOf(",")) != -1);
                if (!StringUtilities.isEmpty((String)(lastPart = FRA_Standardizer.standardizeAreaName(lastPart)))) {
                    city = lastPart;
                }
            }
        }
        if (!StringUtilities.isEmpty((String)(tmp = FRA_Standardizer.standardizeAreaName(city)))) {
            pa.setAreaName3(tmp);
        } else {
            if (city != null) {
                city = city.toUpperCase();
            }
            pa.setAreaName3(city);
        }
    }

    private boolean populateCityAndArrondissement(String city, String arrondissement, Address pa) {
        if (citiesWithArrondissements.contains(city)) {
            StringBuilder sb = new StringBuilder();
            int intVal = Integer.valueOf(arrondissement);
            sb.append(intVal);
            if (intVal == 1) {
                sb.append("ER ARRONDISSEMENT ");
            } else {
                sb.append("EME ARRONDISSEMENT ");
            }
            sb.append(city.toUpperCase());
            pa.setAreaName4(FRA_Standardizer.standardizeAreaName(sb.toString()));
            return true;
        }
        return false;
    }

    private void tagSpecialWords(Address pa, TaggedTokenList tokens) {
        String city;
        if (tokens != null) {
            TaggedToken prevToken = null;
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                TaggedToken currentToken = tokens.get(idx);
                if (currentToken.isTagged()) {
                    prevToken = null;
                    continue;
                }
                String currentValue = currentToken.getValue();
                if (TAG_CEDEX.equals(currentValue)) {
                    currentToken.setTag(TAG_CEDEX);
                    if (prevToken != null && StringUtilities.isNumeric((String)prevToken.getValue())) {
                        prevToken.setTag(TAG_CEDEX);
                    }
                    prevToken = null;
                    break;
                }
                if ("AIR".equals(currentValue) || "NAVAL".equals(currentValue) || "ARMEES".equals(currentValue)) {
                    currentToken.setTag(TAG_MILITARY);
                    prevToken = null;
                    break;
                }
                prevToken = currentToken;
            }
        }
        if (!StringUtilities.isEmpty((String)(city = pa.getAreaName3()))) {
            Matcher m = CEDEX_REGEX.matcher(city);
            if (m.find()) {
                this.m_savedCedexNumber = m.group(2);
                pa.setAreaName3(m.replaceAll(""));
            }
            if ((m = MILITARY_REGEX.matcher(city)).find()) {
                this.m_savedMilitary = m.group(0);
                pa.setAreaName3(m.replaceAll(""));
            }
        }
    }

    private void setSpecialWords(Address pa, TaggedTokenList tokens) {
        if (StringUtilities.isEmpty((String)pa.getAreaName3()) && StringUtilities.isEmpty((String)pa.getPostCode1())) {
            if (!StringUtilities.isEmpty((String)this.m_savedCedexNumber)) {
                pa.setPostCode1(this.m_savedCedexNumber);
                return;
            }
            List tmp = tokens.getTaggedTokens(TAG_CEDEX);
            if (tmp != null && tmp.size() > 1) {
                pa.setPostCode1((String)tmp.get(1));
                return;
            }
            if (!StringUtilities.isEmpty((String)this.m_savedMilitary)) {
                pa.setAreaName3(this.m_savedMilitary);
                return;
            }
            tmp = tokens.getTaggedTokens(TAG_MILITARY);
            if (tmp != null && tmp.size() > 0) {
                pa.setAreaName3((String)tmp.get(0));
                return;
            }
        }
    }

    static boolean isValidPostcode(String text) {
        return text != null && POSTCODE_REGEX.matcher(text.trim()).matches();
    }

    protected String getRegionName(String region) {
        String regionName;
        if (region != null && (regionName = (String)m_regionNames.get(region = region.trim().toUpperCase())) != null) {
            return regionName;
        }
        return "";
    }

    private void RemoveBadCharsLastLine(Address pa) {
        String[] LastLineParts = new String[5];
        StringBuffer[] newAddrs = new StringBuffer[5];
        LastLineParts[0] = pa.getPostAddress();
        int start = 0;
        int end = 1;
        if (LastLineParts[0] == null) {
            start = 1;
            end = 5;
            LastLineParts[1] = pa.getAreaName1();
            LastLineParts[2] = pa.getAreaName3();
            LastLineParts[3] = pa.getPostCode1();
            LastLineParts[4] = pa.getPostCode2();
        }
        for (int i = start; i < end; ++i) {
            if (LastLineParts[i] == null) continue;
            block4: for (int j = 0; j < LastLineParts[i].length(); ++j) {
                char thischar = LastLineParts[i].charAt(j);
                int ttype = Character.getType(thischar);
                switch (ttype) {
                    case 0: 
                    case 12: 
                    case 15: 
                    case 26: {
                        if (newAddrs[i] != null) {
                            newAddrs[i].append(' ');
                            continue block4;
                        }
                        newAddrs[i] = new StringBuffer();
                        newAddrs[i].append(' ');
                        continue block4;
                    }
                    default: {
                        if (newAddrs[i] == null) {
                            newAddrs[i] = new StringBuffer("");
                            newAddrs[i].append(thischar);
                            continue block4;
                        }
                        newAddrs[i].append(thischar);
                    }
                }
            }
            if (newAddrs[i] == null) continue;
            if (i == 0) {
                pa.setPostAddress(newAddrs[0].toString().trim());
                continue;
            }
            if (i == 1) {
                pa.setAreaName1(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 2) {
                pa.setAreaName3(newAddrs[i].toString().trim());
                continue;
            }
            if (i == 3) {
                pa.setPostCode1(newAddrs[i].toString().trim());
                continue;
            }
            if (i != 4) continue;
            pa.setPostCode2(newAddrs[i].toString().trim());
        }
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("PARIS");
        temp.add("MARSEILLES");
        temp.add("LYON");
        citiesWithArrondissements = Collections.unmodifiableList(temp);
        POSTCODE_REGEX = Pattern.compile("^(\\d{4,5})$");
        CEDEX_REGEX = Pattern.compile("\\bCEDEX(\\s+(\\d+))?\\b", 2);
        MILITARY_REGEX = Pattern.compile("\\b(AIR|ARMEES|NAVAL)\\b", 2);
        String[] prEndings = new String[]{"NORMANDIE", "ARDENNE", "COMT\u00c9", "COMTE", "FRANCE", "ROUSSILLON", "PYR\u00c9N\u00c9ES", "PYRENEES", "CALAIS", "LOIRE", "CHARENTES", "D'AZUR", "AZUR", "ALPES"};
        HashSet<String> regionEndings = new HashSet<String>(prEndings.length, 1.0f);
        for (int i = 0; i < prEndings.length; ++i) {
            regionEndings.add(prEndings[i]);
        }
        m_regionEndings = Collections.unmodifiableSet(regionEndings);
        HashMap regionNames = new HashMap();
        FRA_ParsePostAddressRule.populateRegionNames(regionNames);
        m_regionNames = Collections.unmodifiableMap(regionNames);
    }
}

