/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.parser;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.regex.Pattern;

public class FRA_Standardizer {
    private static String[] stdCityRegexes = new String[]{"\\bSTE\\b", "\\bST\\b", "(\\bS\\b)(?!(\\W|\\s)*$)"};
    private static String[] stdCityReplacements = new String[]{"SAINTE", "SAINT", "SAINT"};
    private static final Pattern[] stdCityPatterns;
    private static final Pattern[] commonWordPatterns;
    private static String[] commonWordRegexes;
    private static String[] commonWordReplacements;
    private static final Pattern[] punctuationFixerPatterns;
    private static String[] punctuationFixerRegexes;
    private static String[] punctuationFixerReplacements;
    private static final Pattern[] accentPatterns;
    private static String[] accentRegexes;
    private static String[] accentReplacements;
    private static final Pattern[] punctuationRemoverPatterns;
    private static String[] punctuationRemoverRegexes;
    private static String[] punctuationRemoverReplacements;
    private static String[] streetAbbrRegexes;
    private static String[] streetAbbrReplacements;
    private static final Pattern[] streetAbbrPatterns;
    private static String[] postboxRegexes;
    private static String[] postboxReplacements;
    public static final Pattern[] postboxPatterns;
    private static String[] numberToWordRegexes;
    private static String[] numberToWordReplacements;
    private static final Pattern[] numberToWordPatterns;
    private static String[] wordToNumberRegexes;
    private static String[] wordToNumberReplacements;
    private static final Pattern[] wordToNumberPatterns;
    private static final Pattern[] ordinalToWordPatterns;
    private static String[] wordToOrdinalRegexes;
    private static String[] wordToOrdinalReplacements;
    private static final Pattern[] wordToOrdinalPatterns;
    private static String[] digitAndOrdinalRegexes;
    private static final Pattern[] digitAndOrdinalPatterns;
    private static String[] ordinalIndicatorRegexes;
    private static String[] ordinalIndicatorReplacements;
    private static final Pattern[] ordinalIndicatorPatterns;
    private static String[] twoPassStandardizeRegexes;
    private static String[] twoPassStandardizeReplacements;
    private static final Pattern[] twoPassStandardizePatterns;
    private static final String ORDINAL_TO_WORD_STARTEX = "(?<=(^|\\s))";
    private static final String ORDINAL_TO_WORD_ENDEX = "\\s?E(ME)?(?=($|\\s))";
    private static final String ORDINAL_TO_WORD_PREMIER_ENDEX = "\\s?ER(?=($|\\s))";
    private static String[] ordinalToWordReplacements;
    private static String[] numberWordsToRomanNumeralsRegexes;
    private static String[] numberWordsToRomanNumeralReplacements;
    private static final Pattern[] numberWordsToRomanNumeralPatterns;

    private static String[] buildOrdinalToWordRegexes() {
        String[] regex = new String[ordinalToWordReplacements.length];
        regex[0] = "(?<=(^|\\s))1\\s?ER(?=($|\\s))";
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 30; ++i) {
            sb.setLength(0);
            sb.append(ORDINAL_TO_WORD_STARTEX);
            sb.append(i + 1);
            sb.append(ORDINAL_TO_WORD_ENDEX);
            regex[i] = sb.toString();
        }
        int idx = 31;
        for (int i = 40; i <= 100; i += 10) {
            sb.setLength(0);
            sb.append(ORDINAL_TO_WORD_STARTEX);
            sb.append(i);
            sb.append(ORDINAL_TO_WORD_ENDEX);
            regex[idx] = sb.toString();
            ++idx;
        }
        regex[idx] = "(?<=(^|\\s))1\\s?ERE(?=($|\\s))";
        regex[++idx] = FRA_Standardizer.wrapTokens("I");
        regex[++idx] = FRA_Standardizer.wrapTokens("II");
        regex[++idx] = FRA_Standardizer.wrapTokens("III");
        regex[++idx] = FRA_Standardizer.wrapTokens("IV");
        regex[++idx] = FRA_Standardizer.wrapTokens("V");
        regex[++idx] = FRA_Standardizer.wrapTokens("VI");
        regex[++idx] = FRA_Standardizer.wrapTokens("VII");
        regex[++idx] = FRA_Standardizer.wrapTokens("VIII");
        regex[++idx] = FRA_Standardizer.wrapTokens("IX");
        regex[++idx] = FRA_Standardizer.wrapTokens("X");
        regex[++idx] = FRA_Standardizer.wrapTokens("XI");
        regex[++idx] = FRA_Standardizer.wrapTokens("XII");
        regex[++idx] = FRA_Standardizer.wrapTokens("XIII");
        regex[++idx] = FRA_Standardizer.wrapTokens("XIV");
        regex[++idx] = FRA_Standardizer.wrapTokens("XV");
        ++idx;
        return regex;
    }

    private static String wrapTokens(String token) {
        StringBuilder sb = new StringBuilder("(?<=(^|\\s))(?=$|\\s)");
        sb.insert(11, token);
        return sb.toString();
    }

    public static String standardizeString(String input) {
        return FRA_Standardizer.standardize(input, streetAbbrPatterns, streetAbbrReplacements);
    }

    public static String standardizeAreaName(String input) {
        return FRA_Standardizer.standardize(input, stdCityPatterns, stdCityReplacements);
    }

    public static String standardizeCaseAndPunctuation(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        String upperCase = FRA_Standardizer.toUpperCaseWithoutAccents(input);
        upperCase = FRA_Standardizer.replacePunctuation(upperCase);
        return upperCase.trim();
    }

    private static String standardize(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        String upperCase = FRA_Standardizer.toUpperCaseWithoutAccents(input);
        upperCase = FRA_Standardizer.replacePunctuation(upperCase);
        String std = FRA_Standardizer.removeCommonWords(upperCase);
        if (StringUtilities.isEmpty((String)(std = FRA_Standardizer.replace(std, patterns, replacements)))) {
            return upperCase.trim();
        }
        return std.trim();
    }

    public static String standardizePostbox(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        return FRA_Standardizer.replace(input, postboxPatterns, postboxReplacements);
    }

    public static String toUpperCaseWithoutAccents(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        return FRA_Standardizer.replace(input.toUpperCase(), accentPatterns, accentReplacements);
    }

    static String removeCommonWords(String input) {
        return FRA_Standardizer.replace(input, commonWordPatterns, commonWordReplacements);
    }

    private static String fixDuplicatePunctuation(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        return FRA_Standardizer.replace(input, punctuationFixerPatterns, punctuationFixerReplacements).trim();
    }

    static String removePunctuation(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        input = FRA_Standardizer.replacePunctuation(input);
        return input.trim();
    }

    private static String replacePunctuation(String input) {
        return FRA_Standardizer.replace(input, punctuationRemoverPatterns, punctuationRemoverReplacements);
    }

    private static String replaceCommonWords(String input, Boolean removePunctuation) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        if (!removePunctuation.booleanValue()) {
            input = FRA_Standardizer.fixDuplicatePunctuation(input);
        }
        input = FRA_Standardizer.removeCommonWords(input);
        if (removePunctuation.booleanValue()) {
            input = FRA_Standardizer.replacePunctuation(input);
        }
        return input.trim();
    }

    public static String replaceNumbersWithWords(String input) {
        return FRA_Standardizer.replace(input, numberToWordPatterns, numberToWordReplacements);
    }

    public static String replaceWordsWithNumbers(String input) {
        if (input == null) {
            return null;
        }
        String s = FRA_Standardizer.replace(input, wordToNumberPatterns, wordToNumberReplacements);
        return FRA_Standardizer.fixDuplicatePunctuation(s.trim());
    }

    public static String replaceOrdinalsWithWords(String input) {
        if (input == null) {
            return null;
        }
        String s = FRA_Standardizer.replace(input, ordinalToWordPatterns, ordinalToWordReplacements);
        return FRA_Standardizer.fixDuplicatePunctuation(s.trim());
    }

    public static String replaceWordsWithOrdinals(String input) {
        if (input == null) {
            return null;
        }
        String s = FRA_Standardizer.replace(input, wordToOrdinalPatterns, wordToOrdinalReplacements);
        return FRA_Standardizer.fixDuplicatePunctuation(s.trim());
    }

    public static String stripDigitsAndOrdinals(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        for (int i = 0; i < digitAndOrdinalPatterns.length; ++i) {
            input = digitAndOrdinalPatterns[i].matcher(input).replaceAll("");
        }
        return input.trim();
    }

    public static String stripOrdinalIndicators(String input) {
        if (input == null) {
            return null;
        }
        String s = FRA_Standardizer.replace(input, ordinalIndicatorPatterns, ordinalIndicatorReplacements);
        return FRA_Standardizer.fixDuplicatePunctuation(s.trim());
    }

    public static String applyAlternateStandardization(String input, int index) {
        if (input == null) {
            return null;
        }
        if (index > twoPassStandardizeReplacements.length - 1) {
            return null;
        }
        return twoPassStandardizePatterns[index].matcher(input).replaceAll(twoPassStandardizeReplacements[index]);
    }

    public static String replaceNumbersAndWordsWithRomanNumerals(String input) {
        if (input == null) {
            return null;
        }
        String s = FRA_Standardizer.replace(input, numberWordsToRomanNumeralPatterns, numberWordsToRomanNumeralReplacements);
        return FRA_Standardizer.fixDuplicatePunctuation(s.trim());
    }

    private static Pattern[] preCompile(String[] regexes) {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        return patterns;
    }

    private static String replace(String input, Pattern[] patterns, String[] replacements) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        for (int i = 0; i < patterns.length; ++i) {
            input = patterns[i].matcher(input).replaceAll(replacements[i]);
        }
        return input;
    }

    static {
        commonWordRegexes = new String[]{"\\b(LE|LA|LES|UN|UNE|ET|EN|A|AU|AUX|DE|DU|DES|SUR|DANS)(\\s+|-|$)", "\\b((D|L)\\s*('|-|\\s)\\s*)"};
        commonWordReplacements = new String[]{"", "", ""};
        punctuationFixerRegexes = new String[]{"(\\W|_)\\1+"};
        punctuationFixerReplacements = new String[]{"$1"};
        accentRegexes = new String[]{"(\u00c0|\u00c1|\u00c2|\u00c3|\u00c4|\u00c5)", "(\u00c8|\u00c9|\u00ca|\u00cb)", "(\u00cc|\u00cd|\u00ce|\u00cf)", "(\u00d2|\u00d3|\u00d4|\u00d5|\u00d6|\u00d8)", "(\u00d9|\u00da|\u00db|\u00dc)", "\u00c7", "\u00d1", "\u00df", "\u0178"};
        accentReplacements = new String[]{"A", "E", "I", "O", "U", "C", "N", "SS", "Y"};
        punctuationRemoverRegexes = new String[]{"((^|\\b|_)(\\W|_)+)"};
        punctuationRemoverReplacements = new String[]{" "};
        streetAbbrRegexes = new String[]{"\\bPRSDT\\b", "\\bPDT\\b", "\\bPTE\\b", "\\GDE\\b", "\\bGD\\b", "\\bCDT\\b", "\\bCT\\b", "\\bCPT\\b", "\\bCAP\\b", "\\bCAPIT\\b", "\\bCAL\\b", "\\bCARD\\b", "\\bDR\\b", "\\bGAL\\b", "\\bGNL\\b", "\\bMAL\\b", "\\bANC\\b", "\\bAFN\\b", "\\b(STE|SAINTE|ST)\\b", "(\\bS\\b)(?!(\\W|\\s)*$)", "\\bCDG\\b", "\\bFFI\\b", "\\bRIMA\\b", "\\bDB\\b", "\\bFBG\\b"};
        streetAbbrReplacements = new String[]{"PRESIDENT", "PRESIDENT", "PETITE", "GRAND", "GRAND", "COMMANDANT", "COMMANDANT", "CAPITAINE", "CAPITAINE", "CAPITAINE", "CARDINAL", "CARDINAL", "DOCTOR", "GENERAL", "GENERAL", "MARECHAL", "ANCIEN", "AFRIQUE NORD", "SAINT", "SAINT", "CHARLES GAULLE", "FRENCH FORCES INTERIOR", "REGIMENT INFANTERIE MARINE", "DIVISION BLINDEE", "FAUBOURG"};
        postboxRegexes = new String[]{"\\b(B P|BP|BOITE|BOITE\\s?POSTALE)\\s*(\\d+)", "\\bBOITE\\s?POSTALE\\b", "\\b(C S|CS)\\s*(\\d+)", "\\b(COURSE\\s?SPECIALE\\s?)(\\d+)", "\\b(COURSE\\s?SPECIAL\\s?)(\\d+)"};
        postboxReplacements = new String[]{"BP $2", "BP", "CS $2", "CS $2", "CS $2"};
        numberToWordRegexes = new String[]{"\\b1\\b", "\\b2\\b", "\\b3\\b", "\\b4\\b", "\\b5\\b", "\\b6\\b", "\\b7\\b", "\\b8\\b", "\\b9\\b", "\\b10\\b", "\\b11\\b", "\\b12\\b", "\\b13\\b", "\\b14\\b", "\\b15\\b", "\\b16\\b", "\\b17\\b", "\\b18\\b", "\\b19\\b", "\\b20\\b", "\\b21\\b", "\\b22\\b", "\\b23\\b", "\\b24\\b", "\\b25\\b", "\\b26\\b", "\\b27\\b", "\\b28\\b", "\\b29\\b", "\\b30\\b", "\\b31\\b", "\\b100\\b"};
        numberToWordReplacements = new String[]{"UN", "DEUX", "TROIS", "QUATRE", "CINQ", "SIX", "SEPT", "HUIT", "NEUF", "DIX", "ONZE", "DOUZE", "TREIZE", "QUATORZE", "QUINZE", "SEIZE", "DIX SEPT", "DIX HUIT", "DIX NEUF", "VINGT", "VINGT ET UN", "VINGT DEUX", "VINGT TROIS", "VINGT QUATRE", "VINGT CINQ", "VINGT SIX", "VINGT SEPT", "VINGT HUIT", "VINGT NEUF", "TRENTE", "TRENTE ET UN", "CENT"};
        wordToNumberRegexes = new String[]{"\\bMILLE NEUF QUARANTE QUATRE\\b", "\\bMILLE NEUF QUARANTE CINQ\\b", "\\bONZE\\b", "\\bDOUZE\\b", "\\bTREIZE\\b", "\\bQUATORZE\\b", "\\bQUINZE\\b", "\\bSEIZE\\b", "\\bDIX SEPT\\b", "\\bDIX HUIT\\b", "\\bDIX NEUF\\b", "\\bVINGT ET UN\\b", "\\bVINGT DEUX\\b", "\\bVINGT TROIS\\b", "\\bVINGT QUATRE\\b", "\\bVINGT CINQ\\b", "\\bVINGT SIX\\b", "\\bVINGT SEPT\\b", "\\bVINGT HUIT\\b", "\\bVINGT NEUF\\b", "\\bTRENTE ET UN\\b", "(^|\\s)QUARANTE($|\\s)", "(^|\\s)CINQUANTE($|\\s)", "(^|\\s)SOIXANTE($|\\s)", "(^|\\s)SOIXANTE DIX($|\\s)", "(^|\\s)QUATRE VINGTS($|\\s)", "(^|\\s)QUATRE VINGT DIX($|\\s)", "(^|\\s)VINGT($|\\s)", "(^|\\s)TRENTE($|\\s)", "\\bCENT DIX\\b", "(^|\\s)CENT($|\\s)", "(^|\\s)UN($|\\s)", "(^|\\s)DEUX($|\\s)", "(^|\\s)TROIS($|\\s)", "(^|\\s)QUATRE($|\\s)", "(^|\\s)CINQ($|\\s)", "(^|\\s)SIX($|\\s)", "(^|\\s)SEPT($|\\s)", "(^|\\s)HUIT($|\\s)", "(^|\\s)NEUF($|\\s)", "(^|\\s)DIX($|\\s)", "(^|\\s)I($|\\s)", "(^|\\s)II($|\\s)", "(^|\\s)III($|\\s)", "(^|\\s)IV($|\\s)", "(^|\\s)V($|\\s)", "(^|\\s)VI($|\\s)", "(^|\\s)VII($|\\s)", "(^|\\s)VIII($|\\s)", "(^|\\s)IX($|\\s)", "(^|\\s)X($|\\s)", "(^|\\s)XI($|\\s)", "(^|\\s)XII($|\\s)", "(^|\\s)XIII($|\\s)", "(^|\\s)XIV($|\\s)", "(^|\\s)XV($|\\s)"};
        wordToNumberReplacements = new String[]{"1944", "1945", "11", "12", "13", "14", "15", "16", "17", "18", "19", "21", "22", "23", "24", "25", "26", "27", "28", "29", "31", " 40 ", " 50 ", " 60 ", " 70 ", " 80 ", " 90 ", " 20 ", " 30 ", "110", " 100 ", " 1 ", " 2 ", " 3 ", " 4 ", " 5 ", " 6 ", " 7 ", " 8 ", " 9 ", " 10 ", " 1 ", " 2 ", " 3 ", " 4 ", " 5 ", " 6 ", " 7 ", " 8 ", " 9 ", " 10 ", " 11 ", " 12 ", " 13 ", " 14 ", " 15 "};
        wordToOrdinalRegexes = new String[]{"\\bONZIEME\\b", "\\bDOUZIEME\\b", "\\bTREIZIEME\\b", "\\bQUATORZIEME\\b", "\\bQUINZIEME\\b", "\\bSEIZIEME\\b", "\\bDIX SEPTIEME\\b", "\\bDIX HUITIEME\\b", "\\bDIX NEUVIEME\\b", "\\bVINGT ET UNIEME\\b", "\\bVINGT DEUXIEME\\b", "\\bVINGT TROISIEME\\b", "\\bVINGT QUATRIEME\\b", "\\bVINGT CINQIEME\\b", "\\bVINGT SIXIEME\\b", "\\bVINGT SEPTIEME\\b", "\\bVINGT HUITIEME\\b", "\\bVINGT NEUVIEME\\b", "\\bTRENTE ET UNIEME\\b", "(^|\\s)SOIXANT DIXIEME($|\\s)", "(^|\\s)QUATRE VINGTIEME($|\\s)", "(^|\\s)QUATRE VINGT DIXIEME($|\\s)", "(^|\\s)VINGTIEME($|\\s)", "(^|\\s)TRENTIEME($|\\s)", "(^|\\s)QUARANTIEME($|\\s)", "(^|\\s)CIQUANTIEME($|\\s)", "(^|\\s)SOIXANTIEME($|\\s)", "\\bCENTIEME\\b", "(^|\\s)PREMIER($|\\s)", "(^|\\s)DEUXIEME($|\\s)", "(^|\\s)TROISIEME($|\\s)", "(^|\\s)QUATRIEME($|\\s)", "(^|\\s)CINQUIEME($|\\s)", "(^|\\s)SIXIEME($|\\s)", "(^|\\s)SEPTIEME($|\\s)", "(^|\\s)HUITIEME($|\\s)", "(^|\\s)NEUVIEME($|\\s)", "(^|\\s)DIXIEME($|\\s)", "(^|\\s)PREMIERE($|\\s)", "(^|\\s)I($|\\s)", "(^|\\s)II($|\\s)", "(^|\\s)III($|\\s)", "(^|\\s)IV($|\\s)", "(^|\\s)V($|\\s)", "(^|\\s)VI($|\\s)", "(^|\\s)VII($|\\s)", "(^|\\s)VIII($|\\s)", "(^|\\s)IX($|\\s)", "(^|\\s)X($|\\s)", "(^|\\s)XI($|\\s)", "(^|\\s)XII($|\\s)", "(^|\\s)XIII($|\\s)", "(^|\\s)XIV($|\\s)", "(^|\\s)XV($|\\s)"};
        wordToOrdinalReplacements = new String[]{"11E", "12E", "13E", "14E", "15E", "16E", "17E", "18E", "19E", "21E", "22E", "23E", "24E", "25E", "26E", "27E", "28E", "29E", "31E", " 70E ", " 80E ", " 90E ", " 20E ", " 30E ", " 40E ", " 50E ", " 60E ", "100E", " 1ER ", " 2E ", " 3E ", " 4E ", " 5E ", " 6E ", " 7E ", " 8E ", " 9E ", " 10E ", " 1ERE ", " 1ER ", " 2E ", " 3E ", " 4E ", " 5E ", " 6E ", " 7E ", " 8E ", " 9E ", " 10E ", " 11E ", " 12E ", " 13E ", " 14E ", " 15E "};
        digitAndOrdinalRegexes = new String[]{"\\b\\d+ER\\b", "\\b\\d+E\\b", "\\b\\d+\\b"};
        ordinalIndicatorRegexes = new String[]{"\\b(\\d+)\\s?E(R|ME)?\\b"};
        ordinalIndicatorReplacements = new String[]{"$1", "$1"};
        twoPassStandardizeRegexes = new String[]{"\\bPTE\\b"};
        twoPassStandardizeReplacements = new String[]{"PORTE"};
        ordinalToWordReplacements = new String[]{"PREMIER", "DEUXIEME", "TROISIEME", "QUATRIEME", "CINQUIEME", "SIXIEME", "SEPTIEME", "HUITIEME", "NEUVIEME", "DIXIEME", "ONZIEME", "DOUZIEME", "TREIZIEME", "QUATORZIEME", "QUINZIEME", "SEIZIEME", "DIX SEPTIEME", "DIX HUITIEME", "DIX NEUVIEME", "VINGTIEME", "VINGT ET UNIEME", "VINGT DEUXIEME", "VINGT TROISIEME", "VINGT QUATRIEME", "VINGT CINQIEME", "VINGT SIXIEME", "VINGT SEPTIEME", "VINGT HUITIEME", "VINGT NEUVIEME", "TRENTIEME", "TRENTE ET UNIEME", "QUARANTIEME", "CIQUANTIEME", "SOIXANTIEME", "SOIXANT DIXIEME", "QUATRE VINGTIEME", "QUATRE VINGT DIXIEME", "CENTIEME", "PREMIERE", "PREMIER", "DEUXIEME", "TROISIEME", "QUATRIEME", "CINQUIEME", "SIXIEME", "SEPTIEME", "HUITIEME", "NEUVIEME", "DIXIEME", "ONZIEME", "DOUZIEME", "TREIZIEME", "QUATORZIEME", "QUINZIEME"};
        numberWordsToRomanNumeralsRegexes = new String[]{"\\bPREMIERE\\b", "\\b1\\s?ERE\\b", "(?<=(^|\\s))1\\s?ER(?=($|\\s))", "(?<=(^|\\s))2\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))3\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))4\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))5\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))6\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))7\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))8\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))9\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))10\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))11\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))12\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))13\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))14\\s?E(ME)?(?=($|\\s))", "(?<=(^|\\s))15\\s?E(ME)?(?=($|\\s))", "\\b1\\b", "\\b2\\b", "\\b3\\b", "\\b4\\b", "\\b5\\b", "\\b6\\b", "\\b7\\b", "\\b8\\b", "\\b9\\b", "\\b10\\b", "\\b11\\b", "\\b12\\b", "\\b13\\b", "\\b14\\b", "\\b15\\b", "\\bPREMIER\\b", "\\bDEUXIEME\\b", "\\bTROISIEME\\b", "\\bQUATRIEME\\b", "\\bCINQUIEME\\b", "\\bSIXIEME\\b", "\\bSEPTIEME\\b", "\\bHUITIEME\\b", "\\bNEUVIEME\\b", "\\bDIXIEME\\b", "\\bONZIEME\\b", "\\bDOUZIEME\\b", "\\bTREIZIEME\\b", "\\bQUATORZIEME\\b", "\\bQUINZIEME\\b", "\\bUN\\b", "\\bDEUX\\b", "\\bTROIS\\b", "\\bQUATRE\\b", "\\bCINQ\\b", "\\bSIX\\b", "\\bSEPT\\b", "\\bHUIT\\b", "\\bNEUF\\b", "\\bDIX\\b", "\\bONZE\\b", "\\bDOUZE\\b", "\\bTREIZE\\b", "\\bQUATORZE\\b", "\\bQUINZE\\b"};
        numberWordsToRomanNumeralReplacements = new String[]{"I", "I", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"};
        stdCityPatterns = FRA_Standardizer.preCompile(stdCityRegexes);
        commonWordPatterns = FRA_Standardizer.preCompile(commonWordRegexes);
        punctuationFixerPatterns = FRA_Standardizer.preCompile(punctuationFixerRegexes);
        punctuationRemoverPatterns = FRA_Standardizer.preCompile(punctuationRemoverRegexes);
        streetAbbrPatterns = FRA_Standardizer.preCompile(streetAbbrRegexes);
        numberToWordPatterns = FRA_Standardizer.preCompile(numberToWordRegexes);
        wordToNumberPatterns = FRA_Standardizer.preCompile(wordToNumberRegexes);
        wordToOrdinalPatterns = FRA_Standardizer.preCompile(wordToOrdinalRegexes);
        digitAndOrdinalPatterns = FRA_Standardizer.preCompile(digitAndOrdinalRegexes);
        ordinalIndicatorPatterns = FRA_Standardizer.preCompile(ordinalIndicatorRegexes);
        twoPassStandardizePatterns = FRA_Standardizer.preCompile(twoPassStandardizeRegexes);
        postboxPatterns = FRA_Standardizer.preCompile(postboxRegexes);
        numberWordsToRomanNumeralPatterns = FRA_Standardizer.preCompile(numberWordsToRomanNumeralsRegexes);
        accentPatterns = FRA_Standardizer.preCompile(accentRegexes);
        ordinalToWordPatterns = FRA_Standardizer.preCompile(FRA_Standardizer.buildOrdinalToWordRegexes());
    }
}

