/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class FRAAvoidTypeAsStreetNameRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasPoBoxInMainName2;
        boolean hasTypeAsName1 = this.hasTypeAsStreetName(o1);
        boolean hasTypeAsName2 = this.hasTypeAsStreetName(o2);
        boolean hasPoBoxInMainName1 = o1.getParse()[0].getAdditionalFields().get(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD) != null;
        boolean bl = hasPoBoxInMainName2 = o2.getParse()[0].getAdditionalFields().get(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD) != null;
        if (!hasPoBoxInMainName1 && hasTypeAsName1 && !hasTypeAsName2) {
            return 1;
        }
        if (!hasTypeAsName1 && !hasPoBoxInMainName2 && hasTypeAsName2) {
            return -1;
        }
        return 0;
    }

    private boolean hasTypeAsStreetName(IAddressParsing parsing) {
        String main = parsing.getParse()[0].getMainAddress();
        if (StringUtilities.isEmpty((String)main) || main.indexOf(32) > 0) {
            return false;
        }
        if (!StringUtilities.isEmpty((String)parsing.getParse()[0].getPreThoroughfareType()) || !StringUtilities.isEmpty((String)parsing.getParse()[0].getPostThoroughfareType())) {
            return false;
        }
        FRA_ThoroughfareTypes.KeyInfo key = FRA_ThoroughfareTypes.lookupByTypeName(main);
        return key != null;
    }
}

