/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.StringTokenizer;

public class FRARejectMissingLastlineTokensRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean lostTokens1 = this.lostLastlineInformation(o1);
        boolean lostTokens2 = this.lostLastlineInformation(o2);
        if (lostTokens1 && !lostTokens2) {
            return 1;
        }
        if (!lostTokens1 && lostTokens2) {
            return -1;
        }
        return 0;
    }

    private boolean lostLastlineInformation(IAddressParsing parsing) {
        String lastIn = parsing.getSplit().getAddress().getPostAddress();
        if (StringUtilities.isEmpty((String)lastIn)) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        String tmp = parsing.getParse()[0].getPostCode1();
        if (tmp != null) {
            sb.append(tmp);
            sb.append(' ');
        }
        if ((tmp = parsing.getParse()[0].getAreaName1()) != null) {
            sb.append(tmp);
            sb.append(' ');
        }
        if ((tmp = parsing.getParse()[0].getAreaName2()) != null) {
            sb.append(tmp);
            sb.append(' ');
        }
        if ((tmp = parsing.getParse()[0].getAreaName3()) != null) {
            sb.append(tmp);
            sb.append(' ');
        }
        if ((tmp = parsing.getParse()[0].getAreaName4()) != null) {
            sb.append(tmp);
        }
        if (sb.length() == 0) {
            return true;
        }
        StringTokenizer stSplit = new StringTokenizer(FRA_Standardizer.standardizeAreaName(lastIn));
        StringTokenizer stParse = new StringTokenizer(sb.toString());
        return stSplit.countTokens() != stParse.countTokens();
    }
}

