/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class FRA_RetaggedTokenMap {
    private HashMap<Integer, RetaggedToken> retaggedTokens = new HashMap();
    private static final List<String> tags;
    private static final List<String> saints;
    private static final int TAGTYPE_NUMERIC = 0;
    private static final int TAGTYPE_ALPHANUM = 1;
    private static final int TAGTYPE_POSTCODE = 2;
    private static final int TAGTYPE_SINGLECHAR = 3;
    private static final int TAGTYPE_ARTICLE = 4;
    private static final int TAGTYPE_WORD = 5;
    private static final int TAGTYPE_AMPERSAND = 6;

    public FRA_RetaggedTokenMap(TaggedTokenList tokens) {
        int sz = tokens.size() - 1;
        for (int i = 0; i < sz; ++i) {
            RetaggedToken rt = new RetaggedToken(tokens.get(i));
            this.retaggedTokens.put(i, rt);
        }
    }

    boolean isSaint(int idx) {
        return idx >= 0 && idx < this.retaggedTokens.size() && this.retaggedTokens.get(idx).isSaint();
    }

    int findSaint(int startIdx, int endIdx) {
        for (int i = startIdx; i <= endIdx; ++i) {
            if (!this.isSaint(i)) continue;
            return i;
        }
        return -1;
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("NUMERIC");
        temp.add("ALPHANUM");
        temp.add("POSTCODE");
        temp.add("SINGLECHAR");
        temp.add("ARTICLE");
        temp.add("WORD");
        temp.add("AMPERSAND");
        tags = Collections.unmodifiableList(temp);
        temp = new ArrayList();
        temp.add("SAINT");
        temp.add("SAINTE");
        temp.add("ST");
        temp.add("STE");
        saints = Collections.unmodifiableList(temp);
    }

    private class RetaggedToken {
        String value;
        boolean bSaint;
        int type;

        RetaggedToken(TaggedToken orig) {
            this.type = tags.indexOf(orig.getTag());
            this.value = orig.getValue();
            this.retag();
        }

        void retag() {
            if (this.type == 5 || this.type == 4) {
                this.value = this.value.toUpperCase();
                this.bSaint = this.type == 5 && saints.contains(this.value);
            }
        }

        boolean isSaint() {
            return this.bSaint;
        }
    }
}

