/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.singleline;

import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.FRA.singleline.FRA_RetaggedTokenMap;
import com.mapinfo.mapmarker.FRA.singleline.FRA_SingleLineComparatorUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedToken;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class FRA_SplitHelper {
    public static final String KEY_INPUT_TOKENS = "FRA_KEY_INPUT_TOKENS";
    private TaggedTokenList tokens;
    private String inputMainAddress;
    private String inputPostAddress;
    private String standardizedMainAddress;
    private String standardizedPostAddress;
    private boolean bFromReverseSplit;
    private boolean bMainSetup = false;
    private boolean bPostSetup = false;
    private int mainStartIdx = -1;
    private int mainEndIdx = -1;
    private int mainSize = -1;
    private int postStartIdx = -1;
    private int postEndIdx = -1;
    private int postSize = -1;
    private HashMap<String, Integer> m_postAddressTokenIndex;
    private HashMap<String, Integer> m_mainAddressTokenIndex;
    private FRA_RetaggedTokenMap m_retaggedTokens;
    private static final List<String> validRegions;
    public static final String TAG_NUMERIC = "NUMERIC";
    public static final String TAG_ALPHANUM = "ALPHANUM";
    public static final String TAG_POSTCODE = "POSTCODE";
    public static final String TAG_SINGLECHAR = "SINGLECHAR";
    public static final String TAG_ARTICLE = "ARTICLE";
    public static final String TAG_WORD = "WORD";
    public static final String TAG_AMPERSAND = "AMPERSAND";

    public FRA_SplitHelper(String main, String post, boolean bFromReverse, TaggedTokenList singleLineTokens, FRA_RetaggedTokenMap retags) {
        this.inputMainAddress = main;
        this.inputPostAddress = post;
        this.bFromReverseSplit = bFromReverse;
        this.tokens = singleLineTokens;
        this.m_retaggedTokens = retags;
    }

    public String getStandardizedPostAddress() {
        if (this.standardizedPostAddress == null) {
            this.standardizedPostAddress = FRA_Standardizer.standardizeAreaName(this.inputPostAddress);
        }
        return this.standardizedPostAddress;
    }

    public String getStandardizedMainAddress() {
        if (this.standardizedMainAddress == null) {
            this.standardizedMainAddress = FRA_Standardizer.standardizeString(this.inputMainAddress);
        }
        return this.standardizedMainAddress;
    }

    public int getMainCount() {
        if (!this.bMainSetup) {
            this.initializeMainAddressInfo();
        }
        return this.mainSize;
    }

    public int getPostCount() {
        if (!this.bPostSetup) {
            this.initializePostAddressInfo();
        }
        return this.postSize;
    }

    public String postTagAt(int position) {
        if (this.badIndex(position, false)) {
            return null;
        }
        return this.tokens.getTag(this.getPostStartIdx() + position);
    }

    public String postValueAt(int position) {
        if (this.badIndex(position, false)) {
            return null;
        }
        return this.tokens.getValue(this.getPostStartIdx() + position);
    }

    public String mainTagAt(int position) {
        if (this.badIndex(position, true)) {
            return null;
        }
        return this.tokens.getTag(this.getMainStartIdx() + position);
    }

    public String mainValueAt(int position) {
        if (this.badIndex(position, true)) {
            return null;
        }
        return this.tokens.getValue(this.getMainStartIdx() + position);
    }

    public int postIndexOfTag(String tag) {
        if (!this.bPostSetup) {
            this.initializePostAddressInfo();
        }
        if (this.postSize == 0) {
            return -1;
        }
        Integer idx = this.m_postAddressTokenIndex.get(tag);
        if (idx == null) {
            idx = FRA_SplitHelper.rangedIndexOfTag(this.tokens, tag, this.getPostStartIdx(), this.getPostEndIdx());
            this.m_postAddressTokenIndex.put(tag, idx);
        }
        return idx;
    }

    public boolean postContainsTag(String tag) {
        return FRA_SplitHelper.rangedContainsTag(this.tokens, tag, this.getPostStartIdx(), this.getPostEndIdx());
    }

    public boolean postEqualsTag(int position, String tag) {
        return tag != null && this.tokens != null && StringUtilities.equalStrings((String)tag, (String)this.tokens.getTag(position + this.getPostStartIdx()));
    }

    public int mainIndexOfTag(String tag) {
        if (!this.bMainSetup) {
            this.initializeMainAddressInfo();
        }
        if (this.mainSize == 0) {
            return -1;
        }
        Integer idx = this.m_mainAddressTokenIndex.get(tag);
        if (idx == null) {
            idx = FRA_SplitHelper.rangedIndexOfTag(this.tokens, tag, this.getMainStartIdx(), this.getMainEndIdx());
            this.m_mainAddressTokenIndex.put(tag, idx);
        }
        return idx;
    }

    public boolean mainContainsTag(String tag) {
        return FRA_SplitHelper.rangedContainsTag(this.tokens, tag, this.getMainStartIdx(), this.getMainEndIdx());
    }

    public boolean mainEqualsTag(int position, String tag) {
        return tag != null && this.tokens != null && StringUtilities.equalStrings((String)tag, (String)this.tokens.getTag(position + this.getMainStartIdx()));
    }

    private void initializeMainAddressInfo() {
        if (this.inputMainAddress != null) {
            this.mainStartIdx = this.bFromReverseSplit ? this.getPostCount() : 0;
            this.mainSize = this.tokens.size() - this.getPostCount();
            this.mainEndIdx = this.mainStartIdx + this.mainSize - 1;
            this.m_mainAddressTokenIndex = new HashMap();
        } else {
            this.mainStartIdx = -1;
            this.mainSize = 0;
            this.mainEndIdx = -1;
        }
        this.bMainSetup = true;
    }

    private void initializePostAddressInfo() {
        if (this.inputPostAddress != null) {
            this.postSize = new StringTokenizer(this.inputPostAddress).countTokens();
            this.postStartIdx = this.bFromReverseSplit ? 0 : this.tokens.size() - this.postSize;
            this.postEndIdx = this.postStartIdx + this.postSize - 1;
            this.m_postAddressTokenIndex = new HashMap();
        } else {
            this.postSize = 0;
            this.postStartIdx = -1;
            this.postEndIdx = -1;
        }
        this.bPostSetup = true;
    }

    private int getMainStartIdx() {
        if (!this.bMainSetup) {
            this.initializeMainAddressInfo();
        }
        return this.mainStartIdx;
    }

    private int getPostStartIdx() {
        if (!this.bPostSetup) {
            this.initializePostAddressInfo();
        }
        return this.postStartIdx;
    }

    private int getPostEndIdx() {
        if (!this.bPostSetup) {
            this.initializePostAddressInfo();
        }
        return this.postEndIdx;
    }

    private int getMainEndIdx() {
        if (!this.bMainSetup) {
            this.initializeMainAddressInfo();
        }
        return this.mainEndIdx;
    }

    public boolean postEndsInTag(String tag) {
        int sz = this.getPostCount();
        return sz > 0 && this.postTagAt(sz - 1).equals(tag);
    }

    public boolean mainEndsInTag(String tag) {
        int sz = this.getMainCount();
        return sz > 0 && this.mainTagAt(sz - 1).equals(tag);
    }

    public int postIndexOfSaint(int firstIdx) {
        return this.indexOfSaint(firstIdx, this.getPostStartIdx(), this.getPostEndIdx());
    }

    public int mainIndexOfSaint(int firstIdx) {
        return this.indexOfSaint(firstIdx, this.getMainStartIdx(), this.getMainEndIdx());
    }

    private int indexOfSaint(int firstIdx, int startLine, int endLine) {
        int loc;
        int start = firstIdx + startLine;
        if (this.m_retaggedTokens != null && (loc = this.m_retaggedTokens.findSaint(start, endLine)) >= 0) {
            return loc - startLine;
        }
        return -1;
    }

    public boolean postTokenIsSaint(int idx) {
        return this.tokenIsSaint(idx, this.getPostStartIdx(), this.getPostEndIdx());
    }

    public boolean mainTokenIsSaint(int idx) {
        return this.tokenIsSaint(idx, this.getMainStartIdx(), this.getMainEndIdx());
    }

    private boolean tokenIsSaint(int firstIdx, int startLine, int endLine) {
        int start = firstIdx + startLine;
        return this.m_retaggedTokens != null && start <= endLine && this.m_retaggedTokens.isSaint(start);
    }

    public boolean postEndsInSaint() {
        return this.tokenIsSaint(this.getPostEndIdx(), this.getPostStartIdx(), this.getPostEndIdx());
    }

    public boolean mainEndsInSaint() {
        return this.tokenIsSaint(this.getMainEndIdx(), this.getMainStartIdx(), this.getMainEndIdx());
    }

    public static TaggedTokenList tagString(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return null;
        }
        TaggedTokenList tokens = new TaggedTokenList(new StringTokenizer(input, ",;: "));
        for (int idx = 0; idx < tokens.size(); ++idx) {
            TaggedToken currentToken = tokens.get(idx);
            if (currentToken.isTagged()) continue;
            String currentValue = currentToken.getValue();
            if (StringUtilities.isNumeric((String)currentValue)) {
                if (currentValue.length() == 5) {
                    currentToken.setTag(TAG_POSTCODE);
                    continue;
                }
                currentToken.setTag(TAG_NUMERIC);
                continue;
            }
            if (StringUtilities.hasNumeric((String)currentValue)) {
                currentToken.setTag(TAG_ALPHANUM);
                continue;
            }
            if (currentValue.length() == 1) {
                currentToken.setTag(TAG_SINGLECHAR);
                continue;
            }
            if ("&&".equals(currentValue)) {
                currentToken.setTag(TAG_AMPERSAND);
                continue;
            }
            if (FRA_SingleLineComparatorUtils.tokenIsArticle(currentValue)) {
                currentToken.setTag(TAG_ARTICLE);
                continue;
            }
            currentToken.setTag(TAG_WORD);
        }
        return tokens;
    }

    public static int rangedIndexOfTag(TaggedTokenList list, String tag, int startIdx, int endIdx) {
        int idx = list.indexOfTag(tag, startIdx);
        if (idx > endIdx) {
            return -1;
        }
        return idx - startIdx;
    }

    public static boolean rangedContainsTag(TaggedTokenList list, String tag, int startIdx, int endIdx) {
        if (list == null) {
            return false;
        }
        int idx = list.indexOfTag(tag, startIdx);
        return idx >= 0 && idx <= endIdx;
    }

    public static boolean stringContainsValidStandardizedRegionNameTokens(String main) {
        if (StringUtilities.isEmpty((String)main)) {
            return false;
        }
        for (String region : validRegions) {
            if (!main.contains(region)) continue;
            return true;
        }
        return false;
    }

    protected boolean badIndex(int position, boolean bMain) {
        if (this.tokens == null || position < 0) {
            return true;
        }
        int sz = this.tokens.size();
        int start = bMain ? this.getMainStartIdx() : this.getPostStartIdx();
        return start >= sz || start < 0 || start + position >= sz;
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("ALSACE");
        temp.add("AQUITAINE");
        temp.add("AUVERGNE");
        temp.add("BASSE NORMANDIE");
        temp.add("BOURGOGNE");
        temp.add("BRETAGNE");
        temp.add("CENTRE");
        temp.add("CHAMPAGNE ARDENNE");
        temp.add("CORSE");
        temp.add("FRANCHE COMTE");
        temp.add("HAUTE NORMANDIE");
        temp.add("ILE FRANCE");
        temp.add("LANGUEDOC ROUSSILLON");
        temp.add("LIMOUSIN");
        temp.add("LORRAINE");
        temp.add("MIDI PYRENEES");
        temp.add("NORD PAS CALAIS");
        temp.add("PAYS LOIRE");
        temp.add("PICARDIE");
        temp.add("POITOU CHARENTES");
        temp.add("PROVENCE ALPES COTE AZUR");
        temp.add("RHONE ALPES");
        validRegions = Collections.unmodifiableList(temp);
    }
}

