/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class NZL_InternalBrowseAddress
extends InternalBrowseAddress {
    private StreetBasedIdentifier m_identifier = null;

    public NZL_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        candidate.setPreAddress(parsed.getPreAddress());
        Segment segment = this.getSegmentAt(0);
        if (!NZL_AddressUtils.isEmpty(parsed.getPlaceName())) {
            String placeName = this.getFirstFoundPlaceNameFromSegment(segment, 0);
            if (NZL_AddressUtils.isEmpty(placeName)) {
                placeName = this.getFirstFoundPlaceNameFromSegment(segment, 1);
            }
            if (!NZL_AddressUtils.isEmpty(placeName)) {
                candidate.setPlaceName(placeName);
            }
        }
        candidate.setAreaName4(segment.getLeftAreaName4());
        candidate.setAreaName3(segment.getLeftAreaName3());
        candidate.setPostCode1(segment.getLeftPostCode1());
        candidate.setAreaName1(segment.getLeftAreaName1());
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        return candidate;
    }

    protected String getFormattedStreetAddress() {
        return NZL_AddressUtils.getFormattedStreetAddress((Address)this, false);
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    private String getFirstFoundPlaceNameFromSegment(Segment segment, int side) {
        int rangeCount;
        if ((side == 0 || side == 1) && (rangeCount = segment.getRangeCount(side)) > 0) {
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                if (range == null || NZL_AddressUtils.isEmpty(range.getPlaceName())) continue;
                return range.getPlaceName();
            }
        }
        return null;
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

