/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalCandidateAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.ICandidateRangeIterator;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.NZL.NZL_CandidateRange;
import com.mapinfo.mapmarker.NZL.NZL_CandidateRangeUnit;
import com.mapinfo.mapmarker.NZL.NZL_RangeUnit;
import com.mapinfo.mapmarker.NZL.NZL_ScoringAddress;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_DataManager;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_Segment;
import com.mapinfo.mapmarker.NZL.parser.NZL_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.core.interpolator.Interpolator;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NZL_InternalCandidateAddress
extends EMEA_InternalCandidateAddress {
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    public static final String POST_ADDR_COMMON = "post_addr_common";
    public static final String PRE_DIRECTIONAL_SEPARATOR = "PRE_DIRECTIONAL_SEPARATOR";
    public static final String POST_TT_SEPARATOR = "POST_TT_SEPARATOR";
    public static final String PRE_TT_SEPARATOR = "PRE_TT_SEPARATOR";
    public static final String POST_MAIN_SEPARATOR = "POST_MAIN_SEPARATOR";
    public static final String EXPANDED_POSTADDRESS = "expanded_postaddress";
    public static final String EXPANDED_PREADDRESS = "expanded_preaddress";
    private static final int MATCH_NONE = 0;
    private static final int MATCH_FIRST = 1;
    private static final int MATCH_SECOND = 2;
    private static final int MATCH_BOTH_DIFFERENT = 3;
    private static final int MATCH_BOTH = 4;
    private static final double EXACT_CLOSE_MATCH_SCORE = 1.0;
    private static final double CUT_OFF_VALUE = 0.86;
    private String m_addressNumber = null;
    private int m_numAddrNumberFields = 0;
    private int m_numAddrNumberFieldsMatched = 0;
    private int m_matchType = 0;
    private double m_swappedAreaName3Score;
    private double m_swappedAreaName4Score;
    private boolean m_usingSwappedArea34Score;
    private boolean m_placeNameInputOnly;
    private boolean isAliasSuburbMatch;
    private double m_unitScore = 0.0;
    private double m_unitTypeFinalScore = 0.0;
    private boolean isFullHnrMatch = false;
    private boolean exactHnrMatch = false;
    private String m_SuburbAlias;
    private double m_streetScore = 0.0;

    public NZL_InternalCandidateAddress() {
    }

    public NZL_InternalCandidateAddress(Address address) {
        super(address);
    }

    private CandidateAddress constructCandidateAddress(Address input, IConstraints constraints) {
        int uniqueId;
        Segment segment;
        CandidateAddress candidate = new CandidateAddress((Address)this);
        candidate.setSourceStreetID(this.getStreetOffset());
        candidate.setAddressNumber(this.getAddressNumber());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (NZL_AddressUtils.isPrefixAndSuffixCloseMatch(input, this)) {
            candidate.setStreetPrefixAndSuffixMatched();
        }
        if (this.fieldExists(input.getMainAddress())) {
            if (this.getMainAddressScore() == 1.0) {
                candidate.setStreetNameMatched();
            }
        } else if (!this.fieldExists(candidate.getMainAddress())) {
            candidate.setStreetNameMatched();
        }
        if (this.getPreDirectionalScore() == 1.0) {
            candidate.setPreDirectionalMatched();
        }
        if (this.getPostDirectionalScore() == 1.0) {
            candidate.setPostDirectionalMatched();
        }
        if (this.getPreThoroughfareTypeScore() == 1.0 && this.getPostThoroughfareTypeScore() == 1.0) {
            candidate.setThoroughfareTypeMatched();
        }
        if (this.fieldExists(input.getPostCode1())) {
            if (this.getPostCode1Score() == 1.0) {
                candidate.setPostalCode1Matched();
            }
        } else if (!this.fieldExists(candidate.getPostCode1())) {
            candidate.setPostalCode1Matched();
        }
        if (this.fieldExists(input.getPostCode2())) {
            if (this.getPostCode2Score() == 1.0) {
                candidate.setPostalCode2Matched();
            }
        } else if (!this.fieldExists(candidate.getPostCode2())) {
            candidate.setPostalCode2Matched();
        }
        if (this.fieldExists(input.getAreaName1())) {
            if (this.getAreaName1Score() == 1.0) {
                candidate.setAreaName1Matched();
            }
        } else if (!this.fieldExists(candidate.getAreaName1())) {
            candidate.setAreaName1Matched();
        }
        if (this.getAreaName3Score() == 1.0 || this.getSwappedAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.getAreaName4Score() == 1.0 || this.getSwappedAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
            candidate.setPlaceNameMatched();
        }
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        this.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        ParsedNumber num = new ParsedNumber(input.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        if (!num.isEmpty()) {
            if (this.getAddressNumberScore() == 1.0) {
                candidate.setAddressNumberMatched();
                if (candidate.getLocationPrecision() == 16 || candidate.getLocationPrecision() == 17) {
                    candidate.setAddressNumber(new ParsedNumber(this.getAddressNumber()));
                    num = new ParsedNumber(this.getAddressNumber());
                } else {
                    candidate.setAddressNumber(num);
                }
            }
        } else if (input.getAddressNumber() == null && !this.isNZLAddressPoint()) {
            candidate.setAddressNumberMatched();
        }
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        if (maxRanges != 0) {
            CandidateRange candRange;
            Range range;
            int index;
            segment = this.getSegment();
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            boolean unitFound = false;
            boolean exactUnitFound = false;
            if (this.isNZLAddressPoint() && input.getAddressNumber() == null) {
                for (index = 0; index < numLeftRanges; ++index) {
                    range = segment.getRangeAt(index, 0);
                    if (range.hasMatchingRangeUnit()) {
                        unitFound = true;
                        NZL_RangeUnit rangeUnit = (NZL_RangeUnit)range.getRangeUnitAt(range.getMatchingRangeUnit());
                        if (rangeUnit != null && (input.getUnitType() == null && rangeUnit.getUnitType() == null || rangeUnit.getUnitType().equalsIgnoreCase("") || rangeUnit.getTypeMatched())) {
                            exactUnitFound = true;
                            num = range.getParsedFrom();
                        }
                        if (!unitFound && !exactUnitFound) {
                            num = range.getParsedFrom();
                        }
                        if (!exactUnitFound) continue;
                        break;
                    }
                    if (!range.hasClosestRangeUnit() || unitFound || exactUnitFound) continue;
                    unitFound = true;
                    num = range.getParsedFrom();
                }
            }
            for (index = 0; index < numLeftRanges; ++index) {
                int indexOfDash;
                int indexOfDash2;
                range = segment.getRangeAt(index, 0);
                if (input.getAddressNumber() != null && input.getUnitValue() == null && (indexOfDash2 = input.getAddressNumber().indexOf("-")) > -1 && range.getParsedFrom().getAddressNumber() != num.getAddressNumber()) {
                    unitNum = new ParsedNumber(input.getAddressNumber().substring(0, indexOfDash2));
                }
                candRange = range.toCandidateRange(num, 1, unitNum, constraints);
                if (input.getAddressNumber() != null && input.getUnitValue() == null && (indexOfDash = input.getAddressNumber().indexOf("-")) > -1) {
                    unitNum = null;
                }
                candidate.addCandidateRange(candRange);
            }
            for (index = 0; index < numRightRanges; ++index) {
                range = segment.getRangeAt(index, 1);
                candRange = range.toCandidateRange(num, 2, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
        }
        if (this.isNZLAddressPoint()) {
            CandidateRange candidateRange = candidate.getRangeAt(0);
            this.populateCandidateUnitInformation(input, candidate, candidateRange);
            if (Boolean.valueOf(constraints.getCustomString("ReturnOriginalCoordinates")).booleanValue()) {
                this.populateOriginalCoordinates(candidate, candidateRange);
            }
            if (candidateRange != null) {
                NZL_CandidateRangeUnit rangeUnit = (NZL_CandidateRangeUnit)candidateRange.getRangeUnitAt(0);
                if (rangeUnit != null) {
                    uniqueId = rangeUnit.getUniqueId();
                    candidate.addKeyValueToAdditionalFields("KEY_UFI", Integer.toString(uniqueId));
                }
                candidate.addKeyValueToAdditionalFields("NZL_MESHBLOCK_ID", ((NZL_CandidateRange)candidateRange).getMeshBlockIdLeft());
            }
        } else {
            segment = this.getSegment();
            String meshBlock = this.getMeshBlock(segment);
            candidate.addKeyValueToAdditionalFields("NZL_MESHBLOCK_ID", meshBlock);
            uniqueId = this.getUniqueIdentifier(segment);
            candidate.addKeyValueToAdditionalFields("KEY_UFI", Integer.toString(uniqueId));
            super.populateSegmentId((Address)candidate);
        }
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress((Address)candidate));
        return candidate;
    }

    private void populateCandidateUnitInformation(Address input, CandidateAddress candidate, CandidateRange range) {
        if (range != null) {
            CandidateRangeUnit candRangeUnit = range.getRangeUnitAt(0);
            if (this.isNZLAddressPoint()) {
                candidate.setAddressNumber(range.getLowAddress());
                if (input.getUnitValue() == null && input.getAddressNumber() == null) {
                    candidate.setAddressNumber(range.getLowAddress());
                }
                if (candRangeUnit != null) {
                    String lowUnitValue = candRangeUnit.getLowUnitNumber();
                    String highUnitValue = candRangeUnit.getHighUnitNumber();
                    String unitType = candRangeUnit.getUnitType();
                    if (lowUnitValue != null && !lowUnitValue.equalsIgnoreCase("0")) {
                        if (highUnitValue != null && !lowUnitValue.equalsIgnoreCase(highUnitValue)) {
                            lowUnitValue = lowUnitValue + "-" + highUnitValue;
                        }
                        candidate.setUnitValue(lowUnitValue);
                    }
                    if (unitType != null && !unitType.equalsIgnoreCase("")) {
                        candidate.setUnitType(unitType);
                    }
                    if (lowUnitValue != null && lowUnitValue.equalsIgnoreCase("0")) {
                        candidate.setUnitType(null);
                        candidate.setUnitValue(null);
                    }
                }
            }
        }
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        String postDir;
        String postAddress;
        String postAddrCommon;
        String preTT;
        CandidateAddress candidate = this.constructCandidateAddress(input, constraints);
        String postTTSeparator = this.getAdditionalFieldForKey(POST_TT_SEPARATOR) == null ? " " : this.getAdditionalFieldForKey(POST_TT_SEPARATOR);
        String postMainSeparator = this.getAdditionalFieldForKey(POST_MAIN_SEPARATOR) == null ? "" : this.getAdditionalFieldForKey(POST_MAIN_SEPARATOR);
        String postTT = this.getPostThoroughfareType();
        if (postTT != null) {
            NZL_ThoroughfareTypes.NZL_ThoroughfareType type = NZL_ThoroughfareTypes.getThoroughfareType(postTT);
            if (type != null) {
                postTT = type.getExpandedTypeName();
            }
            if (postTTSeparator.equals("-")) {
                postTT = postTT + postTTSeparator;
            }
            candidate.setPostThoroughfareType(postTT);
        }
        if ((preTT = this.getPreThoroughfareType()) != null) {
            NZL_ThoroughfareTypes.NZL_ThoroughfareType type = NZL_ThoroughfareTypes.getThoroughfareType(preTT);
            if (type != null) {
                preTT = type.getExpandedTypeName();
            }
            candidate.setPreThoroughfareType(preTT);
        }
        StringBuffer buf = new StringBuffer(100);
        String newMainAddress = this.getMainAddress();
        if (postMainSeparator != null) {
            newMainAddress = newMainAddress + postMainSeparator;
        }
        candidate.setMainAddress(newMainAddress);
        buf = new StringBuffer(100);
        if (this.hasAdditionalFields() && (postAddrCommon = this.getAdditionalFieldForKey(POST_ADDR_COMMON)) != null) {
            buf.append(postAddrCommon);
        }
        if ((postAddress = this.getPostAddress()) != null) {
            if (!postTTSeparator.equals("-") && postAddress.charAt(0) != '-' && buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(this.getPostAddress());
        }
        if (this.getGenericField3() != null) {
            buf.append(' ');
            buf.append(this.getGenericField3());
        }
        candidate.setPostAddress(buf.toString());
        String preDir = this.getPreDirectional();
        if (preDir != null) {
            candidate.setPreDirectional(preDir);
        }
        if ((postDir = this.getPostDirectional()) != null) {
            candidate.setPostDirectional(postDir);
        }
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        candidate.addKeyValueToAdditionalFields("ALIASED_SUBURB", this.m_SuburbAlias);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        if (candidate.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidate.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
            candidate.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        candidate.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        return candidate;
    }

    private void populateOriginalCoordinates(CandidateAddress candidate, CandidateRange candidateRange) {
        LongPoint originalPoint = ((NZL_CandidateRange)candidateRange).getOriginalPoint();
        if (originalPoint != null) {
            StringBuffer longitude = new StringBuffer(String.valueOf(originalPoint.getX()));
            StringBuffer latitude = new StringBuffer(String.valueOf(originalPoint.getY()));
            longitude.insert(3, '.');
            latitude.insert(3, '.');
            candidate.addKeyValueToAdditionalFields("ORIGINAL_LONGITUDE", longitude.toString());
            candidate.addKeyValueToAdditionalFields("ORIGINAL_LATITUDE", latitude.toString());
        }
    }

    @Override
    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName3();
            String right = segment.getRightAreaName3();
            if (left != null && right != null && left.equals(right)) {
                return left;
            }
        }
        return areaName3;
    }

    public void scoreAddressNumber(ScoringAddress address) {
        if (address.getParsedAddressNumber() == null && address.getUnitValue() == null) {
            if (address.getPlaceName() != null) {
                this.m_placeNameInputOnly = true;
            }
            return;
        }
        String addressNumber = address.getAddressNumber();
        if (addressNumber != null) {
            address.setAddressNumber(addressNumber.toUpperCase());
        }
        if (this.isNZLAddressPoint()) {
            this.scoreNZLAPAddressNumber(address);
        } else {
            address.setAddressNumber(address.getParsedAddressNumber());
            this.scoreStandardAddressNumber(address);
        }
    }

    private void scoreNZLAPAddressNumber(ScoringAddress address) {
        super.scoreAddressNumber(address);
        String firstPartInput = null;
        String secondPartInput = null;
        int segmentSide = this.getSegment().getRangeCount(0) > 0 ? 0 : 1;
        int rangeNumber = -1;
        rangeNumber = this.getMatchedRangeNumber() > -1 ? this.getMatchedRangeNumber() : -1;
        int n = rangeNumber = rangeNumber == -1 ? this.getClosestRangeNumber() : rangeNumber;
        if (rangeNumber > -1) {
            String fullData = this.getSegment().getRangeAt(rangeNumber, segmentSide).getParsedFrom().getCombinedAddressNumber();
            int indexOfDash = fullData.indexOf(45);
            ParsedNumber firstPNData = null;
            ParsedNumber secondPNData = null;
            if (indexOfDash >= 0) {
                String firstPartData = fullData.substring(0, indexOfDash);
                firstPNData = firstPartData.length() > 0 ? new ParsedNumber(firstPartData) : null;
                String secondPartData = fullData.substring(indexOfDash + 1, fullData.length());
                secondPNData = secondPartData.length() > 0 ? new ParsedNumber(secondPartData) : null;
            } else {
                firstPNData = new ParsedNumber(fullData);
            }
            if (address.getParsedAddressNumber() != null) {
                String fullInput = address.getParsedAddressNumber().getCombinedAddressNumber();
                indexOfDash = fullInput.indexOf(45);
                if (indexOfDash >= 0) {
                    firstPartInput = fullInput.substring(0, indexOfDash);
                    secondPartInput = fullInput.substring(indexOfDash + 1, fullInput.length());
                } else {
                    firstPartInput = fullInput;
                }
                boolean matchedFirstPart = false;
                if (firstPartInput != null) {
                    matchedFirstPart = this.checkNZLAPPartialMatch(firstPartInput, firstPNData, address);
                    if (secondPartInput == null) {
                        matchedFirstPart = matchedFirstPart || this.checkNZLAPPartialMatch(firstPartInput, secondPNData, address);
                    }
                }
                boolean matchedSecondPart = false;
                if (secondPartInput != null) {
                    matchedSecondPart = this.checkNZLAPPartialMatch(secondPartInput, secondPNData, address);
                    if (!matchedFirstPart && secondPNData == null) {
                        matchedSecondPart = matchedSecondPart || this.checkNZLAPPartialMatch(secondPartInput, firstPNData, address);
                    }
                }
                this.m_numAddrNumberFieldsMatched = 0;
                this.m_numAddrNumberFields = 2;
                if (matchedFirstPart && matchedSecondPart) {
                    this.setSegmentSide(segmentSide);
                    this.setMatchedRangeNumber(rangeNumber);
                    this.m_numAddrNumberFieldsMatched = 2;
                    this.isFullHnrMatch = true;
                } else if (matchedFirstPart && secondPNData == null || matchedFirstPart && secondPartInput == null && secondPNData != null || matchedSecondPart) {
                    this.setSegmentSide(segmentSide);
                    this.setMatchedRangeNumber(rangeNumber);
                    this.m_numAddrNumberFieldsMatched = 2;
                    this.isFullHnrMatch = this.exactHnrMatch && matchedFirstPart && (secondPartInput == null && secondPNData == null || matchedSecondPart);
                } else {
                    this.setClosestSegmentSide(segmentSide);
                    this.setClosestRange(rangeNumber);
                    if (matchedFirstPart || matchedSecondPart) {
                        this.m_numAddrNumberFieldsMatched = 1;
                        this.isFullHnrMatch = false;
                    }
                }
                if (this.m_numAddrNumberFieldsMatched == 0) {
                    this.m_numAddrNumberFieldsMatched = super.getCntAddressNumberFieldsMatched();
                }
                this.m_addressNumber = fullData;
                address.setAddressNumber(fullInput);
                if (!(address.getUnitValue() != null || secondPartInput == null || matchedFirstPart && matchedSecondPart)) {
                    String actualAddressNumber = fullInput;
                    address.setUnitValue(firstPartInput);
                    address.setAddressNumber(secondPartInput);
                    address.setParsedUnitValue(new ParsedNumber(firstPartInput));
                    this.scoreNZLAPAddressNumber(address);
                    address.setAddressNumber(actualAddressNumber);
                }
            }
        }
        this.scoreUnitNumber(address);
    }

    private boolean checkNZLAPPartialMatch(String partialInput, ParsedNumber partialData, ScoringAddress scoringAddress) {
        ParsedNumber pnInput = new ParsedNumber(partialInput);
        if (partialData != null) {
            if (pnInput.getAddressNumberExists() && partialData.getAddressNumberExists() && pnInput.getAddressNumber() == partialData.getAddressNumber()) {
                if (!pnInput.hasAddressPrefix() && !pnInput.hasAddressSuffix()) {
                    if (!partialData.hasAddressPrefix() && !partialData.hasAddressSuffix()) {
                        this.exactHnrMatch = true;
                    }
                    return true;
                }
                if (pnInput.hasAddressPrefix() && partialData.hasAddressPrefix() && pnInput.getAddressPrefix().equalsIgnoreCase(partialData.getAddressPrefix())) {
                    this.exactHnrMatch = true;
                    return true;
                }
                if (pnInput.hasAddressSuffix() && partialData.hasAddressSuffix() && pnInput.getAddressSuffix().equalsIgnoreCase(partialData.getAddressSuffix())) {
                    this.exactHnrMatch = true;
                    return true;
                }
            } else if (!pnInput.getAddressNumberExists()) {
                if (pnInput.hasAddressPrefix() && partialData.hasAddressPrefix() && pnInput.getAddressPrefix().equalsIgnoreCase(partialData.getAddressPrefix())) {
                    return true;
                }
                if (pnInput.hasAddressSuffix() && partialData.hasAddressSuffix() && pnInput.getAddressSuffix().equalsIgnoreCase(partialData.getAddressSuffix())) {
                    return true;
                }
            }
        }
        return false;
    }

    private void scoreStandardAddressNumber(ScoringAddress address) {
        String addressNumber;
        int secondMatchedRange = -1;
        boolean isClosestSegment = false;
        int secondSegmentSide = -1;
        int secondClosestMatchedRange = -1;
        int secondClosestSegmentSide = -1;
        ParsedNumber secondNumber = null;
        String firstAddressNumber = addressNumber = address.getAddressNumber();
        String secondAddressNumber = null;
        if (addressNumber != null) {
            StringTokenizer st = new StringTokenizer(addressNumber, "-/ &");
            if (st.countTokens() > 1) {
                firstAddressNumber = st.nextToken();
                ParsedNumber parsedNumber = new ParsedNumber(firstAddressNumber);
                if (parsedNumber.getAddressNumberExists()) {
                    firstAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                }
                while (st.hasMoreTokens() && (secondAddressNumber = st.nextToken()) != null) {
                    parsedNumber = new ParsedNumber(secondAddressNumber);
                    if (parsedNumber.getAddressNumberExists()) {
                        secondAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                        break;
                    }
                    secondAddressNumber = null;
                }
            }
            if (secondAddressNumber != null) {
                address.setAddressNumber(secondAddressNumber);
                super.scoreAddressNumber(address);
                this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                    this.m_matchType = 2;
                    secondMatchedRange = this.getMatchedRangeNumber();
                    secondSegmentSide = this.getSegmentSide();
                    secondNumber = this.getInputNumber();
                    this.setCntAddressNumberFieldsMatched(0);
                } else if (this.getClosestSegmentSide() >= 0 && this.getClosestRangeNumber() >= 0) {
                    this.m_matchType = 2;
                    isClosestSegment = true;
                    secondClosestMatchedRange = this.getClosestRangeNumber();
                    secondClosestSegmentSide = this.getClosestSegmentSide();
                }
                this.setInputNumber(null);
                this.setMatchedRangeNumber(-1);
                this.setSegmentSide(-1);
                this.setClosestRange(-1);
                super.setClosestSegmentSide(-1);
                this.setMatchingFlag(0);
            }
        }
        address.setAddressNumber(firstAddressNumber);
        super.scoreAddressNumber(address);
        if (this.getInputNumber() != null) {
            this.m_numAddrNumberFields += this.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == 2) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = 4;
                        this.m_addressNumber = firstAddressNumber;
                    } else {
                        this.m_matchType = 3;
                        this.m_addressNumber = firstAddressNumber;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = 1;
                }
            }
            if (this.m_matchType == 2) {
                if (!isClosestSegment) {
                    this.setInputNumber(secondNumber);
                    this.setMatchedRangeNumber(secondMatchedRange);
                    this.setSegmentSide(secondSegmentSide);
                    this.m_addressNumber = secondAddressNumber;
                    address.setAddressNumber(secondAddressNumber);
                    super.scoreAddressNumber(address);
                } else {
                    this.setClosestSegmentSide(secondClosestSegmentSide);
                    this.setClosestRange(secondClosestMatchedRange);
                }
            } else if (this.getClosestSegmentSide() >= 0 && this.getClosestRangeNumber() >= 0) {
                this.m_matchType = 1;
                secondClosestMatchedRange = this.getClosestRangeNumber();
                secondClosestSegmentSide = this.getClosestSegmentSide();
            }
            if (this.getAddressNumberScore() == 1.0) {
                this.isFullHnrMatch = true;
            }
            address.setAddressNumber(addressNumber);
        }
    }

    public boolean isNZLAddressPoint() {
        return this.getSegment().isHouseSegment();
    }

    public double getAddressNumberScore() {
        if (this.m_placeNameInputOnly && this.m_numAddrNumberFieldsMatched == 0) {
            ParsedNumber num = this.getParsedAddressNumber();
            this.m_addressNumber = num != null ? num.getCombinedAddressNumber() : "";
            return 1.0;
        }
        if (this.isNZLAddressPoint() && this.m_numAddrNumberFieldsMatched == 0) {
            return 0.0;
        }
        if (this.getInputNumber() == null || this.m_numAddrNumberFields == 0) {
            return 0.0;
        }
        return (double)this.m_numAddrNumberFieldsMatched / (double)this.m_numAddrNumberFields;
    }

    @Override
    public String getAddressNumber() {
        if (this.m_addressNumber != null) {
            return this.m_addressNumber;
        }
        return super.getAddressNumber();
    }

    public String getFormattedStreetAddress(Address candidateAddress) {
        return NZL_AddressUtils.getFormattedStreetAddress(candidateAddress, true);
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName4();
        if (tmp != null) {
            str.append(tmp);
            str.append(",");
            str.append(" ");
        }
        if ((tmp = this.getAreaName3()) != null) {
            str.append(tmp);
            str.append(" ");
            str.append(" ");
            str.append(" ");
        }
        if ((tmp = this.getPostCode1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        StringBuffer tempGeoResult = new StringBuffer();
        if (cand.getLocationPrecision() == 1) {
            tempGeoResult.append("S5");
        } else if (cand.getLocationPrecision() == 2) {
            tempGeoResult.append("S4");
        } else {
            if (cand.getLocationPrecision() == 6) {
                return "SX";
            }
            if (cand.getLocationPrecision() == 3) {
                return "Z1";
            }
            if (cand.getLocationPrecision() == 4) {
                return "Z2";
            }
            if (cand.getLocationPrecision() == 5) {
                return "Z3";
            }
            if (cand.getLocationPrecision() == 8) {
                return "G1";
            }
            if (cand.getLocationPrecision() == 9) {
                return "G2";
            }
            if (cand.getLocationPrecision() == 10) {
                return "G3";
            }
            if (cand.getLocationPrecision() == 11) {
                return "G4";
            }
            if (cand.getLocationPrecision() == 17) {
                tempGeoResult.append("S7");
            } else if (cand.getLocationPrecision() == 16) {
                tempGeoResult.append("S8");
            }
        }
        if (cand.doesAddressNumberMatch() && this.getInputNumber() != null) {
            tempGeoResult.append('H');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append('P');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesStreetNameMatch() && cand.doStreetPrefixAndSuffixMatch()) {
            tempGeoResult.append('N');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append('T');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPostDirectionalMatch()) {
            tempGeoResult.append('S');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesAreaName3Match()) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostalCode1Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.fromUserDictionary()) {
            tempGeoResult.append("U");
        } else {
            tempGeoResult.append("A");
        }
        return tempGeoResult.toString();
    }

    public int compareTo(Object o2) {
        return this.compare((Object)this, o2);
    }

    public int compare(Object o1, Object o2) {
        NZL_InternalCandidateAddress cand1 = (NZL_InternalCandidateAddress)((Object)o1);
        NZL_InternalCandidateAddress cand2 = (NZL_InternalCandidateAddress)((Object)o2);
        if (cand1.equals((Object)cand2)) {
            return 0;
        }
        boolean bCand1Match = cand1.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        bCand1Match = cand1.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        double score1 = cand1.getCombinedAddressScore();
        double score2 = cand2.getCombinedAddressScore();
        double cand1AddressNumberScore = cand1.getAddressNumberScore();
        double cand2AddressNumberScore = cand2.getAddressNumberScore();
        if ((cand1AddressNumberScore == 1.0 || cand2AddressNumberScore == 1.0) && (cand1.getAreaName3Score() == 1.0 && cand1.getAreaName4Score() == 1.0 || cand2.getAreaName3Score() == 1.0 && cand2.getAreaName4Score() == 1.0) && (score1 = cand1.getFullStreetScore()) != (score2 = cand2.getFullStreetScore())) {
            score1 = cand1.getCombinedAddressScore();
            score2 = cand2.getCombinedAddressScore();
        }
        if (score1 == score2) {
            score1 = cand1.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = cand1.getAddressNumberScore();
            if (score1 < (score2 = cand2.getAddressNumberScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (!cand1.isFullHnrMatch() && cand2.isFullHnrMatch()) {
                return -1;
            }
            if (cand1.isFullHnrMatch() && !cand2.isFullHnrMatch()) {
                return 1;
            }
            if (score1 != 1.0 && score2 != 1.0) {
                if (cand1.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range cand1Closest = cand1.getSegment().getRangeAt(cand1.getClosestRangeNumber(), cand1.getClosestSegmentSide());
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                    long cand1Offset = cand1Closest.getRangeOffset();
                    if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (cand1Offset > cand2Offset) {
                        return -1;
                    }
                    score1 = cand1.m_unitScore;
                    score2 = cand2.m_unitScore;
                    if (score1 < score2) {
                        return -1;
                    }
                    if (score1 > score2) {
                        return 1;
                    }
                    if (cand1.getUnitTypeScore() > cand2.getUnitTypeScore()) {
                        return 1;
                    }
                    if (cand1.getUnitTypeScore() < cand2.getUnitTypeScore()) {
                        return -1;
                    }
                    if (cand1.getDictionaryPriority() < cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                        return 1;
                    }
                    if (cand1.getDictionaryPriority() > cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                        return -1;
                    }
                    return 0;
                }
                if (cand1.hasClosestRange()) {
                    return 1;
                }
                if (cand2.hasClosestRange()) {
                    return -1;
                }
                score1 = cand1.m_unitScore;
                score2 = cand2.m_unitScore;
                if (score1 < score2) {
                    return -1;
                }
                if (score1 > score2) {
                    return 1;
                }
                if (cand1.getUnitTypeScore() > cand2.getUnitTypeScore()) {
                    return 1;
                }
                if (cand1.getUnitTypeScore() < cand2.getUnitTypeScore()) {
                    return -1;
                }
                if (cand1.getDictionaryPriority() < cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                    return 1;
                }
                if (cand1.getDictionaryPriority() > cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                    return -1;
                }
                return 0;
            }
            score1 = cand1.m_unitScore;
            score2 = cand2.m_unitScore;
            if (score1 < score2) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (cand1.getUnitTypeScore() > cand2.getUnitTypeScore()) {
                return 1;
            }
            if (cand1.getUnitTypeScore() < cand2.getUnitTypeScore()) {
                return -1;
            }
            if (cand1.getDictionaryPriority() < cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                return 1;
            }
            if (cand1.getDictionaryPriority() > cand2.getDictionaryPriority() && this.areHnrAndUnitsNotNull(cand1, cand2)) {
                return -1;
            }
            return 0;
        }
        if (score1 < score2) {
            return -1;
        }
        return 1;
    }

    private boolean areHnrAndUnitsNotNull(NZL_InternalCandidateAddress cand1, NZL_InternalCandidateAddress cand2) {
        return cand1.getAddressNumber() != null || cand2.getAddressNumber() != null || cand1.getUnitValue() != null || cand2.getUnitValue() != null;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        result = super.equals(obj);
        if (result) {
            NZL_InternalCandidateAddress other = (NZL_InternalCandidateAddress)((Object)obj);
            if (other.getUnitNumberScore() != this.getUnitNumberScore()) {
                result = false;
            } else if (other.getUnitTypeScore() != this.getUnitTypeScore()) {
                result = false;
            } else {
                int thiRangeNumber = this.getMatchedRangeNumber() > -1 ? this.getMatchedRangeNumber() : -1;
                thiRangeNumber = thiRangeNumber == -1 ? this.getClosestRangeNumber() : thiRangeNumber;
                int otherRangeNumber = other.getMatchedRangeNumber() > -1 ? other.getMatchedRangeNumber() : -1;
                int n = otherRangeNumber = otherRangeNumber == -1 ? other.getClosestRangeNumber() : otherRangeNumber;
                if (thiRangeNumber == -1 && otherRangeNumber == -1 && this.getParsedAddressNumber() == null) {
                    thiRangeNumber = 0;
                    otherRangeNumber = 0;
                }
                if (otherRangeNumber > -1 && thiRangeNumber > -1) {
                    Range thisRnge = this.getSegment().getRangeAt(thiRangeNumber, this.getClosestSegmentSide());
                    Range otherRnge = other.getSegment().getRangeAt(otherRangeNumber, other.getClosestSegmentSide());
                    if (thisRnge != null && otherRnge != null) {
                        if (thisRnge.getRangeUnitCount() > 0 || otherRnge.getRangeUnitCount() > 0) {
                            result = false;
                        }
                    } else if (thisRnge != null && otherRnge == null || thisRnge == null && otherRnge != null) {
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public void scoreAreaNames(ScoringAddress address) {
        double temp;
        NZL_ScoringAddress scoringAddress = (NZL_ScoringAddress)address;
        this.setAreaName1Score(scoringAddress.scoreItems(scoringAddress.getAreaName1(), this.getAreaName1()));
        this.setAreaName2Score(scoringAddress.scoreItems(scoringAddress.getAreaName2(), this.getAreaName2()));
        this.setAreaName3Score(scoringAddress.scoreItems(scoringAddress.getAreaName3(), this.getAreaName3()));
        ArrayList alternateAreaName4List = new ArrayList();
        double candidateScore = scoringAddress.scoreItems(scoringAddress.getAreaName4(), this.getAreaName4());
        if (candidateScore >= 0.86) {
            this.setAreaName4Score(candidateScore);
        } else if (scoringAddress.getAreaName4() != null && !scoringAddress.getAreaName4().equalsIgnoreCase("")) {
            double d;
            temp = this.scoreAreaName4Alternates(scoringAddress, candidateScore, alternateAreaName4List);
            if (d > candidateScore) {
                this.setAreaName4Score(temp);
            }
        }
        if (this.getAreaName3Score() != 1.0 && this.getAreaName4Score() != 1.0) {
            this.setSwappedAreaName3Score(scoringAddress.scoreItems(scoringAddress.getAreaName4(), this.getAreaName3()));
            this.setSwappedAreaName4Score(scoringAddress.scoreItems(scoringAddress.getAreaName3(), this.getAreaName4()));
            if (this.getSwappedAreaName4Score() != 1.0) {
                double d;
                temp = this.reScoreAreaName4Alternates(scoringAddress, candidateScore, alternateAreaName4List);
                if (d > candidateScore && (temp == 1.0 || temp > this.getSwappedAreaName4Score())) {
                    this.setSwappedAreaName4Score(temp);
                }
            }
        }
    }

    public void setUsingSwappedArea34Score(boolean usingSwappedArea34Score) {
        this.m_usingSwappedArea34Score = usingSwappedArea34Score;
    }

    public boolean isUsingSwappedArea34Score() {
        return this.m_usingSwappedArea34Score;
    }

    public double getSwappedAreaName3Score() {
        return this.m_swappedAreaName3Score;
    }

    public double getSwappedAreaName4Score() {
        return this.m_swappedAreaName4Score;
    }

    private void setSwappedAreaName3Score(double swappedAreaName3Score) {
        this.m_swappedAreaName3Score = swappedAreaName3Score;
    }

    private void setSwappedAreaName4Score(double swappedAreaName4Score) {
        this.m_swappedAreaName4Score = swappedAreaName4Score;
    }

    private String getMeshBlock(Segment segment) {
        NZL_Segment NZLsegment = (NZL_Segment)segment;
        if (this.getClosestSegmentSide() == 0) {
            return NZLsegment.getMeshBlockIdLeft();
        }
        if (this.getClosestSegmentSide() == 1) {
            return NZLsegment.getMeshBlockIdRight();
        }
        String left = NZLsegment.getMeshBlockIdLeft();
        String right = NZLsegment.getMeshBlockIdRight();
        if (left != null && right != null && left.equals(right) || left != null && right == null) {
            return NZLsegment.getMeshBlockIdLeft();
        }
        if (left == null && right != null) {
            return NZLsegment.getMeshBlockIdRight();
        }
        return null;
    }

    private int getUniqueIdentifier(Segment segment) {
        NZL_Segment NZLsegment = (NZL_Segment)segment;
        return NZLsegment.getUniqueId();
    }

    @Override
    public String getFormattedStreetAddress() {
        NZL_ThoroughfareTypes.NZL_ThoroughfareType type;
        String outputTT;
        StringBuffer str = new StringBuffer();
        if (this.m_adjustS4) {
            str.append(this.getInputNumber().getCombinedAddressNumber());
            str.append(" ");
        } else if (this.getAddressNumber() != null) {
            str.append(this.getAddressNumber());
            str.append(' ');
        }
        if (this.getPreDirectional() != null) {
            str.append(this.getPreDirectional());
            str.append(' ');
        }
        if (this.getPreThoroughfareType() != null) {
            outputTT = this.getPreThoroughfareType();
            type = NZL_ThoroughfareTypes.getThoroughfareType(outputTT);
            if (type != null) {
                outputTT = type.getExpandedTypeName();
            }
            str.append(outputTT);
            str.append(' ');
        }
        if (this.getPreAddress() != null) {
            str.append(this.getPreAddress());
            str.append(' ');
        }
        if (this.getMainAddress() != null) {
            str.append(this.getMainAddress());
            str.append(' ');
        }
        if (this.getPostAddress() != null) {
            str.append(this.getPostAddress());
            str.append(' ');
        }
        if (this.getPostThoroughfareType() != null) {
            outputTT = this.getPostThoroughfareType();
            type = NZL_ThoroughfareTypes.getThoroughfareType(outputTT);
            if (type != null) {
                outputTT = type.getExpandedTypeName();
            }
            str.append(outputTT);
            str.append(' ');
        }
        if (this.getPostDirectional() != null) {
            str.append(this.getPostDirectional());
        }
        return str.toString().trim();
    }

    @Override
    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        Segment segment = this.getSegment();
        int segmentPointCount = segment.getSegmentPointCount();
        if (segment.isHouseSegment()) {
            DirectPosition housePoint = this.getAddressNumberHousePoint();
            if (housePoint != null) {
                candidate.setLocation(housePoint);
                candidate.setLocationPrecision(16);
            }
        } else if (this.isPointHouseCandidate(constraints)) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            if (this.hasMatchingRange() || this.hasClosestRange()) {
                candidate.setLocationPrecision(16);
            } else {
                candidate.setLocationPrecision(2);
            }
        } else if (segmentPointCount == 1) {
            candidate.setLocation(segment.getSegmentPointAt(0));
            candidate.setLocationPrecision(1);
        } else if (segmentPointCount != 0) {
            int rangeNumber;
            int segmentSide = this.getSegmentSide();
            if (segmentSide < 0) {
                segmentSide = this.getClosestSegmentSide();
            }
            if ((rangeNumber = this.getMatchedRangeNumber()) < 0) {
                rangeNumber = this.getClosestRangeNumber();
            }
            if (segmentSide < 0 || rangeNumber < 0) {
                candidate.setLocation(Interpolator.interpolateShapePath((List)segment.getSegmentPoints()));
                if (candidate.getLocation() != null) {
                    candidate.setLocationPrecision(2);
                }
            } else {
                List pointHouseCandidates = this.findAllPointHouseCandidates(constraints);
                if (pointHouseCandidates == null) {
                    double percentage = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getParsedAddressNumber());
                    if (this.getSecondHNRangedAddress() != null) {
                        double percentage2 = this.getHouseNumberPercentage(segmentSide, rangeNumber, this.getSecondHNRangedAddress());
                        percentage = (percentage + percentage2) / 2.0;
                    }
                    candidate.setLocation(Interpolator.interpolate((List)segment.getSegmentPoints(), (segmentSide == 0 ? 1 : 0) != 0, (double)percentage, (Length)constraints.getCornerOffsetAsLength(), (Length)constraints.getStreetOffsetAsLength()));
                    if (candidate.getLocation() != null) {
                        candidate.setLocationPrecision(1);
                    }
                } else {
                    DirectPosition exactPointHouse = this.findExactPointHouse(pointHouseCandidates);
                    if (exactPointHouse != null) {
                        candidate.setLocation(exactPointHouse);
                        candidate.setLocationPrecision(16);
                    } else {
                        this.filterPointCandidates(pointHouseCandidates, segmentSide);
                        this.interpolateUsingPointHouses(candidate, pointHouseCandidates, constraints, segmentSide, rangeNumber);
                    }
                }
            }
        } else {
            DirectPosition exactPointHouse;
            List pointCandidates = this.findAllPointHouseCandidates(constraints);
            if (pointCandidates != null && (exactPointHouse = this.findExactPointHouse(pointCandidates)) != null) {
                candidate.setLocation(exactPointHouse);
                candidate.setLocationPrecision(16);
            }
        }
        if (candidate.getLocationPrecision() != 0) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)candidate.getLocationPoint()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        }
        if (candidate.getLocationPrecision() == 1 && this.isNZLAddressPoint()) {
            candidate.setLocationPrecision(16);
        }
    }

    private double scoreAreaName4Alternates(NZL_ScoringAddress scoringAddress, double candidateScore, ArrayList alternateAreaName4List) {
        EMEA_GeoInfoRecord geoRecord = null;
        int highestScoreKey = 0;
        double highestScore = 0.0;
        String combinedAliasKey = this.getAreaName4();
        alternateAreaName4List = NZL_DataManager.getGeoInfoAlias(combinedAliasKey = combinedAliasKey + (this.getAreaName1() == null ? "" : this.getAreaName1()), "", this.getStreetCandidateAddress().getDictionaryNumber());
        if (alternateAreaName4List != null) {
            int recordSize = alternateAreaName4List.size();
            for (int n = 0; n < recordSize; ++n) {
                geoRecord = (EMEA_GeoInfoRecord)((Object)alternateAreaName4List.get(n));
                String candSuburbAlias = geoRecord.getAltAreaName4();
                if (NZL_AddressUtils.isEmpty(candSuburbAlias)) continue;
                double score = scoringAddress.scoreItems(scoringAddress.getAreaName4(), candSuburbAlias);
                if (score == 1.0) {
                    highestScore = score;
                    highestScoreKey = n;
                    this.isAliasSuburbMatch = true;
                    break;
                }
                if (!(score > 0.86) || !(score > highestScore)) continue;
                highestScore = score;
                highestScoreKey = n;
            }
        }
        if (alternateAreaName4List.size() > 0 && highestScore >= candidateScore) {
            this.m_SuburbAlias = ((EMEA_GeoInfoRecord)((Object)alternateAreaName4List.get(highestScoreKey))).getAltAreaName4();
        }
        return highestScore;
    }

    private double reScoreAreaName4Alternates(NZL_ScoringAddress scoringAddress, double candidateScore, ArrayList alternateAreaName4List) {
        EMEA_GeoInfoRecord geoRecord = null;
        int highestScoreKey = 0;
        double highestScore = 0.0;
        if (alternateAreaName4List.size() == 0) {
            String combinedAliasKey = this.getAreaName4();
            combinedAliasKey = combinedAliasKey + (this.getAreaName1() == null ? "" : this.getAreaName1());
            alternateAreaName4List = NZL_DataManager.getGeoInfoAlias(combinedAliasKey, "", this.getStreetCandidateAddress().getDictionaryNumber());
        }
        if (alternateAreaName4List != null) {
            int recordSize = alternateAreaName4List.size();
            for (int n = 0; n < recordSize; ++n) {
                geoRecord = (EMEA_GeoInfoRecord)((Object)alternateAreaName4List.get(n));
                String candSuburbAlias = geoRecord.getAltAreaName4();
                if (NZL_AddressUtils.isEmpty(candSuburbAlias)) continue;
                double score = scoringAddress.scoreItems(scoringAddress.getAreaName3(), candSuburbAlias);
                if (score == 1.0) {
                    highestScore = score;
                    highestScoreKey = n;
                    this.isAliasSuburbMatch = true;
                    break;
                }
                if (!(score > 0.86) || !(score > highestScore)) continue;
                highestScore = score;
                highestScoreKey = n;
            }
        }
        if (alternateAreaName4List.size() > 0 && highestScore >= candidateScore) {
            this.m_SuburbAlias = ((EMEA_GeoInfoRecord)((Object)alternateAreaName4List.get(highestScoreKey))).getAltAreaName4();
        }
        alternateAreaName4List = null;
        return highestScore;
    }

    public int getCntAddressNumberFieldsMatched() {
        int fieldsMatched = super.getCntAddressNumberFieldsMatched();
        ParsedNumber inputNumber = this.getInputNumber();
        if (inputNumber != null) {
            char c;
            String addrSuffix;
            if (fieldsMatched == inputNumber.getNumFields() || fieldsMatched == 0) {
                return fieldsMatched;
            }
            if (!this.isNZLAddressPoint() && (addrSuffix = this.getInputNumber().getAddressSuffix().trim()) != null && addrSuffix.length() == 1 && (c = addrSuffix.toUpperCase().charAt(0)) >= 'A' && c <= 'Z') {
                ++fieldsMatched;
            }
        }
        return fieldsMatched;
    }

    public boolean isFullHnrMatch() {
        return this.isFullHnrMatch;
    }

    public boolean isAliasSuburbMatch() {
        return this.isAliasSuburbMatch;
    }

    public static String reconstructAddress(InternalCandidateAddress cand) {
        return cand.getFormattedStreetAddress();
    }

    public void scoreUnitNumber(ScoringAddress scoringAddress) {
        if (scoringAddress.getParsedAddressNumber() == null) {
            int rangeCount = this.getSegment().getRangeCount(0);
            int segmentSide = rangeCount > 0 ? 0 : 1;
            for (int i = 0; i < rangeCount; ++i) {
                Range range = this.getSegment().getRangeAt(i, segmentSide);
                this.setInputUnitId(scoringAddress.getParsedUnitValue());
                range.findMatchingRangeUnit(this.getInputUnitId(), scoringAddress.getUnitType());
                if (range.hasMatchingRangeUnit()) continue;
                range.findClosestRangeUnit(scoringAddress);
            }
        }
        double tempScore = 0.0;
        String candLowUnit = this.getUnitValue();
        String candHighUnit = this.getUnitValue();
        String inputUnitValue = scoringAddress.getUnitValue();
        if (inputUnitValue != null && candLowUnit != null && candHighUnit != null) {
            int indexOfDash = inputUnitValue.indexOf(45);
            String firstInputVal = null;
            String secondInputVal = null;
            if (indexOfDash >= 0) {
                firstInputVal = inputUnitValue.substring(0, indexOfDash);
                secondInputVal = inputUnitValue.substring(indexOfDash + 1, inputUnitValue.length());
            }
            double firstPartScore = 0.0;
            double secondPartScore = 0.0;
            double score = 0.0;
            if (firstInputVal != null && secondInputVal != null) {
                if (candLowUnit != null && candHighUnit != null && !candLowUnit.equalsIgnoreCase(candHighUnit)) {
                    firstPartScore = this.scoreUnitValue(scoringAddress, candLowUnit, score, firstInputVal);
                    secondPartScore = this.scoreUnitValue(scoringAddress, candHighUnit, score, secondInputVal);
                    tempScore = (firstPartScore + secondPartScore) / 2.0;
                } else {
                    firstPartScore = this.scoreUnitValue(scoringAddress, candLowUnit, score, firstInputVal);
                    secondPartScore = this.scoreUnitValue(scoringAddress, candHighUnit, score, secondInputVal);
                    tempScore = (firstPartScore + secondPartScore) / 2.0;
                }
            } else if (candLowUnit != null && candHighUnit != null && !candLowUnit.equalsIgnoreCase(candHighUnit)) {
                firstPartScore = this.scoreUnitValue(scoringAddress, candLowUnit, score, inputUnitValue);
                secondPartScore = this.scoreUnitValue(scoringAddress, candHighUnit, score, inputUnitValue);
                tempScore = (firstPartScore + secondPartScore) / 2.0;
            } else {
                tempScore = score = this.scoreUnitValue(scoringAddress, candLowUnit, score, inputUnitValue);
            }
        }
        if (tempScore > this.m_unitScore) {
            this.setUnitNumberScore(tempScore);
        }
    }

    private double scoreUnitValue(ScoringAddress scoringAddress, String unitValue, double score, String inputUnitValue) {
        double tempScore = ((NZL_ScoringAddress)scoringAddress).scoreItems(inputUnitValue, unitValue);
        if (tempScore > score) {
            score = tempScore;
            if (tempScore != 1.0) {
                score -= 0.01;
            }
        }
        return score;
    }

    public void computeScores(ScoringAddress scoringAddress, String charsToIgnore) {
        super.computeScores(scoringAddress, charsToIgnore);
    }

    public void scoreUnitType(ScoringAddress scoringAddress) {
        double tempScore = 0.0;
        String candLowUnit = this.getUnitValue();
        String candHighUnit = this.getUnitValue();
        String candUnitType = this.getUnitType();
        String inputUnitType = scoringAddress.getUnitType();
        tempScore = StringUtilities.isEmpty((String)candUnitType) && StringUtilities.isEmpty((String)inputUnitType) ? 1.0 : (StringUtilities.isEmpty((String)candUnitType) && !StringUtilities.isEmpty((String)candLowUnit) && !StringUtilities.isEmpty((String)candHighUnit) && !StringUtilities.isEmpty((String)scoringAddress.getUnitValue()) ? 0.95 : ((NZL_ScoringAddress)scoringAddress).scoreItems(inputUnitType, candUnitType));
        if (tempScore > this.m_unitTypeFinalScore) {
            this.m_unitTypeFinalScore = tempScore;
            this.setUnitTypeScore(tempScore);
        }
    }

    public double getUnitNumberScore() {
        return this.m_unitScore;
    }

    public void setUnitNumberScore(double unitNumberScore) {
        this.m_unitScore = unitNumberScore;
    }

    public String getUnitValue() {
        String unitValue = null;
        if (unitValue == null) {
            Range range;
            int rangeNumber = this.getMatchedRangeNumber() > -1 ? this.getMatchedRangeNumber() : -1;
            int n = rangeNumber = rangeNumber == -1 ? this.getClosestRangeNumber() : rangeNumber;
            if (rangeNumber > -1 && (range = this.getSegment().getRangeAt(rangeNumber, this.getClosestSegmentSide())) != null) {
                RangeUnit rangeUnit = null;
                if (range.hasMatchingRangeUnit()) {
                    rangeUnit = range.getRangeUnitAt(range.getMatchingRangeUnit());
                } else if (range.hasClosestRangeUnit()) {
                    rangeUnit = range.getRangeUnitAt(range.getClosestRangeUnit());
                }
                if (rangeUnit != null) {
                    unitValue = rangeUnit.getLowUnit();
                    unitValue = rangeUnit.getHighUnit() != null && !rangeUnit.getHighUnit().equalsIgnoreCase(unitValue) ? unitValue + "-" + rangeUnit.getHighUnit() : unitValue;
                }
            }
        }
        return unitValue;
    }

    public String getUnitType() {
        Range range;
        String unitType = null;
        int rangeNumber = -1;
        rangeNumber = this.getMatchedRangeNumber() > -1 ? this.getMatchedRangeNumber() : -1;
        int n = rangeNumber = rangeNumber == -1 ? this.getClosestRangeNumber() : rangeNumber;
        if (rangeNumber > -1 && (range = this.getSegment().getRangeAt(rangeNumber, this.getClosestSegmentSide())) != null) {
            RangeUnit rangeUnit = null;
            if (range.hasMatchingRangeUnit()) {
                rangeUnit = range.getRangeUnitAt(range.getMatchingRangeUnit());
            } else if (range.hasClosestRangeUnit()) {
                rangeUnit = range.getRangeUnitAt(range.getClosestRangeUnit());
            }
            unitType = rangeUnit != null ? rangeUnit.getUnitType() : null;
        }
        return unitType;
    }

    protected DirectPosition getAddressNumberHousePoint() {
        DirectPosition addresNumberPoint = super.getAddressNumberHousePoint();
        if (addresNumberPoint == null && this.isNZLAddressPoint()) {
            Segment segment = this.getSegment();
            addresNumberPoint = segment.getHousePoint(segment.getRangeAt(0, 0).getRangeNumber());
        }
        return addresNumberPoint;
    }

    @Override
    public void checkSegmentSides(ScoringAddress parsedAddress, int side) {
        if (this.m_bInputNumberNull || this.getInputNumber() == null) {
            return;
        }
        Segment segment = this.getSegment();
        Range bestRange = null;
        double bestRangePlaceNameScore = 0.0;
        double placeMinimum = this.getPlaceInRangeMinimum();
        if (segment == null) {
            return;
        }
        ParsedNumber unitNumber = new ParsedNumber(parsedAddress.getUnitValue());
        String unitType = parsedAddress.getUnitType();
        List rangeList = segment.getRanges(side);
        int inputOddEven = this.getInputNumber().isRangeOddEvenBoth();
        int count = rangeList.size();
        for (int i = 0; i < count; ++i) {
            double rangePlaceNameScore;
            Range range = (Range)rangeList.get(i);
            int oddEven = range.getOddEven();
            if (!(oddEven == 0 || oddEven == 2 && inputOddEven != 1 || oddEven == 1 && inputOddEven != 2) && (oddEven != 5 || range.getIntermediateRecordArray() == null)) continue;
            int fieldsMatched = range.isNumberInRange(this.getInputNumber());
            if (fieldsMatched > 0 && unitNumber != null) {
                range.findMatchingRangeUnit(unitNumber, unitType);
                if (!range.hasMatchingRangeUnit()) {
                    range.findClosestRangeUnit(parsedAddress);
                }
            }
            if ((rangePlaceNameScore = parsedAddress.scorePlaceName(range.getPlaceName())) < placeMinimum) {
                rangePlaceNameScore = 0.0;
            }
            if (fieldsMatched > this.getCntAddressNumberFieldsMatched()) {
                if (fieldsMatched == 3 && !range.getParsedFrom().isHyphenatedNumber() && this.getInputNumber().isHyphenatedNumber() || range.getParsedFrom().isHyphenatedNumber() && !this.getInputNumber().isHyphenatedNumber()) continue;
                this.setCntAddressNumberFieldsMatched(fieldsMatched);
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (fieldsMatched <= 0 || fieldsMatched != this.getCntAddressNumberFieldsMatched()) continue;
            if (bestRange == null) {
                bestRange = (Range)segment.getRanges(this.getSegmentSide()).get(this.getMatchedRangeNumber());
                bestRangePlaceNameScore = parsedAddress.scorePlaceName(bestRange.getPlaceName());
            }
            if (range.computeAddressesInRange() < bestRange.computeAddressesInRange()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && !bestRange.hasMatchingRangeUnit()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && bestRange.hasMatchingRangeUnit() && range.getRangeUnitAt(range.getMatchingRangeUnit()).getTypeMatched() && !bestRange.getRangeUnitAt(bestRange.getMatchingRangeUnit()).getTypeMatched()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (rangePlaceNameScore > bestRangePlaceNameScore) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                this.setSegmentSide(side);
                bestRangePlaceNameScore = rangePlaceNameScore;
                continue;
            }
            if (bestRange.hasMatchingRangeUnit() || !range.hasClosestRangeUnit() || !bestRange.hasClosestRangeUnit() || !range.getRangeUnitAt(range.getClosestRangeUnit()).getTypeMatched() || bestRange.getRangeUnitAt(bestRange.getClosestRangeUnit()).getTypeMatched()) continue;
            this.setMatchedRangeNumber(i);
            bestRange = range;
            bestRangePlaceNameScore = rangePlaceNameScore;
            this.setSegmentSide(side);
        }
    }

    public void setFullStreetScore(double streetScore) {
        this.m_streetScore = streetScore;
    }

    public double getFullStreetScore() {
        return this.m_streetScore;
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        ReverseGeocodeCandidateAddress candidate = super.toCandidateAddress(location, constraints);
        if (this.isNZLAddressPoint()) {
            candidate.getAdditionalFields().remove("SEGMENT_ID");
            ICandidateRangeIterator it = candidate.rangeIterator();
            if (it.hasNext()) {
                NZL_CandidateRange nzCandRange = (NZL_CandidateRange)it.next();
                NZL_CandidateRangeUnit nzCandUnit = (NZL_CandidateRangeUnit)nzCandRange.getRangeUnitAt(0);
                if (nzCandUnit != null) {
                    candidate.getAdditionalFields().put("KEY_UFI", String.valueOf(nzCandUnit.getUniqueId()));
                }
                candidate.getAdditionalFields().put("NZL_MESHBLOCK_ID", nzCandRange.getMeshBlockIdLeft());
            }
        } else {
            NZL_Segment nzSegment = (NZL_Segment)this.getSegment();
            candidate.getAdditionalFields().put("KEY_UFI", String.valueOf(nzSegment.getUniqueId()));
            candidate.getAdditionalFields().put("NZL_MESHBLOCK_ID", this.getMeshBlock(nzSegment));
        }
        candidate.setAddressNumber(this.getAddressNumber());
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress((Address)candidate));
        return candidate;
    }
}

