/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StringScorer;
import java.util.Locale;
import java.util.StringTokenizer;

public class NZL_InternalGeographicCandidate
extends EMEA_InternalGeographicCandidate {
    private static final double EXACT_CLOSE_MATCH_SCORE = 0.97;
    private boolean m_usingSwappedANScores;

    public NZL_InternalGeographicCandidate() {
        this.setStringScorer(new StringScorer(true, new Locale("en", "NZ"), ""));
    }

    public String toString() {
        return "\nNZL_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        StringScorer scorer = this.getStringScorer();
        String pAreaName3 = inputAddress.getAreaName3();
        pAreaName3 = pAreaName3 != null ? pAreaName3.toUpperCase() : pAreaName3;
        String cAreaName3 = this.getAreaName3();
        cAreaName3 = cAreaName3 != null ? cAreaName3.toUpperCase() : cAreaName3;
        String pAreaName4 = inputAddress.getAreaName4();
        pAreaName4 = pAreaName4 != null ? pAreaName4.toUpperCase() : pAreaName4;
        String cAreaName4 = this.getAreaName4();
        cAreaName4 = cAreaName4 != null ? cAreaName4.toUpperCase() : cAreaName4;
        String pAreaName1 = inputAddress.getAreaName1();
        String cAreaName1 = this.getAreaName1();
        double highScore = 0.0;
        double score = 0.0;
        double tempScore = 0.0;
        double areaName3Score = 0.0;
        double areaName4Score = 0.0;
        double swappedAreaName3Score = 0.0;
        double swappedAreaName4Score = 0.0;
        double tempswappedAreaName3Score = 0.0;
        double tempswappedAreaName4Score = 0.0;
        if (pAreaName3 != null) {
            areaName3Score = scorer.scoreString(pAreaName3, cAreaName3, charsToIgnore);
            if (areaName3Score != 1.0) {
                tempScore = this.scoreByExpandingAbbreviation(pAreaName3, cAreaName3, charsToIgnore);
            }
            areaName3Score = areaName3Score > tempScore ? areaName3Score : tempScore;
        }
        highScore = 0.0;
        if (pAreaName4 != null) {
            areaName4Score = scorer.scoreString(pAreaName4, cAreaName4, charsToIgnore);
            if (areaName4Score != 1.0) {
                score = this.scoreByExpandingAbbreviation(pAreaName4, cAreaName4, charsToIgnore);
            }
            double d = areaName4Score = areaName4Score > score ? areaName4Score : score;
        }
        if (areaName3Score <= 0.935 && areaName4Score <= 0.935) {
            swappedAreaName3Score = scorer.scoreString(pAreaName4, cAreaName3, charsToIgnore);
            if (swappedAreaName3Score != 1.0) {
                tempswappedAreaName3Score = this.scoreByExpandingAbbreviation(pAreaName4, cAreaName3, charsToIgnore);
                double d = swappedAreaName3Score = tempswappedAreaName3Score > swappedAreaName3Score ? tempswappedAreaName3Score : swappedAreaName3Score;
            }
            if ((swappedAreaName4Score = scorer.scoreString(pAreaName3, cAreaName4, charsToIgnore)) != 1.0) {
                tempswappedAreaName4Score = this.scoreByExpandingAbbreviation(pAreaName3, cAreaName4, charsToIgnore);
                double d = swappedAreaName4Score = tempswappedAreaName4Score > swappedAreaName4Score ? tempswappedAreaName4Score : swappedAreaName4Score;
            }
        }
        if (swappedAreaName3Score > areaName3Score || swappedAreaName4Score > areaName4Score) {
            areaName3Score = swappedAreaName3Score;
            areaName4Score = swappedAreaName4Score;
            this.m_usingSwappedANScores = true;
        }
        this.setAreaName3Score(areaName3Score);
        this.setAreaName4Score(areaName4Score);
        if (this.getAreaName3Score() >= 0.9 && this.getAreaName4Score() == 0.0) {
            this.setAreaName4Score(0.497);
        }
        if (this.getAreaName4Score() >= 0.9 && this.getAreaName3Score() <= 0.09) {
            this.setAreaName3Score(0.32);
        }
        highScore = 0.0;
        if (pAreaName1 != null) {
            highScore = scorer.scoreString(pAreaName1, cAreaName1, charsToIgnore);
        }
        this.setAreaName1Score(highScore);
        this.setCountryScore(1.0);
    }

    public double scoreByExpandingAbbreviation(String pAreaName, String cAreaName, String charsToIgnore) {
        double newScore = 0.0;
        if (pAreaName != null && cAreaName != null) {
            String term;
            StringTokenizer inputToker = new StringTokenizer(pAreaName, ".,- ", false);
            StringTokenizer candToker = new StringTokenizer(cAreaName, ".,- ", false);
            StringBuffer candFullName = new StringBuffer();
            StringBuffer inputFullName = new StringBuffer();
            boolean foundInputAbbr = false;
            boolean foundCandAbbr = false;
            while (inputToker.hasMoreTokens()) {
                term = inputToker.nextToken();
                if (NZL_Abbreviations.isAbbreviation(term)) {
                    foundInputAbbr = true;
                    term = NZL_Abbreviations.expandAbbreviations(term);
                }
                inputFullName.append(term + " ");
            }
            while (candToker.hasMoreTokens()) {
                term = candToker.nextToken();
                if (NZL_Abbreviations.isAbbreviation(term)) {
                    foundCandAbbr = true;
                    term = NZL_Abbreviations.expandAbbreviations(term);
                }
                candFullName.append(term + " ");
            }
            if (foundCandAbbr || foundInputAbbr) {
                newScore = this.getStringScorer().scoreString(candFullName.toString(), inputFullName.toString(), charsToIgnore);
            }
        }
        return newScore;
    }

    public boolean isUsingSwappedArea34Score() {
        return this.m_usingSwappedANScores;
    }
}

