/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_MatcherHandler;
import com.mapinfo.mapmarker.NZL.NZL_InternalCandidateAddress;
import com.mapinfo.mapmarker.NZL.NZL_InternalMatcherConstants;
import com.mapinfo.mapmarker.NZL.NZL_StreetMultipleSegmentComparator;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.utils.StringUtilities;

public final class NZL_MatcherHandler
extends EMEA_MatcherHandler {
    public NZL_MatcherHandler() {
        this.setComparator(new NZL_StreetMultipleSegmentComparator());
    }

    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        double maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        maximumAddressScore = this.fieldExists(parsedAddress.getAddressNumber()) ? (maximumAddressScore += matchedConstants.getAddressNumber()) : (maximumAddressScore += blankConstants.getAddressNumber());
        maximumAddressScore = this.fieldExists(parsedAddress.getPlaceName()) ? (maximumAddressScore += matchedConstants.getPlaceName()) : (maximumAddressScore += blankConstants.getPlaceName());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPreThoroughfareType()) : (maximumAddressScore += blankConstants.getPreThoroughfareType());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreAddress()) ? (maximumAddressScore += matchedConstants.getPreAddress()) : (maximumAddressScore += blankConstants.getPreAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getMainAddress()) ? (maximumAddressScore += matchedConstants.getMainAddress()) : (maximumAddressScore += blankConstants.getMainAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostAddress()) ? (maximumAddressScore += matchedConstants.getPostAddress()) : (maximumAddressScore += blankConstants.getPostAddress());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostThoroughfareType()) ? (maximumAddressScore += matchedConstants.getPostThoroughfareType()) : (maximumAddressScore += blankConstants.getPostThoroughfareType());
        maximumAddressScore = this.fieldExists(parsedAddress.getPostDirectional()) ? (maximumAddressScore += matchedConstants.getPostDirectional()) : (maximumAddressScore += blankConstants.getPostDirectional());
        maximumAddressScore = this.fieldExists(parsedAddress.getPreDirectional()) ? (maximumAddressScore += matchedConstants.getPreDirectional()) : (maximumAddressScore += blankConstants.getPreDirectional());
        if (parsedAddress.hasAdditionalFields()) {
            maximumAddressScore += matchedConstants.getAdditionalFields() * (double)parsedAddress.getAdditionalFields().size();
        }
        this.setMaximumAddressScore(maximumAddressScore);
    }

    @Override
    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        NZL_InternalCandidateAddress nzlCandidate = (NZL_InternalCandidateAddress)candidate;
        double score = 0.0;
        candidate.computeScores(scoringAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        double streetScore = 0.0;
        if (this.fieldExists(scoringAddress.getPlaceName())) {
            if (!this.fieldExists(scoringAddress.getMainAddress())) {
                score += candidate.getPlaceNameScore() * matchedConstants.getMainAddress();
            } else {
                score += candidate.getPlaceNameScore() * matchedConstants.getPlaceName();
                if (candidate.getPlaceNameScore() != 1.0 && candidate.getAddressNumberScore() == 1.0) {
                    score -= 0.021;
                }
            }
        } else {
            score += candidate.getPlaceNameScore() * blankConstants.getPlaceName();
        }
        score = this.fieldExists(scoringAddress.getPreAddress()) || this.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress() * candidate.getPreAddressScore());
        score = this.fieldExists(scoringAddress.getMainAddress()) || this.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        score = this.fieldExists(scoringAddress.getPostAddress()) || this.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress() * candidate.getPostAddressScore());
        score = this.fieldExists(scoringAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType()) ? (score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore()) : (score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore());
        score = this.fieldExists(scoringAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType()) ? (score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore()) : (score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore());
        score = this.fieldExists(scoringAddress.getPostDirectional()) || this.fieldExists(candidate.getPostDirectional()) ? (score += matchedConstants.getPostDirectional() * candidate.getPostDirectionalScore()) : (score += blankConstants.getPostDirectional() * candidate.getPostDirectionalScore());
        score = this.fieldExists(scoringAddress.getPreDirectional()) || this.fieldExists(candidate.getPreDirectional()) ? (score += matchedConstants.getPreDirectional() * candidate.getPreDirectionalScore()) : (score += blankConstants.getPreDirectional() * candidate.getPreDirectionalScore());
        if (scoringAddress.hasAdditionalFields()) {
            score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore();
        }
        streetScore = score;
        ((NZL_InternalCandidateAddress)candidate).setFullStreetScore(streetScore);
        score = this.fieldExists(scoringAddress.getAddressNumber()) ? (score += candidate.getAddressNumberScore() * matchedConstants.getAddressNumber()) : (score += candidate.getAddressNumberScore() * blankConstants.getAddressNumber());
        candidate.setCombinedAddressScore(score / this.getMaximumAddressScore());
        score = 0.0;
        score = this.fieldExists(scoringAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1());
        score = this.fieldExists(scoringAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1());
        double standardArea34Score = score;
        standardArea34Score = this.fieldExists(scoringAddress.getAreaName3()) ? (standardArea34Score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (standardArea34Score += blankConstants.getAreaName3());
        standardArea34Score = this.fieldExists(scoringAddress.getAreaName4()) ? (standardArea34Score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (standardArea34Score += blankConstants.getAreaName4());
        double swappedArea34Score = score;
        swappedArea34Score = this.fieldExists(scoringAddress.getAreaName3()) ? (scoringAddress.getAreaName4() == null && scoringAddress.getAreaName3() != null ? (swappedArea34Score += matchedConstants.getAreaName3() * nzlCandidate.getSwappedAreaName4Score()) : (swappedArea34Score += matchedConstants.getAreaName3() * nzlCandidate.getSwappedAreaName3Score())) : (nzlCandidate.getSwappedAreaName3Score() == 1.0 ? (swappedArea34Score += matchedConstants.getAreaName4() * nzlCandidate.getSwappedAreaName3Score()) : (swappedArea34Score += blankConstants.getAreaName3()));
        swappedArea34Score = this.fieldExists(scoringAddress.getAreaName4()) || nzlCandidate.getSwappedAreaName4Score() == 1.0 ? (scoringAddress.getAreaName3() == null && scoringAddress.getAreaName4() != null ? (swappedArea34Score += matchedConstants.getAreaName4() * nzlCandidate.getSwappedAreaName3Score()) : (swappedArea34Score += matchedConstants.getAreaName4() * nzlCandidate.getSwappedAreaName4Score())) : (swappedArea34Score += blankConstants.getAreaName4());
        swappedArea34Score /= this.getMaximumAdditionalFieldScore();
        if ((standardArea34Score /= this.getMaximumAdditionalFieldScore()) >= constants.getAdditionalFieldsCutOff() || swappedArea34Score < constants.getAdditionalFieldsCutOff()) {
            if (standardArea34Score > swappedArea34Score) {
                nzlCandidate.setCombinedAdditionalFieldScore(standardArea34Score);
                nzlCandidate.setUsingSwappedArea34Score(false);
            } else {
                nzlCandidate.setCombinedAdditionalFieldScore(swappedArea34Score);
                nzlCandidate.setUsingSwappedArea34Score(true);
            }
        } else {
            nzlCandidate.setCombinedAdditionalFieldScore(swappedArea34Score);
            nzlCandidate.setUsingSwappedArea34Score(true);
        }
        candidate.buildInputMatchScore((Address)scoringAddress, matchedConstants);
    }

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants matcherConstants, ScoringAddress scoringAddress) {
        if (candidate instanceof NZL_InternalCandidateAddress && ((NZL_InternalCandidateAddress)candidate).isNZLAddressPoint() && !candidate.isHouseNumberFromPlaceMatch() && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && StringUtilities.isEmpty((String)candidate.getAddressNumber())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode2() && candidate.getPostCode2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPreAddressScore() != 1.0 || candidate.getPostAddressScore() != 1.0 || candidate.getPreThoroughfareTypeScore() != 1.0 || candidate.getPostThoroughfareTypeScore() != 1.0 || candidate.getPreDirectionalScore() != 1.0 || candidate.getPostDirectionalScore() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0 && ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName3Score() != 1.0) {
            if (scoringAddress.getAreaName4() == null && ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName4Score() != 1.0) {
                candidate.setCloseMatchFlag(false);
                return;
            }
            if (scoringAddress.getAreaName4() != null) {
                candidate.setCloseMatchFlag(false);
                return;
            }
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0 && ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName4Score() != 1.0) {
            if (scoringAddress.getAreaName3() == null && ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName3Score() != 1.0) {
                candidate.setCloseMatchFlag(false);
                return;
            }
            if (scoringAddress.getAreaName3() != null) {
                candidate.setCloseMatchFlag(false);
                return;
            }
        }
        if (candidate.getCombinedAddressScore() < matcherConstants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        double additionalFieldsCutOff = matcherConstants.getAdditionalFieldsCutOff();
        if (scoringAddress.getAreaName4() != null && scoringAddress.getAreaName3() != null && scoringAddress.getPostCode1() == null) {
            additionalFieldsCutOff = candidate.getAreaName3Score() == 1.0 || candidate.getAreaName4Score() == 1.0 || ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName3Score() == 1.0 || ((NZL_InternalCandidateAddress)candidate).getSwappedAreaName4Score() == 1.0 ? 0.49 : ((NZL_InternalMatcherConstants)matcherConstants).getNoPostcodeExemptionCutOff();
        } else if (scoringAddress.getAreaName3() != null && scoringAddress.getPostCode1() != null && scoringAddress.getAreaName4() == null) {
            additionalFieldsCutOff = ((NZL_InternalMatcherConstants)matcherConstants).getNoSuburbExemptionCutOff();
        } else if (scoringAddress.getAreaName4() != null && scoringAddress.getPostCode1() != null && scoringAddress.getAreaName3() == null) {
            additionalFieldsCutOff = ((NZL_InternalMatcherConstants)matcherConstants).getNoTownExemptionCutOff();
        } else if (scoringAddress.getAreaName4() != null && scoringAddress.getPostCode1() != null && scoringAddress.getAreaName3() != null) {
            additionalFieldsCutOff = candidate.getPostCode1Score() == 0.0 ? 0.659 : ((NZL_InternalMatcherConstants)matcherConstants).getAllLocationsExemptionCutOff();
        }
        if (candidate.getCombinedAdditionalFieldScore() < additionalFieldsCutOff) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    @Override
    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        if (!this.stringEquals(best.getPostCode1(), other.getPostCode1())) {
            return false;
        }
        if (!this.stringEquals(best.getAreaName4(), other.getAreaName4())) {
            return false;
        }
        if (!this.stringEquals(best.getAreaName3(), other.getAreaName3())) {
            return false;
        }
        return best.getPlaceNameScore() == other.getPlaceNameScore();
    }

    private boolean stringEquals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equalsIgnoreCase(string2);
    }
}

