/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_CandidateRange;
import com.mapinfo.mapmarker.NZL.NZL_RangeUnit;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.utils.LongPoint;

public class NZL_Range
extends Range {
    private String m_meshBlockIdLeft;
    private String m_meshBlockIdRight;
    private LongPoint m_originalPoint;
    private int m_uniqueId;

    public NZL_Range() {
    }

    public NZL_Range(Range range) {
        super(range);
        this.m_uniqueId = ((NZL_RangeUnit)((Object)range.getRangeUnits().get(0))).getUniqueId();
    }

    public NZL_Range(String from, String to) {
        super(from, to);
    }

    public int getUniqueId() {
        return this.m_uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.m_uniqueId = uniqueId;
    }

    public void findMatchingRangeUnit(ParsedNumber unitNumber, String unitType) {
        int numRangeUnits = this.getRangeUnitCount();
        if (numRangeUnits <= 0) {
            return;
        }
        if (unitNumber == null) {
            return;
        }
        RangeUnit bestUnit = null;
        for (int i = 0; i < numRangeUnits; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            if (unit.isUnitInRange(unitNumber, this.getParsedRangeScore())) {
                if (unitType != null && this.hasUnitTypeMatched(unit.getUnitType(), unitType)) {
                    unit.setTypeMatched();
                }
                if (bestUnit == null) {
                    this.setMatchingRangeUnit(i);
                    bestUnit = unit;
                    continue;
                }
                if (bestUnit.getParsedRangeScore().isAddsSuffix() && !unit.getParsedRangeScore().isAddsSuffix()) {
                    bestUnit = unit;
                    this.setMatchingRangeUnit(i);
                    continue;
                }
                if (bestUnit.getParsedRangeScore().getAbsentStringForInputNumber() != null && unit.getParsedRangeScore().getAbsentStringForInputNumber() == null) {
                    bestUnit = unit;
                    this.setMatchingRangeUnit(i);
                    continue;
                }
                if (bestUnit.getParsedRangeScore().isAddsSuffix() != unit.getParsedRangeScore().isAddsSuffix()) continue;
                if (bestUnit.getNumberOfUnits() > unit.getNumberOfUnits()) {
                    bestUnit = unit;
                    this.setMatchingRangeUnit(i);
                    continue;
                }
                if (bestUnit.getTypeMatched() || !unit.getTypeMatched()) continue;
                bestUnit = unit;
                this.setMatchingRangeUnit(i);
                continue;
            }
            if (unitType == null || !this.hasUnitTypeMatched(unit.getUnitType(), unitType)) continue;
            unit.setTypeMatched();
        }
    }

    public void findClosestRangeUnit(ScoringAddress parsedInput) {
        ParsedNumber unitNumber = parsedInput.getParsedUnitValue();
        if (unitNumber == null || unitNumber.isEmpty()) {
            return;
        }
        int numRangeUnits = this.getRangeUnitCount();
        if (numRangeUnits == 0) {
            return;
        }
        long offset = Long.MAX_VALUE;
        for (int i = 0; i < numRangeUnits; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            long unitOffset = unit.computeOffsetFromRangeUnit(unitNumber, parsedInput, this.getParsedRangeScore());
            if (unitOffset < offset) {
                String unitType = parsedInput.getUnitType();
                if (unitType != null && this.hasUnitTypeMatched(unit.getUnitType(), unitType)) {
                    unit.setTypeMatched();
                }
                this.setClosestRangeUnit(i);
                offset = unitOffset;
                continue;
            }
            if (numRangeUnits != 1) continue;
            this.setClosestRangeUnit(i);
        }
    }

    private boolean hasUnitTypeMatched(String candUnitType, String parsedUnitType) {
        boolean hasMatched = false;
        if (candUnitType.equalsIgnoreCase(parsedUnitType)) {
            hasMatched = true;
        } else {
            String tempParsedUnitType;
            String tempCandUnitType = NZL_Abbreviations.expandAbbreviations(candUnitType) != null ? NZL_Abbreviations.expandAbbreviations(candUnitType) : candUnitType;
            String string = tempParsedUnitType = NZL_Abbreviations.expandAbbreviations(parsedUnitType) != null ? NZL_Abbreviations.expandAbbreviations(parsedUnitType) : parsedUnitType;
            if (tempCandUnitType.equalsIgnoreCase(tempParsedUnitType)) {
                hasMatched = true;
            } else {
                tempCandUnitType = NZL_Abbreviations.abbreviateWords(candUnitType) != null ? NZL_Abbreviations.abbreviateWords(candUnitType) : candUnitType;
                String string2 = tempParsedUnitType = NZL_Abbreviations.abbreviateWords(parsedUnitType) != null ? NZL_Abbreviations.abbreviateWords(parsedUnitType) : parsedUnitType;
                if (tempCandUnitType.equalsIgnoreCase(tempParsedUnitType)) {
                    hasMatched = true;
                }
            }
        }
        return hasMatched;
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber, IConstraints constraints) {
        CandidateRange candidateRange = super.toCandidateRange(inputHouseNumber, side, inputUnitNumber, constraints);
        NZL_CandidateRange candRange = new NZL_CandidateRange(candidateRange);
        if (constraints != null) {
            Address address = constraints.getHandler().getParsedAddress();
            if (candRange.getOffset() == 0L) {
                ParsedRangeScore rangeScore = this.getParsedRangeScore();
                if (inputHouseNumber.hasAddressSuffix() && this.getParsedFrom().hasAddressSuffix() && rangeScore.isSuffixMatched()) {
                    if (inputHouseNumber.hasAddressTrailer() && this.getParsedFrom().hasAddressTrailer() && rangeScore.isTrailerMatched()) {
                        candRange.setOffset(-2L);
                        if (address.getUnitValue() != null) {
                            this.sortOnRangeUnit(candRange, address);
                        } else {
                            candRange.setOffset(-2L);
                        }
                    } else if (address.getUnitValue() != null) {
                        this.sortOnRangeUnit(candRange, address);
                    } else {
                        candRange.setOffset(-1L);
                    }
                } else if (inputHouseNumber.isHyphenatedNumber() && rangeScore.getNumberFieldsMatched() > 1) {
                    candRange.setOffset(-1L);
                } else if (inputHouseNumber.hasAddressSuffix() && rangeScore.getAddedString() != null) {
                    candRange.setOffset(0L);
                } else if (!inputHouseNumber.hasAddressSuffix() && rangeScore.isAddsSuffix()) {
                    candRange.setOffset(0L);
                } else if (this.hasMatchingRangeUnit() || this.hasClosestRangeUnit()) {
                    this.sortOnRangeUnit(candRange, address);
                }
            } else {
                candRange.setOffset(this.computeOffsetDifference(inputHouseNumber));
            }
        }
        candRange.setMeshBlockIdLeft(this.getMeshBlockIdLeft());
        candRange.setMeshBlockIdRight(this.getMeshBlockIdRight());
        candRange.setOriginalPoint(this.getOriginalPoint());
        return candRange;
    }

    private void sortOnRangeUnit(NZL_CandidateRange candRange, Address address) {
        ParsedRangeScore parsedRangeScore;
        NZL_RangeUnit rangeUnit = null;
        if (this.hasMatchingRangeUnit()) {
            rangeUnit = (NZL_RangeUnit)this.getRangeUnitAt(this.getMatchingRangeUnit());
            if (rangeUnit != null) {
                ParsedRangeScore parsedRangeScore2 = rangeUnit.getParsedRangeScore();
                if (!parsedRangeScore2.isAddsSuffix() && parsedRangeScore2.getAddedString() == null && parsedRangeScore2.getAbsentStringForInputNumber() == null) {
                    if (address.getUnitType() != null) {
                        if (rangeUnit.getTypeMatched()) {
                            candRange.setOffset(-3L);
                        } else {
                            candRange.setOffset(-2L);
                        }
                    } else {
                        candRange.setOffset(-2L);
                    }
                } else {
                    candRange.setOffset(-1L);
                }
            }
        } else if (this.hasClosestRangeUnit() && (rangeUnit = (NZL_RangeUnit)this.getRangeUnitAt(this.getClosestRangeUnit())) != null && !(parsedRangeScore = rangeUnit.getParsedRangeScore()).isAddsSuffix() && parsedRangeScore.getAddedString() == null && parsedRangeScore.getAbsentStringForInputNumber() == null) {
            if (address.getUnitType() != null) {
                if (rangeUnit.getTypeMatched()) {
                    candRange.setOffset(-1L);
                }
            } else {
                candRange.setOffset(-1L);
            }
        }
    }

    private long computeOffsetDifference(ParsedNumber inputHouseNumber) {
        long inputNumber;
        long parsedFromNumber;
        long offset = 0L;
        if (this.getParsedFrom() != null && inputHouseNumber != null && (offset = (parsedFromNumber = this.getParsedFrom().getAddressNumber()) - (inputNumber = inputHouseNumber.getAddressNumber())) < 0L) {
            offset *= -1L;
        }
        return offset;
    }

    public String getMeshBlockIdLeft() {
        return this.m_meshBlockIdLeft;
    }

    public void setMeshBlockIdLeft(String meshBlockId) {
        this.m_meshBlockIdLeft = meshBlockId;
    }

    public String getMeshBlockIdRight() {
        return this.m_meshBlockIdRight;
    }

    public void setMeshBlockIdRight(String meshBlockId) {
        this.m_meshBlockIdRight = meshBlockId;
    }

    public void setOriginalPoint(LongPoint originalPoint) {
        this.m_originalPoint = originalPoint;
    }

    public LongPoint getOriginalPoint() {
        return this.m_originalPoint;
    }
}

