/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.NZL.parser.NZL_Directionals;
import com.mapinfo.mapmarker.NZL.parser.NZL_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StringScorer;
import java.util.Locale;

public class NZL_ScoringAddress
extends EMEA_ScoringAddress {
    private static ItemsCachedScore[] m_scoreCache;
    protected static StringScorer m_PlainScorer;
    private static final int MAX_SCORE_CACHE = 20;

    public NZL_ScoringAddress(Address addr) {
        super(addr);
    }

    @Override
    public double scoreItems(String str1, String str2) {
        return this.scoreItems(str1, str2, this.getStringScorer());
    }

    public double scorePreThoroughfareType(String str) {
        return this.scoreNZLThoroughfareType(this.getPreThoroughfareType(), str);
    }

    public double scorePostThoroughfareType(String str) {
        return this.scoreNZLThoroughfareType(this.getPostThoroughfareType(), str);
    }

    public double scorePreDirectional(String str) {
        return this.scoreNZLDirectional(this.getPreDirectional(), str);
    }

    public double scorePostDirectional(String str) {
        return this.scoreNZLDirectional(this.getPostDirectional(), str);
    }

    private double scoreNZLDirectional(String sourceDirStr, String targetDirStr) {
        NZL_Directionals.Directional dir1;
        NZL_Directionals.Directional dir0 = NZL_Directionals.getDirectional(sourceDirStr);
        if (dir0 == (dir1 = NZL_Directionals.getDirectional(targetDirStr))) {
            return 1.0;
        }
        if (dir0 != null && dir0.isRelative(dir1)) {
            return 0.5;
        }
        return 0.0;
    }

    private double scoreNZLThoroughfareType(String sourceTTStr, String targetTTStr) {
        NZL_ThoroughfareTypes.NZL_ThoroughfareType keyInfo1;
        NZL_ThoroughfareTypes.NZL_ThoroughfareType keyInfo0 = NZL_ThoroughfareTypes.getThoroughfareType(sourceTTStr);
        if (keyInfo0 == (keyInfo1 = NZL_ThoroughfareTypes.getThoroughfareType(targetTTStr))) {
            return 1.0;
        }
        if (keyInfo0 == null || keyInfo1 == null) {
            return 0.0;
        }
        if (keyInfo0.getProperTypeName().equalsIgnoreCase(keyInfo1.getProperTypeName())) {
            return 1.0;
        }
        return 0.0;
    }

    protected double scoreItems(String item1, String item2, String charsToIgnore, StringScorer scorer) {
        double score = 0.0;
        if (item1 != null && item2 != null) {
            ItemsCachedScore cachedScore = this.findCachedScore(item1, item2);
            if (cachedScore != null) {
                score = cachedScore.getScore();
            } else {
                score = scorer.scoreString(item1, item2, charsToIgnore);
                if (score < 1.0) {
                    String itemp1Temp = null;
                    String itemp2Temp = null;
                    double score1 = 0.0;
                    itemp1Temp = NZL_Abbreviations.expandAbbreviations(item1) != null ? NZL_Abbreviations.expandAbbreviations(item1) : item1;
                    String string = itemp2Temp = NZL_Abbreviations.expandAbbreviations(item2) != null ? NZL_Abbreviations.expandAbbreviations(item2) : item2;
                    if (!(itemp2Temp.equalsIgnoreCase(item2) && itemp1Temp.equalsIgnoreCase(item1) || !((score1 = scorer.scoreString(itemp1Temp, itemp2Temp, charsToIgnore)) > score))) {
                        score = score1;
                    }
                    if (score < 1.0) {
                        itemp1Temp = NZL_Abbreviations.abbreviateWords(item1) != null ? NZL_Abbreviations.abbreviateWords(item1) : item1;
                        String string2 = itemp2Temp = NZL_Abbreviations.abbreviateWords(item2) != null ? NZL_Abbreviations.abbreviateWords(item2) : item2;
                        if (!(itemp2Temp.equalsIgnoreCase(item2) && itemp1Temp.equalsIgnoreCase(item1) || !((score1 = scorer.scoreString(itemp1Temp, itemp2Temp, charsToIgnore)) > score))) {
                            score = score1;
                        }
                    }
                }
                this.addIntoScoreCache(item1, item2, score);
            }
        } else {
            score = scorer.scoreString(item1, item2, charsToIgnore);
        }
        return score;
    }

    private double scoreItems(String item1, String item2, StringScorer scorer) {
        return this.scoreItems(item1, item2, this.getCharsToIgnore(), scorer);
    }

    private ItemsCachedScore findCachedScore(String item1, String item2) {
        for (int i = 0; i < 20; ++i) {
            ItemsCachedScore cachedScore = m_scoreCache[i];
            if (cachedScore == null) {
                return null;
            }
            if (!cachedScore.equalItems(item1, item2)) continue;
            return cachedScore;
        }
        return null;
    }

    private void addIntoScoreCache(String item1, String item2, double score) {
        ItemsCachedScore cachedScore = new ItemsCachedScore(item1, item2, score);
        for (int i = 18; i >= 0; --i) {
            NZL_ScoringAddress.m_scoreCache[i + 1] = m_scoreCache[i];
        }
        NZL_ScoringAddress.m_scoreCache[0] = cachedScore;
    }

    private static String replaceHyphenWithSpace(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace('-', ' ');
        return str;
    }

    static {
        m_PlainScorer = new StringScorer(true, Locale.UK);
        m_scoreCache = new ItemsCachedScore[20];
    }

    class ItemsCachedScore {
        private double score;
        private String firstItem;
        private String secondItem;

        public ItemsCachedScore(String item1, String item2, double score) {
            this.firstItem = item1;
            this.secondItem = item2;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public boolean equalItems(String item1, String item2) {
            return item1 != null && item1.equals(this.firstItem) && item2 != null && item2.equals(this.secondItem);
        }
    }
}

