/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.NZL.parser.NZL_Ordinals;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class NZL_StreetCandidateAddress
extends StreetCandidateAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    public static final String POST_ADDR_COMMON = "post_addr_common";
    public static String EXPANDED_PREADDRESS = "expanded_preaddress";
    public static String EXPANDED_POSTADDRESS = "expanded_postaddress";
    private double m_preMainCommonScore = 0.0;
    private double m_preAddrCommonScore = 0.0;
    private double m_postAddrCommonScore = 0.0;

    public NZL_StreetCandidateAddress() {
    }

    public NZL_StreetCandidateAddress(Address addr) {
        super(addr);
        if (addr instanceof NZL_StreetCandidateAddress) {
            NZL_StreetCandidateAddress nldAddr = (NZL_StreetCandidateAddress)addr;
            this.setPreMainCommonScore(nldAddr.getPreMainCommonScore());
            this.setPreAddressCommonScore(nldAddr.getPreAddressCommonScore());
            this.setPostAddressCommonScore(nldAddr.getPostAddressCommonScore());
        }
    }

    public void setPreMainCommonScore(double score) {
        this.m_preMainCommonScore = score;
    }

    public double getPreMainCommonScore() {
        return this.m_preMainCommonScore;
    }

    public void setPreAddressCommonScore(double score) {
        this.m_preAddrCommonScore = score;
    }

    public double getPreAddressCommonScore() {
        return this.m_preAddrCommonScore;
    }

    public void setPostAddressCommonScore(double score) {
        this.m_postAddrCommonScore = score;
    }

    public double getPostAddressCommonScore() {
        return this.m_postAddrCommonScore;
    }

    public void score(ScoringAddress input) {
        if (input instanceof EMEA_ScoringAddress) {
            EMEA_ScoringAddress eInput = (EMEA_ScoringAddress)input;
            this.setCountryScore(input.scoreCountry(this.getCountry()));
            this.setGenericField1Score(input.scoreGenericField1(this.getGenericField1()));
            this.setGenericField2Score(input.scoreGenericField2(this.getGenericField2()));
            this.setGenericField3Score(input.scoreGenericField3(this.getGenericField3()));
            this.setGenericField4Score(input.scoreGenericField4(this.getGenericField4()));
            this.setPreThoroughfareTypeScore(input.scorePreThoroughfareType(this.getPreThoroughfareType()));
            this.setPreDirectionalScore(input.scorePreDirectional(this.getPreDirectional()));
            this.setPreAddressCommonScore(this.scorePreAddressCommon(eInput));
            this.setPreAddressScore(this.scorePreAddress(eInput));
            this.setPreMainCommonScore(this.scorePreMainCommon(eInput));
            this.setPostAddressCommonScore(this.scorePostAddressCommon(eInput));
            this.setMainAddressScore(input.scoreMainAddress(this.getMainAddress()));
            this.setPostThoroughfareTypeScore(input.scorePostThoroughfareType(this.getPostThoroughfareType()));
            this.setPostDirectionalScore(input.scorePostDirectional(this.getPostDirectional()));
            this.setPostAddressScore(this.scorePostAddress(eInput));
            this.setIsScored(true);
        } else {
            super.score(input);
        }
    }

    private double scorePreMainCommon(EMEA_ScoringAddress eInput) {
        String preCommon0 = (String)eInput.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        String preCommon1 = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        return eInput.scoreItems(preCommon0, preCommon1);
    }

    private double scorePostAddressCommon(EMEA_ScoringAddress eInput) {
        String postCommon0 = (String)eInput.getAdditionalFields().get(POST_ADDR_COMMON);
        String postCommon1 = (String)this.getAdditionalFields().get(POST_ADDR_COMMON);
        return eInput.scoreItems(postCommon0, postCommon1);
    }

    private double scorePreAddressCommon(EMEA_ScoringAddress eInput) {
        String preAddrCommon0 = (String)eInput.getAdditionalFields().get(PRE_ADDR_COMMON);
        String preAddrCommon1 = (String)this.getAdditionalFields().get(PRE_ADDR_COMMON);
        return eInput.scoreItems(preAddrCommon0, preAddrCommon1);
    }

    public double scorePreAddress(EMEA_ScoringAddress input) {
        StringTokenizer st;
        double bestscore = input.scoreItems(input.getPreAddress(), this.getPreAddress());
        if (bestscore < 1.0 && this.bothInitialLettersEqual(input.getPreAddress(), this.getPreAddress())) {
            HashMap addFields = input.getAdditionalFields();
            ArrayList parsedAbbrPreAddressList = null;
            if (addFields.containsKey(EXPANDED_PREADDRESS)) {
                parsedAbbrPreAddressList = (ArrayList)addFields.get(EXPANDED_PREADDRESS);
            }
            if (parsedAbbrPreAddressList == null && (parsedAbbrPreAddressList = NZL_Abbreviations.createAbbreviationAlternatives(input.getPreAddress())) != null) {
                addFields.put(EXPANDED_PREADDRESS, parsedAbbrPreAddressList);
            }
            ArrayList candAbbrPreAddressList = NZL_Abbreviations.createAbbreviationAlternatives(this.getPreAddress());
            double abbrScore = 0.0;
            for (int i = 0; abbrScore != 1.0 && candAbbrPreAddressList != null && i < candAbbrPreAddressList.size(); ++i) {
                String candTerm = ((StringBuffer)candAbbrPreAddressList.get(i)).toString();
                for (int k = 0; abbrScore != 1.0 && parsedAbbrPreAddressList != null && k < parsedAbbrPreAddressList.size(); ++k) {
                    String parsedTerm = ((StringBuffer)parsedAbbrPreAddressList.get(k)).toString();
                    double thisComparisonScore = input.scoreItems(parsedTerm, candTerm);
                    if (!(thisComparisonScore > abbrScore)) continue;
                    abbrScore = thisComparisonScore;
                }
            }
        }
        if (bestscore < 1.0) {
            String str1 = (String)input.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
            String str2 = this.getPreAddress();
            double score = 0.0;
            if (str1 != null && str2 != null) {
                score = input.scoreItems(str1, str2);
                if (bestscore < score) {
                    bestscore = score;
                }
                if (bestscore < 1.0 && input.getPreAddress() == null) {
                    score = 0.0;
                    st = new StringTokenizer(str1);
                    StringTokenizer st1 = new StringTokenizer(str2);
                    if (st1.hasMoreTokens()) {
                        str2 = st1.nextToken();
                    }
                    int tokens = 0;
                    while (st.hasMoreTokens()) {
                        str1 = st.nextToken();
                        ++tokens;
                        if (str1.charAt(0) != str2.charAt(0)) continue;
                        if (str1.length() == 1) {
                            if (!st1.hasMoreTokens()) break;
                            str2 = st1.nextToken();
                            continue;
                        }
                        if (!str1.endsWith(".")) continue;
                        if (str1.length() == 2 && str1.charAt(0) == str2.charAt(0)) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) continue;
                            str2 = st1.nextToken();
                            continue;
                        }
                        score += 0.5 * input.scoreItems(str1, str2);
                        if (!st1.hasMoreTokens()) continue;
                        str2 = st1.nextToken();
                    }
                    if (tokens > 0) {
                        score /= (double)tokens;
                    }
                }
                if (bestscore < score && score > 0.8) {
                    bestscore = score;
                }
            }
        }
        if (bestscore < 1.0) {
            double score = 0.0;
            String str1 = input.getPreAddress();
            String str2 = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
            if (str1 != null && str2 != null) {
                score = input.scoreItems(str1, str2);
                if (bestscore < score) {
                    bestscore = score;
                }
                if (bestscore < 1.0 && this.getPreAddress() == null) {
                    score = 0.0;
                    st = new StringTokenizer(str1);
                    StringTokenizer st1 = new StringTokenizer(str2);
                    if (st1.hasMoreTokens()) {
                        str2 = st1.nextToken();
                    }
                    int tokens = 0;
                    score = 0.0;
                    while (st.hasMoreTokens()) {
                        str1 = st.nextToken();
                        ++tokens;
                        if (str1.charAt(0) != str2.charAt(0)) continue;
                        if (str1.length() == 1) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) break;
                            str2 = st.nextToken();
                            continue;
                        }
                        if (!str1.endsWith(".")) continue;
                        if (str1.length() == 2 && str1.charAt(0) == str2.charAt(0)) {
                            score += 1.0;
                            if (!st1.hasMoreTokens()) break;
                            str2 = st1.nextToken();
                            continue;
                        }
                        score += 0.5 * input.scoreItems(str1, str2);
                        if (!st1.hasMoreTokens()) continue;
                        str2 = st1.nextToken();
                    }
                    if (tokens > 0) {
                        score /= (double)tokens;
                    }
                }
            }
            if (bestscore < score && score > 0.8) {
                bestscore = score;
            }
        }
        if (bestscore < 1.0) {
            double thisComparisonScore;
            String parsedTerm;
            int k;
            int i;
            String parsedTemp = (String)input.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
            String candTemp = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
            ArrayList parsedPreMainCommonList = NZL_Ordinals.createAbbreviationAlternatives(parsedTemp);
            ArrayList parsedPreAddressList = NZL_Ordinals.createAbbreviationAlternatives(input.getPreAddress());
            ArrayList candPreAddressList = NZL_Ordinals.createAbbreviationAlternatives(this.getPreAddress());
            ArrayList candPreMainCommonList = NZL_Ordinals.createAbbreviationAlternatives(candTemp);
            double abbrScore = 0.0;
            for (i = 0; abbrScore != 1.0 && candPreAddressList != null && i < candPreAddressList.size(); ++i) {
                String candTerm = ((StringBuffer)candPreAddressList.get(i)).toString();
                for (k = 0; abbrScore != 1.0 && parsedPreMainCommonList != null && k < parsedPreMainCommonList.size(); ++k) {
                    parsedTerm = ((StringBuffer)parsedPreMainCommonList.get(k)).toString();
                    thisComparisonScore = input.scoreItems(parsedTerm, candTerm);
                    if (!(thisComparisonScore > abbrScore)) continue;
                    abbrScore = thisComparisonScore;
                }
            }
            for (i = 0; abbrScore != 1.0 && parsedPreAddressList != null && i < parsedPreAddressList.size(); ++i) {
                String candTerm = ((StringBuffer)parsedPreAddressList.get(i)).toString();
                for (k = 0; abbrScore != 1.0 && candPreMainCommonList != null && k < candPreMainCommonList.size(); ++k) {
                    parsedTerm = ((StringBuffer)candPreMainCommonList.get(k)).toString();
                    thisComparisonScore = input.scoreItems(parsedTerm, candTerm);
                    if (!(thisComparisonScore > abbrScore)) continue;
                    abbrScore = thisComparisonScore;
                }
            }
            if (abbrScore > bestscore && abbrScore > 0.8) {
                bestscore = abbrScore;
            }
        }
        return bestscore;
    }

    public double scorePostAddress(EMEA_ScoringAddress input) {
        double postscore;
        double score = 0.0;
        score = input.scoreItems(input.getPostAddress(), this.getPostAddress());
        if (score != 1.0 && input.getPostAddress() != null && (postscore = input.scoreItems(input.getPostAddress(), this.getPreAddress())) > score) {
            score = postscore;
        }
        if (score != 1.0 && this.bothInitialLettersEqual(input.getPostAddress(), this.getPostAddress())) {
            HashMap<String, ArrayList> addFields = input.getAdditionalFields();
            ArrayList parsedAbbrPostAddressList = null;
            if (addFields != null) {
                if (addFields.containsKey(EXPANDED_POSTADDRESS)) {
                    parsedAbbrPostAddressList = (ArrayList)addFields.get(EXPANDED_POSTADDRESS);
                }
            } else {
                addFields = new HashMap<String, ArrayList>();
            }
            if (parsedAbbrPostAddressList == null && (parsedAbbrPostAddressList = NZL_Abbreviations.createAbbreviationAlternatives(input.getPostAddress())) != null) {
                addFields.put(EXPANDED_POSTADDRESS, parsedAbbrPostAddressList);
            }
            ArrayList candAbbrPostAddressList = NZL_Abbreviations.createAbbreviationAlternatives(this.getPostAddress());
            double abbrScore = 0.0;
            for (int i = 0; abbrScore != 1.0 && candAbbrPostAddressList != null && i < candAbbrPostAddressList.size(); ++i) {
                String candTerm = ((StringBuffer)candAbbrPostAddressList.get(i)).toString();
                for (int k = 0; abbrScore != 1.0 && parsedAbbrPostAddressList != null && k < parsedAbbrPostAddressList.size(); ++k) {
                    String parsedTerm = ((StringBuffer)parsedAbbrPostAddressList.get(k)).toString();
                    double thisComparisonScore = input.scoreItems(parsedTerm, candTerm);
                    if (!(thisComparisonScore > abbrScore)) continue;
                    abbrScore = thisComparisonScore;
                }
            }
            if (abbrScore > score) {
                score = abbrScore;
            }
        }
        return score;
    }

    private boolean bothInitialLettersEqual(String string1, String string2) {
        boolean isLetterEqual = false;
        if (string1 == null || string1.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            isLetterEqual = false;
        } else if (string1.charAt(0) == string2.charAt(0)) {
            isLetterEqual = true;
        }
        return isLetterEqual;
    }
}

