/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.NZL.NZL_Address;
import com.mapinfo.mapmarker.common.Address;

public final class NZL_UserCandidateAddress
extends CandidateAddress
implements NZL_Address {
    public NZL_UserCandidateAddress() {
        this.setCountry("NZL");
    }

    public NZL_UserCandidateAddress(Address address) {
        super(address);
        this.setCountry("NZL");
    }

    NZL_UserCandidateAddress(String housenumber, String street, String city, String postcode, String postaddress, String placeName) {
        this.setCountry("NZL");
        this.setPostAddress(postaddress);
        this.setHouseNumber(housenumber);
        this.setCity(city);
        this.setPostcode(postcode);
        this.setStreet(street);
        this.setPlaceName(placeName);
    }

    @Override
    public String getPostAddress() {
        return super.getPostAddress();
    }

    public String getPreAddress() {
        return super.getPreAddress();
    }

    @Override
    public String getHouseNumber() {
        return super.getAddressNumber();
    }

    @Override
    public String getCity() {
        return this.getAreaName3();
    }

    @Override
    public String getPostcode() {
        return this.getPostCode1();
    }

    @Override
    public String getStreet() {
        if (this.getLocationPrecision() == 6) {
            return this.getMainAddress();
        }
        String formattedStreetAddress = this.getFormattedStreetAddress();
        String addNumber = this.getAddressNumber();
        String unitType = this.getUnitType();
        String unitValue = this.getUnitValue();
        String outputStreet = null;
        if (addNumber != null) {
            int hnrIndex;
            if (unitValue != null && !unitValue.equalsIgnoreCase("0")) {
                addNumber = unitValue + " " + addNumber;
                if (unitType != null) {
                    addNumber = unitType + " " + addNumber;
                }
            }
            if ((hnrIndex = formattedStreetAddress.indexOf(addNumber)) > -1) {
                formattedStreetAddress = formattedStreetAddress.substring(addNumber.length() + 1, formattedStreetAddress.length());
                return formattedStreetAddress;
            }
        } else if (unitValue != null && !unitValue.equalsIgnoreCase("0")) {
            int unitIndex;
            outputStreet = unitValue;
            if (unitType != null) {
                outputStreet = unitType + " " + outputStreet;
            }
            if ((unitIndex = formattedStreetAddress.indexOf(outputStreet)) > -1) {
                formattedStreetAddress = formattedStreetAddress.substring(outputStreet.length() + 1, formattedStreetAddress.length());
                return formattedStreetAddress;
            }
        }
        return formattedStreetAddress;
    }

    @Override
    public String getSuburb() {
        return this.getAreaName4();
    }

    @Override
    public String getRegion() {
        return this.getAreaName1();
    }

    @Override
    public String getPlaceName() {
        return super.getPlaceName();
    }

    public boolean doesHnrMatch() {
        return this.doesAddressNumberMatch();
    }

    public boolean doesPostcodeMatch() {
        return this.doesPostalCode1Match();
    }

    public boolean doesStreetMatch() {
        return this.doesStreetNameMatch();
    }

    public boolean doesTownMatch() {
        return this.doesAreaName3Match();
    }

    public String getMeshBlock() {
        return (String)this.getAdditionalFields().get("NZL_MESHBLOCK_ID");
    }

    public String getUniqueIdentifier() {
        return (String)this.getAdditionalFields().get("KEY_UFI");
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer returnString = new StringBuffer(256);
        returnString.append(lineSeparator);
        String tmp = this.getPlaceName();
        if (tmp != null) {
            returnString.append("Place:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if (this.getPreThoroughfareType() != null) {
            returnString.append("preThoroughfareType:\t\t");
            returnString.append(this.getPreThoroughfareType());
            returnString.append(lineSeparator);
        }
        if (this.getPreDirectional() != null) {
            returnString.append("preDirectional:\t\t\t");
            returnString.append(this.getPreDirectional());
            returnString.append(lineSeparator);
        }
        if (this.getAddressNumber() != null) {
            returnString.append("addressNumber:\t\t\t");
            returnString.append(this.getAddressNumber());
            returnString.append(lineSeparator);
        }
        if (this.getPreAddress() != null) {
            returnString.append("preAddress:\t\t\t");
            returnString.append(this.getPreAddress());
            returnString.append(lineSeparator);
        }
        returnString.append("Street:\t\t\t");
        returnString.append(this.getMainAddress());
        returnString.append(lineSeparator);
        if (this.getPostAddress() != null) {
            returnString.append("postAddress:\t\t\t");
            returnString.append(this.getPostAddress());
            returnString.append(lineSeparator);
        }
        if (this.getPostThoroughfareType() != null) {
            returnString.append("postThoroughfareType:\t\t");
            returnString.append(this.getPostThoroughfareType());
            returnString.append(lineSeparator);
        }
        if (this.getPostDirectional() != null) {
            returnString.append("postDirectional:\t\t\t");
            returnString.append(this.getPostDirectional());
            returnString.append(lineSeparator);
        }
        if ((tmp = this.getSuburb()) != null) {
            returnString.append("Suburb:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if ((tmp = this.getCity()) != null) {
            returnString.append("City:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if ((tmp = this.getRegion()) != null) {
            returnString.append("Region:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if ((tmp = this.getPostcode()) != null) {
            returnString.append("Postcode:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if ((tmp = this.getCountry()) != null) {
            returnString.append("Country:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if (this.hasAdditionalFields() && (tmp = this.getMeshBlock()) != null) {
            returnString.append("MeshBlock:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        if (this.hasAdditionalFields() && (tmp = this.getUniqueIdentifier()) != null) {
            returnString.append("UniqueIdentifier:\t\t\t");
            returnString.append(tmp);
            returnString.append(lineSeparator);
        }
        returnString.append(lineSeparator);
        returnString.append("formattedStreetAddress: ");
        returnString.append(this.getFormattedStreetAddress());
        returnString.append(lineSeparator);
        returnString.append("lastLine: ");
        returnString.append(this.getFormattedLocationAddress());
        returnString.append(lineSeparator);
        returnString.append("closeMatch: ");
        returnString.append(this.isCloseMatch());
        returnString.append(lineSeparator);
        returnString.append("sourceStreetID: ");
        returnString.append(this.getSourceStreetID());
        returnString.append(lineSeparator);
        returnString.append("addressNumberMatched: ");
        returnString.append(this.doesAddressNumberMatch());
        returnString.append(lineSeparator);
        returnString.append("streetMatched: ");
        returnString.append(this.doesStreetMatch());
        returnString.append(lineSeparator);
        returnString.append("location: ");
        returnString.append(this.getLocation().toString());
        returnString.append(lineSeparator);
        returnString.append("locationPrecision: ");
        returnString.append(this.getLocationPrecision());
        returnString.append(lineSeparator);
        returnString.append("coordSysString: ");
        returnString.append(this.getCoordSysString());
        returnString.append(lineSeparator);
        returnString.append(lineSeparator);
        returnString.append("This candidate has ");
        returnString.append(this.getNumberOfCandidateRanges());
        returnString.append(" CandidateRange(s).");
        returnString.append(lineSeparator);
        return returnString.toString();
    }

    @Override
    public void setCity(String city) {
    }

    @Override
    public void setStreet(String street) {
    }

    @Override
    public void setPostcode(String postcode) {
    }

    @Override
    public void setHouseNumber(String housenumber) {
    }

    @Override
    public void setRegion(String region) {
    }
}

