/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp;

import com.mapinfo.mapmarker.EMEA.dp.EMEA_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.util.Properties;

public class NZL_GeoInfoDataSourceRecordConvertorImpl
extends EMEA_GeoInfoDataSourceRecordConvertorImpl {
    public NZL_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    @Override
    public MMJGeoInfoRecord convert(IDataSourceRecord inputData, EMEA_GeoInfoRecord baseRecord) throws DataCreationException {
        String region = null;
        String city = null;
        String suburb = null;
        String suburbAlias = null;
        int suburbId = 0;
        String additionalCity = null;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return (MMJGeoInfoRecord)this.getNextDataRecord();
            }
            return null;
        }
        IGeoInfoDataSourceRecord input = (IGeoInfoDataSourceRecord)inputData;
        try {
            if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
                suburb = input.getAreaName4();
            }
            if (input.hasAlternateAreaName4() && this.stringExists(input.getAlternateAreaName4())) {
                suburbAlias = input.getAlternateAreaName4();
            }
            if (input.hasAlternateAreaName1() && this.stringExists(input.getAlternateAreaName1())) {
                suburbId = Integer.parseInt(input.getAlternateAreaName1());
            }
            if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
                city = input.getAreaName3();
            }
            if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
                additionalCity = input.getAlternateAreaName3();
            }
            if (suburb != null && additionalCity != null && suburb.equalsIgnoreCase(additionalCity)) {
                additionalCity = null;
            }
            if (input.hasAreaName1() && this.stringExists(input.getAreaName1())) {
                region = input.getAreaName1();
            }
            if (suburb != null) {
                if (region != null && region.trim().length() > 0) {
                    baseRecord.setAreaName1(region.trim());
                }
                baseRecord.setAreaName4(suburb.trim());
                if (suburbAlias != null) {
                    baseRecord.setAltAreaName4(suburbAlias.trim());
                }
                if (city != null && city.trim().length() > 0) {
                    baseRecord.setAreaName3(city.trim());
                }
                if (additionalCity != null && additionalCity.trim().length() > 0) {
                    baseRecord.setAliasedLocality(additionalCity);
                }
                if (input.hasCentroid()) {
                    baseRecord.setPoint(input.getCentroid());
                    if (this.isAliasRecord(suburbId, city, suburbAlias, input)) {
                        baseRecord.setPrecision((byte)0);
                    } else {
                        baseRecord.setPrecision((byte)11);
                    }
                }
                MiStringIndexKey key = null;
                String combinedKey2 = baseRecord.getAreaName4() == null ? "" : baseRecord.getAreaName4();
                combinedKey2 = combinedKey2 + (baseRecord.getAreaName3() == null ? "" : baseRecord.getAreaName3());
                combinedKey2 = combinedKey2 + (baseRecord.getAreaName1() == null ? "" : baseRecord.getAreaName1());
                key = new MiStringIndexKey(this.getGeoInfoAliasKey(combinedKey2.toUpperCase()));
                return new MMJGeoInfoRecord((GeoInfoRecord)baseRecord, (MapMarkerIndexKey)key);
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(301, (Throwable)DSEx);
        }
        return null;
    }

    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        EMEA_GeoInfoRecord baseRecord;
        String fullAreaName4;
        String areaName4Short;
        MMJGeoInfoRecord record = this.convert(inputData, new EMEA_GeoInfoRecord());
        if (record != null && (areaName4Short = NZL_ParsePostAddressRule.removeCommonWords(fullAreaName4 = (baseRecord = (EMEA_GeoInfoRecord)record.getRecord()).getAreaName4())) != null && !areaName4Short.equalsIgnoreCase(fullAreaName4)) {
            baseRecord.setAreaName4Short(areaName4Short);
        }
        return record;
    }

    public boolean isAliasRecord(int suburbID, String town, String suburbAlias, IGeoInfoDataSourceRecord inputRecord) throws DataSourceException {
        return suburbID == 0 && town == null && suburbAlias != null || inputRecord.getCentroid() != null && inputRecord.getCentroid().getX() == 0.0 && inputRecord.getCentroid().getY() == 0.0;
    }
}

