/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_AddressFetcher;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_InternalCandidateAddress;
import com.mapinfo.mapmarker.NZL.NZL_Range;
import com.mapinfo.mapmarker.NZL.NZL_RangeUnit;
import com.mapinfo.mapmarker.NZL.NZL_StreetCandidateAddress;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_Segment;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Properties;

public class NZL_AddressFetcher
extends EMEA_AddressFetcher {
    static NumberFormat postalFormatter = NumberFormat.getInstance();

    public NZL_AddressFetcher(Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
        postalFormatter.setMinimumIntegerDigits(4);
        postalFormatter.setMaximumIntegerDigits(4);
        postalFormatter.setGroupingUsed(false);
    }

    @Override
    public NumberFormat getPostalFormatter() {
        return postalFormatter;
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        this.privatePopulateCandidateFromData(cand, street, streetOffset, metadata);
    }

    private void privatePopulateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        HashMap adFields = cand.getAdditionalFields();
        GenericStreet genericStreet = (GenericStreet)street;
        this.fillAdditionalFields(adFields, genericStreet, 34, "address.common.pre.main");
        this.fillAdditionalFields(adFields, genericStreet, 37, "pre_addr_common");
        this.fillAdditionalFields(adFields, genericStreet, 38, "post_addr_common");
        this.fillAdditionalFields(adFields, genericStreet, 42, "PRE_DIRECTIONAL_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 40, "POST_TT_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 41, "PRE_TT_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 39, "POST_MAIN_SEPARATOR");
        this.fillAdditionalFields(adFields, genericStreet, 32, "address.start");
        this.fillAdditionalFields(adFields, genericStreet, 33, "address.end");
        this.fillAdditionalFields(adFields, genericStreet, 35, "address.common.post.st_type");
        this.fillAdditionalFields(adFields, genericStreet, 36, "is.major.road");
    }

    private void fillAdditionalFields(HashMap fields, GenericStreet genericStreet, int intKey, String strKey) throws LocalizationException {
        if (genericStreet.hasString(intKey)) {
            String value = GenericDataItemAccessor.getDataString((int)intKey, (GenericDataItem)genericStreet);
            fields.put(strKey, value);
        }
    }

    public InternalCandidateAddress makeInternalCandidateAddress() {
        return new NZL_InternalCandidateAddress();
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new NZL_InternalCandidateAddress((Address)street);
    }

    @Override
    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        super.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        NZL_Segment nzlsegment = (NZL_Segment)segment;
        if (nzlsegment.getLeftPostCode1() == null) {
            nzlsegment.setLeftPostCode1("");
            nzlsegment.setRightPostCode1("");
        }
        if (this.doesMeshBlockFieldExist(nzlsegment, genericSegment, 43)) {
            nzlsegment.setMeshBlockIdLeft(GenericDataItemAccessor.getDataString((int)43, (GenericDataItem)genericSegment));
            nzlsegment.setMeshBlockIdRight(GenericDataItemAccessor.getDataString((int)43, (GenericDataItem)genericSegment));
        } else {
            if (this.doesMeshBlockFieldExist(segment, genericSegment, 44)) {
                ((NZL_Segment)segment).setMeshBlockIdLeft(GenericDataItemAccessor.getDataString((int)44, (GenericDataItem)genericSegment));
            }
            if (this.doesMeshBlockFieldExist(segment, genericSegment, 45)) {
                ((NZL_Segment)segment).setMeshBlockIdRight(GenericDataItemAccessor.getDataString((int)45, (GenericDataItem)genericSegment));
            }
        }
        if (this.doesUniqueIdFieldExist(nzlsegment, genericSegment, 46)) {
            nzlsegment.setUniqueId(GenericDataItemAccessor.getDataInt((int)46, (GenericDataItem)genericSegment));
        }
    }

    protected Segment makeSegment() {
        return new NZL_Segment();
    }

    private boolean doesMeshBlockFieldExist(Segment segment, GenericSegment genericSegment, int maskId) {
        return genericSegment.hasString(maskId) && segment instanceof NZL_Segment;
    }

    private boolean doesMeshBlockFieldExist(Range range, GenericRange genericRange, int maskId) {
        return genericRange.hasString(maskId) && range instanceof NZL_Range;
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new NZL_StreetCandidateAddress();
    }

    protected RangeUnit makeRangeUnit() {
        return new NZL_RangeUnit();
    }

    protected void populateRangeUnitFromData(RangeUnit unit, GenericUnit genericUnit, MMJDataFileMetadata metadata, IDataDictionary dict, RangeUnit lastUnit) throws LocalizationException, IOException {
        super.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastUnit);
        NZL_RangeUnit nzlRangeUnit = (NZL_RangeUnit)unit;
        if (this.doesUniqueIdFieldExist(nzlRangeUnit, genericUnit, 49)) {
            nzlRangeUnit.setUniqueId(GenericDataItemAccessor.getDataInt((int)49, (GenericDataItem)genericUnit));
        }
    }

    private boolean doesUniqueIdFieldExist(RangeUnit rangeUnit, GenericUnit genericUnit, int maskId) {
        return genericUnit.hasInteger(maskId) && rangeUnit instanceof NZL_RangeUnit;
    }

    private boolean doesUniqueIdFieldExist(Segment segment, GenericSegment genericSegment, int maskId) {
        return genericSegment.hasInteger(maskId) && segment instanceof NZL_Segment;
    }

    protected Range makeRange() {
        return new NZL_Range();
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        super.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
        NZL_Range nzlRange = (NZL_Range)range;
        if (genericRange.hasLong(47) && genericRange.hasLong(48)) {
            nzlRange.setOriginalPoint(new LongPoint(GenericDataItemAccessor.getDataLong((int)47, (GenericDataItem)genericRange), GenericDataItemAccessor.getDataLong((int)48, (GenericDataItem)genericRange)));
        }
        if (this.doesMeshBlockFieldExist(range, genericRange, 50)) {
            nzlRange.setMeshBlockIdLeft(GenericDataItemAccessor.getDataString((int)50, (GenericDataItem)genericRange));
            nzlRange.setMeshBlockIdRight(GenericDataItemAccessor.getDataString((int)50, (GenericDataItem)genericRange));
        } else {
            if (this.doesMeshBlockFieldExist(range, genericRange, 51)) {
                nzlRange.setMeshBlockIdLeft(GenericDataItemAccessor.getDataString((int)51, (GenericDataItem)genericRange));
            }
            if (this.doesMeshBlockFieldExist(range, genericRange, 52)) {
                nzlRange.setMeshBlockIdRight(GenericDataItemAccessor.getDataString((int)52, (GenericDataItem)genericRange));
            }
        }
    }
}

