/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.NZL.NZL_InternalGeographicCandidate;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class NZL_GeoInfoFetcherImpl
extends EMEA_GeoInfoFetcherImpl {
    protected Soundex m_soundex = NZLEnglishSoundex.getInstance();

    public NZL_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new NZL_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new EMEA_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        ISoundexKey area4shortCalcKey;
        String area4shortCalc;
        ISoundexKey area4Key;
        String areaName4;
        ArrayList<MiSoundexIndexKey> list = new ArrayList<MiSoundexIndexKey>();
        String areaName3 = addr.getAreaName3();
        if (areaName3 != null) {
            ISoundexKey area3shortCalcKey;
            String area3shortCalc;
            ISoundexKey firstArea3Key;
            String firstAreaName3;
            ISoundexKey area3Key = this.m_soundex.getSoundex(areaName3);
            if (area3Key != null) {
                MiSoundexIndexKey key = new MiSoundexIndexKey((MiSoundexKey)area3Key);
                list.add(key);
            }
            if ((firstAreaName3 = this.getFirstName(areaName3)) != null && (firstArea3Key = this.m_soundex.getSoundex(firstAreaName3)) != null) {
                MiSoundexIndexKey firstKey = new MiSoundexIndexKey((MiSoundexKey)firstArea3Key);
                list.add(firstKey);
            }
            if ((area3shortCalc = NZL_ParsePostAddressRule.removeCommonWords(areaName3)) != null && !area3shortCalc.equalsIgnoreCase(areaName3) && (area3shortCalcKey = this.m_soundex.getSoundex(area3shortCalc)) != null) {
                MiSoundexIndexKey shortKey = new MiSoundexIndexKey((MiSoundexKey)area3shortCalcKey);
                list.add(shortKey);
            }
        }
        if ((areaName4 = addr.getAreaName4()) != null && (area4Key = this.m_soundex.getSoundex(areaName4)) != null) {
            MiSoundexIndexKey key = new MiSoundexIndexKey((MiSoundexKey)area4Key);
            list.add(key);
        }
        if ((area4shortCalc = NZL_ParsePostAddressRule.removeCommonWords(areaName4)) != null && !area4shortCalc.equalsIgnoreCase(areaName4) && (area4shortCalcKey = this.m_soundex.getSoundex(area4shortCalc)) != null) {
            MiSoundexIndexKey shortKey = new MiSoundexIndexKey((MiSoundexKey)area4shortCalcKey);
            list.add(shortKey);
        }
        this.removeDupedSoundexKey(list);
        MapMarkerIndexKey[] retvals = new MapMarkerIndexKey[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retvals[i] = (MapMarkerIndexKey)list.get(i);
        }
        return retvals;
    }

    protected String getAltLangName(String town) {
        MiStringIndexKey stringIndexKey = new MiStringIndexKey(town);
        MapMarkerIndexSingleValue indexValue = null;
        try {
            indexValue = (MapMarkerIndexSingleValue)this.m_geoInfoStringIndex.search((MapMarkerIndexKey)stringIndexKey);
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (indexValue == null) {
            return null;
        }
        long offset = indexValue.getOffset();
        EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)this.getGeoInfoRecord(offset);
        String altLangName = record.getAltLanguageNames();
        return altLangName;
    }

    public ArrayList getAltLangNames(String town) {
        ArrayList<String> altLangNames = new ArrayList<String>();
        String altLangName = null;
        for (int i = 0; i == 0 || altLangName != null; ++i) {
            String toFind = i + town;
            altLangName = this.getAltLangName(toFind);
            if (altLangName == null) continue;
            String[] tokens = altLangName.split("/");
            for (int index = 0; index < tokens.length; ++index) {
                String token = tokens[index].trim();
                String shortTown = NZL_ParsePostAddressRule.removeCommonWords(token);
                if (altLangNames.contains(shortTown)) continue;
                altLangNames.add(shortTown);
            }
        }
        return altLangNames;
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new NZL_InternalGeographicCandidate();
    }

    @Override
    protected void removeDupedSoundexKey(ArrayList list) {
        if (list.size() < 2) {
            return;
        }
        TreeSet set = new TreeSet();
        set.addAll(list);
        if (list.size() != set.size()) {
            list.clear();
            list.addAll(set);
        }
    }
}

