/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.postgresql.EMEA_PostgreSQLGeo2SacDataHandler;
import com.mapinfo.mapmarker.EMEA.dp.postgresql.EMEA_PostgreSQLGeoInfoDataHandler;
import com.mapinfo.mapmarker.EMEA.dp.postgresql.EMEA_PostgreSQLPost2SacDataHandler;
import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.NZL.NZL_Constraints;
import com.mapinfo.mapmarker.NZL.NZL_ScoringHelper;
import com.mapinfo.mapmarker.NZL.dp.NZL_DataConstructionParser;
import com.mapinfo.mapmarker.NZL.dp.NZL_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.NZL.dp.NZL_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.NZL.dp.NZL_PostgreStreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_StreetBuilder;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_TabDataProvider;
import com.mapinfo.mapmarker.NZL.dp.intermediate.NZL_IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.NZL.dp.postgresql.NZL_PostgreSQLStreetDataHandler;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.postgresql.PostgreSQLDataSource;
import com.mapinfo.mapmarker.common.dp.postgresql.PostgreSQLPostInfoDataHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;

public class NZL_PostgreSQLDataProvider
extends NZL_TabDataProvider {
    @Override
    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        NZL_Constraints constraints = new NZL_Constraints();
        this.m_dataBuilder = new NZL_StreetBuilder();
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        String geo2sac_operation = processingProperties.getProperty("geo2sac_flag");
        if (geo2sac_operation != null) {
            this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new NZL_Geo2SacDataSourceRecordConvertorImpl(processingProperties, new NZLEnglishSoundex()), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        }
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new NZL_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        constraints.setDataConstructionConstraint(true);
        String processStreets = (String)processingProperties.get("street_create");
        if (processStreets != null && processStreets.equals("YES")) {
            NZL_PostgreStreetDataSourceRecordConvertorImpl streetRecordConvertor = new NZL_PostgreStreetDataSourceRecordConvertorImpl(NZLEnglishSoundex.getInstance(), processingProperties, new CollationKeyGenerator(new Locale("en", "NZ"), NZL_ScoringHelper.getCollationRules()), new NZL_DataConstructionParser(), constraints);
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetRecordConvertor, (IIntermediateDataHandler)new NZL_IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp")), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new NZL_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
    }

    protected IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor convertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        return new EMEA_PostgreSQLPost2SacDataHandler((IDataSource)new PostgreSQLDataSource(this.m_processProperties), convertor, intermediateHandler, tempHandler);
    }

    protected IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor convertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        return new EMEA_PostgreSQLGeo2SacDataHandler((IDataSource)new PostgreSQLDataSource(this.m_processProperties), convertor, intermediateHandler, tempHandler);
    }

    protected IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor convertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        return new PostgreSQLPostInfoDataHandler((IDataSource)new PostgreSQLDataSource(this.m_processProperties), convertor, intermediateHandler, tempHandler);
    }

    protected IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor convertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler) {
        return new EMEA_PostgreSQLGeoInfoDataHandler((IDataSource)new PostgreSQLDataSource(this.m_processProperties), convertor, intermediateHandler, tempHandler);
    }

    protected IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor convertor, IIntermediateDataHandler intermediateHandler, ITempDataRecordHandler tempHandler, MMJStreetRecordComparator streetComparator, MMJSegmentComparer segmentComparer) throws DataCreationException {
        return new NZL_PostgreSQLStreetDataHandler((IDataSource)new PostgreSQLDataSource(this.m_processProperties), convertor, intermediateHandler, streetComparator, segmentComparer, tempHandler);
    }
}

