/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.NZL.NZL_AddressUtils;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJSegmentRecord;
import com.mapinfo.mapmarker.NZL.parser.NZL_AddressTerm;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class NZL_StreetBuilder
extends EMEA_StreetBuilder {
    public IDataFileDataItem buildStreetFromRecord(MultiSegmentStreet record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericStreet street = (GenericStreet)super.buildStreetFromRecord(record, metadata);
        Address address = record.getAddress();
        try {
            String town = address.getAreaName4();
            if (town != null && town.length() != 0) {
                street.putString(16, town);
            }
            if (address.hasAdditionalFields()) {
                HashMap fields = address.getAdditionalFields();
                this.putStringToStreet(street, 32, fields, "address.start");
                this.putStringToStreet(street, 33, fields, "address.end");
                this.putStringToStreet(street, 34, fields, "address.common.pre.main");
                this.putStringToStreet(street, 35, fields, "address.common.post.st_type");
                this.putStringToStreet(street, 36, fields, "is.major.road");
                this.putStringToStreet(street, 37, fields, "pre_addr_common");
                this.putStringToStreet(street, 38, fields, "post_addr_common");
                this.putStringToStreet(street, 39, fields, "POST_MAIN_SEPARATOR");
                this.putStringToStreet(street, 40, fields, "POST_TT_SEPARATOR");
                this.putStringToStreet(street, 41, fields, "PRE_TT_SEPARATOR");
                this.putStringToStreet(street, 42, fields, "PRE_DIRECTIONAL_SEPARATOR");
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            System.err.println("Unable to add to the street.");
            System.err.println("Attempting to add: " + address.toString());
            System.err.println(MMJETASEEx.getMessage());
            MMJETASEEx.printStackTrace(System.err);
            System.exit(1);
        }
        return street;
    }

    private void putStringToStreet(GenericStreet street, int intKey, HashMap fields, String strKey) throws MMJETypeArraySizeExceededException {
        String value = (String)fields.get(strKey);
        String string = value = value == null ? null : value.trim();
        if (value != null && value.length() > 0) {
            street.putString(intKey, value);
        }
    }

    @Override
    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)this.getSegmentDataObject();
        try {
            int postVal;
            String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
            String rightPostalCode1 = segmentRecord.getRightPostalCode1();
            if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                    postVal = Integer.parseInt(leftPostalCode1);
                    if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                        segment.putShort(32, (short)postVal);
                    } else {
                        segment.putInt(32, postVal);
                    }
                } else {
                    segment.putString(12, leftPostalCode1);
                }
            } else {
                if (leftPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(33, (short)postVal);
                        } else {
                            segment.putInt(33, postVal);
                        }
                    } else {
                        segment.putString(0, leftPostalCode1);
                    }
                }
                if (rightPostalCode1 != null) {
                    if (StringUtilities.isNumeric((String)rightPostalCode1)) {
                        postVal = Integer.parseInt(rightPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(34, (short)postVal);
                        } else {
                            segment.putInt(34, postVal);
                        }
                    } else {
                        segment.putString(1, rightPostalCode1);
                    }
                }
            }
            String leftAreaName1 = segmentRecord.getLeftAreaName1();
            String rightAreaName1 = segmentRecord.getRightAreaName1();
            if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                segment.putString(14, leftAreaName1);
            } else {
                if (leftAreaName1 != null) {
                    segment.putString(4, leftAreaName1);
                }
                if (rightAreaName1 != null) {
                    segment.putString(5, rightAreaName1);
                }
            }
            String leftAreaName2 = segmentRecord.getLeftAreaName2();
            String rightAreaName2 = segmentRecord.getRightAreaName2();
            if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                segment.putString(15, leftAreaName2);
            } else {
                if (leftAreaName2 != null) {
                    segment.putString(6, leftAreaName2);
                }
                if (rightAreaName2 != null) {
                    segment.putString(7, rightAreaName2);
                }
            }
            String leftAreaName4 = segmentRecord.getLeftAreaName4();
            String rightAreaName4 = segmentRecord.getRightAreaName4();
            if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                segment.putString(17, leftAreaName4);
            } else {
                if (leftAreaName4 != null) {
                    segment.putString(10, leftAreaName4);
                }
                if (rightAreaName4 != null) {
                    segment.putString(11, rightAreaName4);
                }
            }
            String leftAreaName3 = segmentRecord.getLeftAreaName3();
            String rightAreaName3 = segmentRecord.getRightAreaName3();
            if (leftAreaName3 != null && rightAreaName3 != null) {
                if (this.m_geoIndex != null) {
                    if (leftAreaName3.equalsIgnoreCase(rightAreaName3) && this.isLeftRightPostalCode1Same(leftPostalCode1, rightPostalCode1)) {
                        this.handleGeoInfoOffsetAndGenericAn3(segment, leftAreaName1, leftAreaName2, leftAreaName3, leftAreaName4, leftPostalCode1, SideType.BOTH_SIDE);
                    } else {
                        if (leftAreaName3 != null) {
                            segment.putString(8, leftAreaName3);
                        }
                        if (rightAreaName3 != null) {
                            segment.putString(9, rightAreaName3);
                        }
                    }
                }
            } else {
                if (leftAreaName3 != null && this.m_geoIndex != null) {
                    this.handleGeoInfoOffsetAndGenericAn3(segment, leftAreaName1, leftAreaName2, leftAreaName3, leftAreaName4, leftPostalCode1, SideType.LEFT_SIDE);
                }
                if (rightAreaName3 != null && this.m_geoIndex != null) {
                    this.handleGeoInfoOffsetAndGenericAn3(segment, rightAreaName1, rightAreaName2, rightAreaName3, rightAreaName4, rightPostalCode1, SideType.RIGHT_SIDE);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        this.populateLocalSegmentInfo(segmentRecord, (IDataFileDataItem)segment, metadata);
        this.storeSegmentPoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        this.storeHousePoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment((IDataFileDataItem)segment, this.buildRangeFromRangeRecord(range, metadata));
                if (range.getRangeUnits() != null) {
                    try {
                        segment.putInt(24, 0);
                        segment.putInt(43, 0);
                        segment.putInt(44, 0);
                        segment.putInt(45, 0);
                    }
                    catch (MMJETypeArraySizeExceededException e) {
                        e.printStackTrace();
                    }
                }
                ++this.totalRanges;
            }
        }
        return segment;
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)segmentItem;
        NZL_MMJSegmentRecord record = (NZL_MMJSegmentRecord)segmentRecord;
        String leftmeshBlock = record.getLeftMeshBlockId();
        String rightmeshBlock = record.getRightMeshBlockId();
        int uniqueIdentifier = record.getUniqueId();
        try {
            if (leftmeshBlock != null && rightmeshBlock != null && leftmeshBlock.equals(rightmeshBlock)) {
                segment.putString(43, leftmeshBlock);
            } else {
                if (leftmeshBlock != null && leftmeshBlock.length() != 0) {
                    segment.putString(44, leftmeshBlock);
                }
                if (rightmeshBlock != null && rightmeshBlock.length() != 0) {
                    segment.putString(45, leftmeshBlock);
                }
            }
            if (uniqueIdentifier != 0) {
                segment.putInt(46, uniqueIdentifier);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    private boolean isLeftRightPostalCode1Same(String left, String right) {
        if (NZL_AddressUtils.isEmpty(left)) {
            return NZL_AddressUtils.isEmpty(right);
        }
        if (NZL_AddressUtils.isEmpty(right)) {
            return false;
        }
        return left.equalsIgnoreCase(right);
    }

    private void handleGeoInfoOffsetAndGenericAn3(GenericSegment segment, String an1, String an2, String an3, String an4, String postalCode1, SideType sideType) throws DataCreationException {
        try {
            String combinedKey = an4 == null ? "" : an4;
            combinedKey = combinedKey + (an3 == null ? "" : an3);
            combinedKey = combinedKey + (an2 == null ? "" : an2);
            combinedKey = combinedKey + (an1 == null ? "" : an1);
            MiStringIndexKey key = new MiStringIndexKey(0 + combinedKey.toUpperCase());
            MapMarkerIndexSingleValue val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
            if (val == null) {
                key = new MiStringIndexKey(0 + EMEA_GeoInfoAliasKeyCreator.createKey(an3, postalCode1 == null ? "" : postalCode1));
                val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                if (val == null) {
                    key = new MiStringIndexKey(0 + an3);
                    val = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                }
                if (val == null) {
                    DataCreationLogger.getLogger().logInternalError("\n\nUnable to locate a geoinfo record for: " + an3);
                    DataCreationLogger.getLogger().logInternalError("Address Info: " + segment.toString());
                    DataCreationLogger.getLogger().logInternalError("In postalCode1: " + postalCode1);
                }
            }
            if (val != null) {
                long geoOffset = val.getOffset();
                if (geoOffset > 0L) {
                    segment.putLong(0, geoOffset);
                }
            } else if (sideType == SideType.BOTH_SIDE) {
                segment.putString(8, an3);
                segment.putString(9, an3);
            } else if (sideType == SideType.LEFT_SIDE) {
                segment.putString(8, an3);
            } else if (sideType == SideType.RIGHT_SIDE) {
                segment.putString(9, an3);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException IOEx) {
            System.err.println("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            System.err.println(IOEx.getMessage());
            IOEx.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected void populateRangeUnitInfo(MMJRangeUnitRecord record, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericUnit unit = (GenericUnit)unitItem;
        try {
            String value = record.getLowUnit();
            if (value != null) {
                String unitType = NZL_AddressTerm.removeFlat(value, true);
                if (!StringUtilities.isEmpty((String)unitType)) {
                    record.setUnitType(unitType);
                    value = value.replaceAll(unitType, "").trim();
                }
                if (value.indexOf(45) != -1) {
                    String[] list = value.split("-");
                    record.setLowUnit(list[0]);
                    record.setHighUnit(list[1]);
                } else {
                    record.setLowUnit(value);
                    record.setHighUnit(value);
                }
            }
            if (record.getLowUnit() != null) {
                unit.putString(0, record.getLowUnit());
            }
            if (record.getHighUnit() != null) {
                unit.putString(1, record.getHighUnit());
            }
            if (record.getUnitType() != null) {
                unit.putString(2, record.getUnitType());
            }
            if (record.getPlaceName() != null) {
                unit.putString(3, record.getPlaceName());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(108, (Throwable)e);
        }
    }

    protected void populateLocalRangeUnitInfo(MMJRangeUnitRecord rangeRecord, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericUnit unit = (GenericUnit)unitItem;
        NZL_MMJRangeUnitRecord record = (NZL_MMJRangeUnitRecord)rangeRecord;
        int uniqueIdentifier = record.getUniqueId();
        try {
            if (uniqueIdentifier != 0) {
                unit.putInt(49, uniqueIdentifier);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate rangeUnit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(108, (Throwable)e);
        }
    }

    protected void populateLocalRangeInfo(MMJRangeRecord rangeRecord, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericRange range = (GenericRange)rangeItem;
        NZL_MMJRangeRecord record = (NZL_MMJRangeRecord)rangeRecord;
        String leftmeshBlock = record.getLeftMeshBlockId();
        String rightmeshBlock = record.getRightMeshBlockId();
        LongPoint originalPoint = record.getOriginalPoint();
        try {
            if (leftmeshBlock != null && rightmeshBlock != null && leftmeshBlock.equals(rightmeshBlock)) {
                range.putString(50, leftmeshBlock);
            } else {
                if (leftmeshBlock != null && leftmeshBlock.length() != 0) {
                    range.putString(51, leftmeshBlock);
                }
                if (rightmeshBlock != null && rightmeshBlock.length() != 0) {
                    range.putString(52, leftmeshBlock);
                }
            }
            if (originalPoint != null) {
                range.putLong(47, originalPoint.getX());
                range.putLong(48, originalPoint.getY());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    private static final class SideType {
        private static final SideType LEFT_SIDE = new SideType("left");
        private static final SideType RIGHT_SIDE = new SideType("right");
        private static final SideType BOTH_SIDE = new SideType("both");
        private String m_name;

        private SideType(String typeName) {
            this.m_name = typeName;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

