/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.binary.index;

import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.NZL.NZLEnglishSoundex;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class NZL_GeoInfoSoundexIndexer
extends EMEA_GeoInfoSoundexIndexer {
    public NZL_GeoInfoSoundexIndexer() {
        this.sndx = NZLEnglishSoundex.getInstance();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        return this.makeKeys(item);
    }

    protected ArrayList makeKeys(GeoInfoDataItem item) throws DataCreationException {
        ArrayList<Object> list = new ArrayList<Object>(7);
        if (item != null) {
            String shortAreaName4;
            String areaName4;
            String shortAreaName3 = this.getShortAreaName3(item);
            if (shortAreaName3 == null) {
                shortAreaName3 = this.getAreaName3(item);
            }
            String altAreaName3 = this.getAltAreaName3(item);
            String altAreaName4 = this.getAltAreaName4(item);
            String altLanguageNames = this.getAltLanguageNames(item);
            if (shortAreaName3 != null && shortAreaName3.length() > 0) {
                ISoundexKey area3Key = this.sndx.getSoundex(shortAreaName3);
                list = new ArrayList();
                list.add(area3Key);
            }
            if ((areaName4 = this.getAreaName4(item)) != null && areaName4.length() > 0) {
                ISoundexKey area4Key = this.sndx.getSoundex(areaName4);
                list.add(area4Key);
            }
            if ((shortAreaName4 = NZL_ParsePostAddressRule.removeCommonWords(this.getAreaName4(item))) != null && shortAreaName4.length() > 0) {
                ISoundexKey shortAreaName4Key = this.sndx.getSoundex(shortAreaName4);
                list.add(shortAreaName4Key);
            }
            if (altAreaName3 != null && altAreaName3.length() > 0) {
                StringTokenizer st = new StringTokenizer(altAreaName3, "/");
                while (st.hasMoreTokens()) {
                    String firstWord;
                    int space;
                    String longName = st.nextToken().trim();
                    ISoundexKey altArea3KeyLong = this.sndx.getSoundex(longName);
                    list.add(altArea3KeyLong);
                    String shortName = NZL_ParsePostAddressRule.removeCommonWords(longName);
                    if (shortName != null && shortName.trim().length() > 0 && !shortName.equals(longName)) {
                        ISoundexKey altArea3KeyShort = this.sndx.getSoundex(shortName);
                        list.add(altArea3KeyShort);
                    }
                    if ((space = shortName.indexOf(" ")) <= 0 || (firstWord = shortName.substring(0, space)) == null || firstWord.trim().length() <= 0) continue;
                    ISoundexKey firstWordKey = this.sndx.getSoundex(firstWord);
                    list.add(firstWordKey);
                }
            }
            if (altAreaName4 != null && altAreaName4.length() > 0) {
                ISoundexKey altAreaName4Key = this.sndx.getSoundex(altAreaName4);
                list.add(altAreaName4Key);
            }
            if (altLanguageNames != null && altLanguageNames.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(altLanguageNames, "/", false);
                while (tokens.hasMoreTokens()) {
                    String s = tokens.nextToken().trim();
                    ISoundexKey altLangKey = this.sndx.getSoundex(s = NZL_ParsePostAddressRule.removeCommonWords(s));
                    if (list.contains(altLangKey)) continue;
                    list.add(altLangKey);
                }
            }
            if (list == null || list.size() == 0) {
                System.out.println("GeoInfoSoundexIndexer: No Keys defined:" + this.getAreaName3(item));
            }
            TreeSet set = new TreeSet(list);
            list.removeAll(list);
            list.addAll(set);
        }
        return list;
    }

    private String getAreaName4(GeoInfoDataItem item) throws DataCreationException {
        String ret = null;
        if (item != null && item.hasString(3)) {
            try {
                ret = item.getString(3);
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new DataCreationException(301, (Throwable)e);
            }
        }
        return ret;
    }

    private String getAltAreaName4(GeoInfoDataItem item) {
        String ret = null;
        if (item != null && item.hasString(7)) {
            try {
                ret = item.getString(7);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                System.err.println("ERROR: unable to get areaName4 from geoInfo item.");
                System.err.println(MMJETASEEx.getMessage());
                MMJETASEEx.printStackTrace(System.err);
                System.exit(1);
            }
        }
        return ret;
    }

    public static final void main(String[] args) {
        if (args == null || args.length < 1) {
            System.err.println("NZL_GeoInfoSoundexIndexer <geoinfo data file>");
            System.exit(1);
        }
        NZL_GeoInfoSoundexIndexer indexer = new NZL_GeoInfoSoundexIndexer();
        String geoInfoFileName = args[0];
        int extensionStart = geoInfoFileName.indexOf(".");
        if (extensionStart > 0) {
            geoInfoFileName = geoInfoFileName.substring(0, extensionStart);
            System.out.println("GeoInfo base name: " + geoInfoFileName);
        }
        try {
            indexer.processGeoInfoFile(geoInfoFileName);
        }
        catch (DataCreationException ex) {
            System.out.println("error");
            ex.printStackTrace();
        }
        System.out.println("Finished processing.");
    }
}

