/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.dp.intermediate;

import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJRangeUnitRecord;
import com.mapinfo.mapmarker.NZL.dp.binary.NZL_MMJSegmentRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateSegmentDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateUnitDataItem;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.util.HashMap;

public class NZL_IntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    public NZL_IntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new NZL_MMJSegmentRecord();
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        Address address = record.getAddress();
        if (address.hasAdditionalFields()) {
            try {
                this.putField2DataItem(item, address, "address.start", 11);
                this.putField2DataItem(item, address, "address.end", 12);
                this.putField2DataItem(item, address, "address.common.pre.main", 13);
                this.putField2DataItem(item, address, "address.common.post.st_type", 14);
                this.putField2DataItem(item, address, "is.major.road", 15);
                this.putField2DataItem(item, address, "pre_addr_common", 16);
                this.putField2DataItem(item, address, "post_addr_common", 17);
                this.putField2DataItem(item, address, "POST_MAIN_SEPARATOR", 18);
                this.putField2DataItem(item, address, "POST_TT_SEPARATOR", 19);
                this.putField2DataItem(item, address, "PRE_TT_SEPARATOR", 20);
                this.putField2DataItem(item, address, "PRE_DIRECTIONAL_SEPARATOR", 21);
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataSourceException(14, (Throwable)e);
            }
        }
    }

    protected void convertSegmentDataItem2Record(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentDataItem2Record(record, item);
        NZL_MMJSegmentRecord nzlSegmentRecord = (NZL_MMJSegmentRecord)record;
        try {
            if (item.hasString(43)) {
                nzlSegmentRecord.setLeftMeshBlockId(item.getString(43));
                nzlSegmentRecord.setRightMeshBlockId(item.getString(43));
            } else {
                if (item.hasString(44)) {
                    nzlSegmentRecord.setLeftMeshBlockId(item.getString(44));
                }
                if (item.hasString(45)) {
                    nzlSegmentRecord.setRightMeshBlockId(item.getString(45));
                }
            }
            if (item.hasInteger(24)) {
                nzlSegmentRecord.setUniqueId(item.getInt(24));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertSegmentRecord2DataItem(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentRecord2DataItem(record, item);
        NZL_MMJSegmentRecord nzlRecord = (NZL_MMJSegmentRecord)record;
        int uniqueIdentifier = nzlRecord.getUniqueId();
        try {
            String leftMeshBlock = nzlRecord.getLeftMeshBlockId();
            String rightMeshBlock = nzlRecord.getRightMeshBlockId();
            if (leftMeshBlock != null && rightMeshBlock != null && leftMeshBlock.equals(rightMeshBlock)) {
                item.putString(43, leftMeshBlock);
            } else {
                if (leftMeshBlock != null && leftMeshBlock.length() > 0) {
                    item.putString(44, leftMeshBlock);
                }
                if (rightMeshBlock != null && rightMeshBlock.length() > 0) {
                    item.putString(45, rightMeshBlock);
                }
            }
            if (uniqueIdentifier != 0) {
                item.putInt(24, uniqueIdentifier);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    private void putField2DataItem(IntermediateStreetDataItem item, Address address, Object hash, int index) throws MMJETypeArraySizeExceededException {
        String value = (String)address.getAdditionalFields().get(hash);
        if (value != null && value.length() > 0) {
            item.putString(index, value);
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        try {
            HashMap adFields = new HashMap();
            this.putDataItem2Field(item, adFields, "address.start", 11);
            this.putDataItem2Field(item, adFields, "address.end", 12);
            this.putDataItem2Field(item, adFields, "address.common.pre.main", 13);
            this.putDataItem2Field(item, adFields, "address.common.post.st_type", 14);
            this.putDataItem2Field(item, adFields, "is.major.road", 15);
            this.putDataItem2Field(item, adFields, "pre_addr_common", 16);
            this.putDataItem2Field(item, adFields, "post_addr_common", 17);
            this.putDataItem2Field(item, adFields, "POST_MAIN_SEPARATOR", 18);
            this.putDataItem2Field(item, adFields, "POST_TT_SEPARATOR", 19);
            this.putDataItem2Field(item, adFields, "PRE_TT_SEPARATOR", 20);
            this.putDataItem2Field(item, adFields, "PRE_DIRECTIONAL_SEPARATOR", 21);
            if (!adFields.isEmpty()) {
                Address address = record.getAddress();
                address.setAdditionalFields(adFields);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    private void putDataItem2Field(IntermediateStreetDataItem item, HashMap fields, Object hash, int index) throws MMJETypeArraySizeExceededException {
        if (item.hasString(index)) {
            fields.put(hash, item.getString(index));
        }
    }

    protected MMJRangeUnitRecord getUnitRecordType() {
        return new NZL_MMJRangeUnitRecord();
    }

    protected void convertUnitRecord2DataItem(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitRecord2DataItem(record, item);
        NZL_MMJRangeUnitRecord nzlRecord = (NZL_MMJRangeUnitRecord)record;
        try {
            int uniqueIdentifier = nzlRecord.getUniqueId();
            if (uniqueIdentifier != 0) {
                item.putInt(25, uniqueIdentifier);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range unit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertUnitDataItem2Record(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitDataItem2Record(record, item);
        NZL_MMJRangeUnitRecord nzlRangeunitRecord = (NZL_MMJRangeUnitRecord)record;
        try {
            if (item.hasInteger(25)) {
                nzlRangeunitRecord.setUniqueId(item.getInt(25));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate rangeunit data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new NZL_MMJRangeRecord();
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        NZL_MMJRangeRecord nzlRecord = (NZL_MMJRangeRecord)record;
        try {
            String leftMeshBlock = nzlRecord.getLeftMeshBlockId();
            String rightMeshBlock = nzlRecord.getRightMeshBlockId();
            LongPoint originalPoint = nzlRecord.getOriginalPoint();
            if (leftMeshBlock != null && rightMeshBlock != null && leftMeshBlock.equals(rightMeshBlock)) {
                item.putString(50, leftMeshBlock);
            } else {
                if (leftMeshBlock != null && leftMeshBlock.length() > 0) {
                    item.putString(51, leftMeshBlock);
                }
                if (rightMeshBlock != null && rightMeshBlock.length() > 0) {
                    item.putString(52, rightMeshBlock);
                }
            }
            if (originalPoint != null) {
                item.putLong(22, originalPoint.getX());
                item.putLong(23, originalPoint.getY());
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        NZL_MMJRangeRecord nzlSegmentRecord = (NZL_MMJRangeRecord)record;
        try {
            if (item.hasString(50)) {
                nzlSegmentRecord.setLeftMeshBlockId(item.getString(50));
                nzlSegmentRecord.setRightMeshBlockId(item.getString(50));
            } else {
                if (item.hasString(51)) {
                    nzlSegmentRecord.setLeftMeshBlockId(item.getString(51));
                }
                if (item.hasString(52)) {
                    nzlSegmentRecord.setRightMeshBlockId(item.getString(52));
                }
            }
            if (item.hasLong(22) && item.hasLong(23)) {
                nzlSegmentRecord.setOriginalPoint(new LongPoint(item.getLong(22), item.getLong(23)));
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataSourceException(14, (Throwable)e);
        }
    }
}

