/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.NZL.NZL_InternalConstants;
import com.mapinfo.mapmarker.NZL.parser.NZL_ParseMainAddressRule;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class NZL_AddressTerm {
    private static final String PUNCTUATION_CHARACTERS_KEY = "punctuation_chars";
    private static final String COUNTRY_CODES_KEY = "country_codes";
    private static final String HNR_START = "hnr_start";
    private static final String HNR_CAN_CONTAIN = "hnr_can_contain";
    private static final String STREET_NOT_CONTAIN = "street_not_contain";
    private static final String EXTENDED_CHARS = "extended_chars";
    private static final String PRE_NUM_STREET_WORD = "pre_num_street_word";
    private static final String POST_NUM_STREET_WORD = "post_num_street_word";
    private static final String MONTH_WORDS = "month_words";
    private static final String ORDINAL_CHARS = "ordinal_chars";
    private static final String ROMAN_NUMERAL_WORDS = "roman_numeral_words";
    private static final String POBOX_WORDS = "pobox_words";
    private static final String FLAT_IDENTIFIERS_WORDS = "flat_abbr";
    private static final String COMMON_STREET_NUMBERS = "common_street_number";
    private static ArrayList m_Flats = null;
    private static char[] romanNumberChars = new char[]{'X', 'V', 'I', ' ', '1'};
    private static char[] validPunctuationChars = new char[]{'-', '\'', ',', ' ', '.'};
    private static String punctuations = null;
    private static String ordinalChars = null;
    private static Set cntryCodeSet = null;
    private static Set hnrStartSet = null;
    private static Set hnrContainSet = null;
    private static Set streetNotContainSet = null;
    private static Set extendedCharsSet = null;
    private static Set preNumStreetWordSet = null;
    private static Set postNumStreetWordSet = null;
    private static Set monthWordSet = null;
    private static Set romanNumeralWordSet = null;
    private static Set poboxWordSet = null;
    private static Set commonStreetNumbers = null;
    private static Map commonTermMap = null;

    private static void loadPunctuations(String raw) {
        if (raw == null) {
            return;
        }
        String trim = raw.trim();
        if (trim.length() > 0) {
            punctuations = punctuations == null ? trim : punctuations + trim;
        }
    }

    private static void loadCountryCodes(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (cntryCodeSet == null) {
                cntryCodeSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String cntryCode = st.nextToken().trim();
                if (cntryCode.length() <= 0) continue;
                cntryCodeSet.add(cntryCode.toUpperCase());
            }
        }
    }

    private static void loadHnrStartTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrStartSet == null) {
                hnrStartSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String start = st.nextToken().trim();
                if (start.length() <= 0) continue;
                hnrStartSet.add(start.toUpperCase());
            }
        }
    }

    private static void loadHnrContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (hnrContainSet == null) {
                hnrContainSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                hnrContainSet.add(contains.toUpperCase());
            }
            hnrContainSet.add(",");
        }
    }

    private static void loadStreetNotContainTerms(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (streetNotContainSet == null) {
                streetNotContainSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String contains = st.nextToken().trim();
                if (contains.length() <= 0) continue;
                streetNotContainSet.add(contains.toUpperCase());
            }
        }
    }

    private static void loadMonths(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (monthWordSet == null) {
                monthWordSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                String monthWord = st.nextToken().trim();
                if (monthWord.length() <= 0) continue;
                monthWordSet.add(monthWord.toUpperCase());
            }
        }
    }

    private static void loadOrdinals(String raw) {
        if (raw == null) {
            return;
        }
        String trim = raw.trim();
        if (trim.length() > 0) {
            ordinalChars = ordinalChars == null ? trim : ordinalChars + trim;
        }
    }

    public static boolean isCountryCode(String code) {
        if (cntryCodeSet != null) {
            return cntryCodeSet.contains(code.toUpperCase());
        }
        return false;
    }

    public static boolean isPunctuation(String term) {
        return punctuations != null && term != null && punctuations.indexOf(term) != -1;
    }

    public static boolean isPunctuation(char ch) {
        return punctuations != null && punctuations.indexOf(ch) != -1;
    }

    public static boolean isOrdinalChar(char ch) {
        return ordinalChars != null && ordinalChars.indexOf(ch) != -1;
    }

    public static boolean isOrdinalChar(String term) {
        return ordinalChars != null && term != null && ordinalChars.indexOf(term) != -1;
    }

    public static String getAbbreviatedCommonTerm(String key) {
        String kepUpper;
        String string = kepUpper = key != null ? key.toUpperCase() : null;
        if (kepUpper != null && commonTermMap.containsKey(kepUpper)) {
            return ((String[])commonTermMap.get(kepUpper))[0];
        }
        return null;
    }

    public static String getExtendedCommonTerm(String key) {
        String kepUpper;
        String string = kepUpper = key != null ? key.toUpperCase() : null;
        if (kepUpper != null && commonTermMap.containsKey(kepUpper)) {
            return ((String[])commonTermMap.get(kepUpper))[1];
        }
        return null;
    }

    public static boolean isHnrStartTerm(String term) {
        return hnrStartSet != null && hnrStartSet.contains(term.toUpperCase());
    }

    public static boolean isHnrCanContainTerm(String term) {
        if (term != null && hnrContainSet != null) {
            return hnrContainSet.contains(term.toUpperCase());
        }
        return false;
    }

    public static boolean isStreetNotContainTerm(String term) {
        return streetNotContainSet != null && streetNotContainSet.contains(term.toUpperCase());
    }

    private static void loadPOBoxWords(String raw) {
        String string = raw = raw == null ? "" : raw.trim();
        if (raw.length() > 0) {
            if (poboxWordSet == null) {
                poboxWordSet = new HashSet(5);
            }
            StringTokenizer st = new StringTokenizer(raw.toUpperCase(), ",");
            while (st.hasMoreTokens()) {
                poboxWordSet.add(st.nextToken().trim());
            }
        }
    }

    private static void loadFlatAbbreviations(String raw) {
        if (raw != null && raw.trim().length() > 0) {
            if (m_Flats == null) {
                m_Flats = new ArrayList(10);
            }
            String vowel = null;
            StringTokenizer st = new StringTokenizer(raw, ",");
            while (st.hasMoreTokens()) {
                vowel = st.nextToken().trim();
                if (vowel.length() <= 0) continue;
                m_Flats.add(vowel.toLowerCase());
            }
        }
    }

    private static void loadCommonStreetNumbers(String raw) {
        String string = raw = raw == null ? "" : raw.trim();
        if (raw.length() > 0) {
            if (commonStreetNumbers == null) {
                commonStreetNumbers = new HashSet(22);
            }
            StringTokenizer st = new StringTokenizer(raw.toUpperCase(), ",");
            while (st.hasMoreTokens()) {
                commonStreetNumbers.add(st.nextToken().trim());
            }
        }
    }

    public static boolean isRomanNumber(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        term = term.toUpperCase();
        if (romanNumeralWordSet != null && romanNumeralWordSet.contains(term)) {
            return true;
        }
        char[] termChars = term.toCharArray();
        for (int i = 0; i < termChars.length; ++i) {
            boolean isRomanFound = false;
            for (int j = 0; j < romanNumberChars.length; ++j) {
                if (termChars[i] != romanNumberChars[j]) continue;
                isRomanFound = true;
                break;
            }
            if (isRomanFound) continue;
            return false;
        }
        return true;
    }

    public static void loadExtendedChars(String chars) {
        if (chars == null || chars.trim().length() == 0) {
            return;
        }
        if (extendedCharsSet == null) {
            extendedCharsSet = new HashSet(10);
        }
        StringTokenizer st = new StringTokenizer(chars, ",");
        while (st.hasMoreTokens()) {
            String exChar = st.nextToken().trim().toUpperCase();
            Character ch = new Character(exChar.charAt(0));
            extendedCharsSet.add(ch);
        }
    }

    public static boolean isExtendedChar(String ch) {
        if (ch != null && ch.length() == 1) {
            return NZL_AddressTerm.isExtendedChar(ch.charAt(0));
        }
        return false;
    }

    public static boolean isExtendedChar(char ch) {
        Character exChar = new Character(Character.toUpperCase(ch));
        return extendedCharsSet != null && extendedCharsSet.contains(exChar);
    }

    public static String getValidTerm(String inTerm) {
        return NZL_AddressTerm.getValidTerm(inTerm, false);
    }

    public static String getValidTerm(String inTerm, boolean canHaveNumeric) {
        if (inTerm == null || inTerm.trim().length() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(inTerm.length());
        char lastChar = '\u0000';
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.charAt(i);
            if (ch == '_') {
                ch = '-';
            }
            if (ch == ',') {
                ch = ' ';
            }
            if (NZL_AddressTerm.isValidPunctuationCharacter(ch) && buf.length() > 0) {
                if (lastChar != ch) {
                    buf.append(ch);
                }
            } else if (ch == '\'') {
                buf.append(ch);
            } else if (Character.isLetter(ch)) {
                buf.append(ch);
            } else if (NZL_AddressTerm.isExtendedChar(ch)) {
                buf.append(ch);
            } else if (canHaveNumeric && NZL_AddressTerm.isDigit(ch)) {
                buf.append(ch);
            }
            lastChar = ch;
        }
        if (buf.length() > 0) {
            return buf.toString().trim();
        }
        return null;
    }

    public static boolean isValidPunctuationCharacter(char ch) {
        for (int i = 0; i < validPunctuationChars.length; ++i) {
            if (ch != validPunctuationChars[i]) continue;
            return true;
        }
        return false;
    }

    private static void loadPreNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (preNumStreetWordSet == null) {
            preNumStreetWordSet = new HashSet(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            preNumStreetWordSet.add(word.toUpperCase());
        }
    }

    private static void loadPostNumStreetWord(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (postNumStreetWordSet == null) {
            postNumStreetWordSet = new HashSet(5);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            postNumStreetWordSet.add(word.toUpperCase());
        }
    }

    private static void loadRomanNumeralWords(String raw) {
        if (raw == null || raw.trim().length() == 0) {
            return;
        }
        if (romanNumeralWordSet == null) {
            romanNumeralWordSet = new HashSet(10);
        }
        StringTokenizer st = new StringTokenizer(raw, ",");
        while (st.hasMoreTokens()) {
            String word = st.nextToken().trim();
            romanNumeralWordSet.add(word.toUpperCase());
        }
    }

    public static boolean isPreNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return preNumStreetWordSet != null && preNumStreetWordSet.contains(word.toUpperCase());
    }

    public static boolean isPostNumStreetWord(String word) {
        if (word == null) {
            return false;
        }
        return postNumStreetWordSet != null && postNumStreetWordSet.contains(word.toUpperCase());
    }

    public static boolean isCommonStreetNumber(String word) {
        if (word == null || commonStreetNumbers == null) {
            return false;
        }
        return commonStreetNumbers.contains(word.toUpperCase());
    }

    public static boolean hasCommonStreetNumbers(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        StringTokenizer str = new StringTokenizer(term, " -\\/", false);
        while (str.hasMoreTokens()) {
            String token = str.nextToken().trim();
            if (token == null || !NZL_AddressTerm.isCommonStreetNumber(token)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMonth(String term) {
        if (monthWordSet == null || term == null || term.trim().length() == 0) {
            return false;
        }
        return monthWordSet.contains(term.toUpperCase());
    }

    public static String getPunctuationsAsString() {
        if (punctuations == null) {
            return null;
        }
        return punctuations;
    }

    public static String getOrdinalsAsString() {
        if (ordinalChars == null) {
            return null;
        }
        return ordinalChars;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static int isPOBox(String str) {
        if (str == null || poboxWordSet == null) {
            return 0;
        }
        StringTokenizer st = new StringTokenizer(str, " .-");
        ArrayList<String> list = new ArrayList<String>(5);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return NZL_AddressTerm.isPOBox(list);
    }

    public static int isPOBox(ArrayList list) {
        if (list == null || list.size() == 0 || poboxWordSet == null) {
            return 0;
        }
        StringBuffer buf = new StringBuffer(10);
        for (int i = 0; i < list.size(); ++i) {
            String term = (String)list.get(i);
            if (NZL_AddressTerm.isPunctuation(term)) continue;
            buf.append(term.toUpperCase());
        }
        if (buf.length() == 0) {
            return 0;
        }
        String str = buf.toString();
        boolean partialFound = false;
        for (String poboxWord : poboxWordSet) {
            if (poboxWord.equals(str)) {
                return 2;
            }
            if (!poboxWord.startsWith(str)) continue;
            partialFound = true;
        }
        if (partialFound) {
            return 1;
        }
        return 0;
    }

    public static String removeDeliveryPoint(String addressField) {
        if (addressField != null) {
            addressField = addressField.replaceAll("(^|\\s+)[R|r]\\.?\\s*[D|d]\\.?\\s*\\d+($|\\s+)", " ");
        }
        return addressField;
    }

    public static String findRuralDeliveryPoint(String word) {
        Matcher ruralMatcher = NZL_InternalConstants.RURAL_DELIVERY_POINT_PATTERN.matcher(word);
        String matchedString = "";
        if (ruralMatcher.find()) {
            matchedString = matchedString + ruralMatcher.group();
        }
        return matchedString;
    }

    public static String removeDoubleQuotes(String word) {
        if (word != null) {
            word = NZL_InternalConstants.QUOTES_PATTERN.matcher(word).replaceAll("");
        }
        return word;
    }

    public static boolean isAlpha(char ch) {
        char c = Character.toUpperCase(ch);
        return c >= 'A' && c <= 'Z';
    }

    public static String removeExtraSpaces(String streetAddress) {
        String cleanString = null;
        if (streetAddress != null && (cleanString = NZL_InternalConstants.NZL_MULTIPLE_SPACES_PATTERN.matcher(streetAddress).replaceAll(" ")) != null && !cleanString.trim().equalsIgnoreCase("")) {
            streetAddress = cleanString.trim();
        }
        return streetAddress;
    }

    public static String removeFlat(String str, boolean isDataCreation) {
        Matcher match;
        Matcher match1 = NZL_InternalConstants.FLAT_PATTERN.matcher(str);
        if (match1.find()) {
            String temp = match1.group().trim();
            StringBuffer sb = new StringBuffer();
            if (NZL_ParseMainAddressRule.isAlphaNumeric(temp)) {
                for (int i = 0; i < temp.length(); ++i) {
                    if (Character.isDigit(temp.charAt(i))) continue;
                    sb.append(temp.charAt(i));
                }
                temp = sb.toString();
            }
            if (!StringUtilities.isNumeric((String)temp) && !StringUtilities.isEmpty((String)temp)) {
                str = str.replaceFirst(temp, temp + " ");
                if (isDataCreation && temp.length() == 1) {
                    temp = NZL_AddressTerm.removeFlatAbbreviations(temp);
                }
                return temp;
            }
        }
        if ((match = NZL_InternalConstants.FLAT_REMOVAL_PATTERN.matcher(str)).find()) {
            String flat = null;
            int end = match.end(1);
            String temp = str.substring(end).trim();
            StringTokenizer tokenizer = new StringTokenizer(temp, " // \\");
            String token = tokenizer.nextToken();
            Matcher handleMatch = NZL_InternalConstants.SPECIAL_HANDLING_PATTERN.matcher(token);
            if (handleMatch.find()) {
                return null;
            }
            flat = match.group().trim();
            if (isDataCreation && flat != null && flat.length() == 1) {
                flat = NZL_AddressTerm.removeFlatAbbreviations(flat);
            }
            return flat;
        }
        return null;
    }

    public static String getFlatAbbrAsString() {
        if (m_Flats == null) {
            return null;
        }
        return m_Flats.toString();
    }

    public static String removeFlatAbbreviations(String inTerm) {
        if (inTerm == null) {
            return null;
        }
        String flats = NZL_AddressTerm.getFlatAbbrAsString();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < inTerm.length(); ++i) {
            char ch = inTerm.toLowerCase().charAt(i);
            if (flats.indexOf(ch) == -1) {
                buf.append(ch);
            }
            if (ch != ' ') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static boolean isNumeric(String term) {
        if (term == null) {
            return false;
        }
        for (int i = 0; i < term.length(); ++i) {
            if (Character.isDigit(term.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String term) {
        if (term == null) {
            return false;
        }
        for (int i = 0; i < term.length(); ++i) {
            if (Character.isLetter(term.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(NZL_AddressTerm.class.getResourceAsStream("NZL_AddressTerm.properties"));
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.startsWith(PUNCTUATION_CHARACTERS_KEY)) {
                    NZL_AddressTerm.loadPunctuations(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COUNTRY_CODES_KEY)) {
                    NZL_AddressTerm.loadCountryCodes(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_START)) {
                    NZL_AddressTerm.loadHnrStartTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(HNR_CAN_CONTAIN)) {
                    NZL_AddressTerm.loadHnrContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(STREET_NOT_CONTAIN)) {
                    NZL_AddressTerm.loadStreetNotContainTerms(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(EXTENDED_CHARS)) {
                    NZL_AddressTerm.loadExtendedChars(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(PRE_NUM_STREET_WORD)) {
                    NZL_AddressTerm.loadPreNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POST_NUM_STREET_WORD)) {
                    NZL_AddressTerm.loadPostNumStreetWord(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(MONTH_WORDS)) {
                    NZL_AddressTerm.loadMonths(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ORDINAL_CHARS)) {
                    NZL_AddressTerm.loadOrdinals(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(ROMAN_NUMERAL_WORDS)) {
                    NZL_AddressTerm.loadRomanNumeralWords(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(POBOX_WORDS)) {
                    NZL_AddressTerm.loadPOBoxWords(properties.getProperty(key));
                    continue;
                }
                if (key.startsWith(COMMON_STREET_NUMBERS)) {
                    NZL_AddressTerm.loadCommonStreetNumbers(properties.getProperty(key));
                    continue;
                }
                if (!key.startsWith(FLAT_IDENTIFIERS_WORDS)) continue;
                NZL_AddressTerm.loadFlatAbbreviations(properties.getProperty(key));
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for NZL_Parser.");
        }
    }
}

