/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class NZL_Directionals {
    private static Map LOOKUP_MAPS;

    private NZL_Directionals() {
    }

    public static boolean isDirectional(String key) {
        return key != null && LOOKUP_MAPS.containsKey(key.toUpperCase());
    }

    public static Directional getDirectional(String key) {
        if (key == null) {
            return null;
        }
        Object obj = LOOKUP_MAPS.get(key.toUpperCase());
        return obj == null ? null : (Directional)obj;
    }

    private static void init() {
        try {
            LOOKUP_MAPS = new Hashtable(30);
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(NZL_Directionals.class.getResourceAsStream("NZL_Directionals.xml"));
            Element root = doc.getRootElement();
            List dirs = root.getChildren("Directional");
            for (Element dirElem : dirs) {
                String name = dirElem.getAttributeValue("name").trim();
                Directional dir = new Directional(name);
                List relatives = dirElem.getChildren("Relative");
                for (int index = 0; index < relatives.size(); ++index) {
                    Element relativeElem = (Element)relatives.get(index);
                    dir.addRelative(relativeElem.getAttributeValue("nameRef").trim().toUpperCase());
                }
                List vars = dirElem.getChildren("Variation");
                for (int index = 0; index < vars.size(); ++index) {
                    Element varElem = (Element)vars.get(index);
                    LOOKUP_MAPS.put(varElem.getTextTrim().toUpperCase(), dir);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load required file NZL_Directionals.xml", e);
        }
    }

    static {
        NZL_Directionals.init();
    }

    public static class Directional {
        private String m_name;
        private Set m_relatives;

        private Directional(String name) {
            this.m_name = name;
            this.m_relatives = new HashSet();
        }

        public String getName() {
            return this.m_name;
        }

        public boolean isRelative(Directional dir) {
            return dir != null && this.m_relatives.contains(dir.getName());
        }

        private void addRelative(String name) {
            if (name == null) {
                return;
            }
            if (!this.m_relatives.contains(name)) {
                this.m_relatives.add(name);
            }
        }
    }
}

