/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class NZL_Ordinals {
    private static Properties m_wordKeys = null;
    private static Properties m_abbrKeys = null;

    public static void load() throws Throwable {
        try {
            if (m_wordKeys == null) {
                Properties temp = new Properties();
                m_wordKeys = new Properties();
                m_abbrKeys = new Properties();
                temp.load(NZL_Ordinals.class.getResourceAsStream("NZL_Ordinals.properties"));
                Enumeration<Object> em = temp.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    NZL_Ordinals.processLine((String)temp.get(key));
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for NZL_Parser.");
        }
    }

    public static boolean isAbbreviatedOrdinal(String word) {
        if (word == null || word.trim().length() == 0) {
            return false;
        }
        return m_abbrKeys.containsKey(word.toUpperCase());
    }

    public static boolean hasOrdinalAbbreviation(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        return m_wordKeys.containsKey(term.trim().toUpperCase());
    }

    public static String getAbbreviationForWord(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)m_wordKeys.get(word.toUpperCase());
    }

    public static String getWordForAbbreviation(String abbr) {
        if (abbr == null || abbr.trim().length() == 0) {
            return null;
        }
        return (String)m_abbrKeys.get(abbr.toUpperCase());
    }

    private static void processLine(String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        int firstComma = (value = value.toUpperCase()).indexOf(",");
        if (firstComma == -1) {
            return;
        }
        String key = value.substring(0, firstComma);
        if (key == null) {
            return;
        }
        String newValue = value.substring(firstComma + 1, value.length());
        if (newValue == null) {
            return;
        }
        m_wordKeys.put(key.toUpperCase(), newValue.toUpperCase());
        StringTokenizer st = new StringTokenizer(newValue, ",", false);
        String abbr = null;
        while (st.hasMoreTokens()) {
            abbr = st.nextToken();
            if (abbr == null) continue;
            String previous = m_abbrKeys.getProperty(abbr);
            if (previous == null || previous.trim().length() == 0) {
                m_abbrKeys.put(abbr, key);
                continue;
            }
            String tempkey = previous + "," + key;
            m_abbrKeys.put(abbr, tempkey);
        }
    }

    public static ArrayList createAbbreviationAlternatives(String inputTerm) {
        if (inputTerm == null || inputTerm.trim().length() == 0) {
            return null;
        }
        StringTokenizer inputIter = new StringTokenizer(inputTerm, ",- ", false);
        if (inputIter.countTokens() == 1 && (inputTerm.indexOf(".") > -1 || inputTerm.indexOf("/") > -1)) {
            inputIter = new StringTokenizer(inputTerm, ".\\/", false);
        }
        if (inputIter.countTokens() == 0) {
            return null;
        }
        ArrayList<StringBuffer> returnList = new ArrayList<StringBuffer>();
        StringBuffer fullTerm = null;
        StringTokenizer abbrIter = null;
        String expandedTerm = null;
        boolean firstPass = true;
        while (inputIter.hasMoreTokens()) {
            expandedTerm = null;
            String term = inputIter.nextToken();
            if (NZL_Ordinals.isAbbreviatedOrdinal(term)) {
                expandedTerm = NZL_Ordinals.getWordForAbbreviation(term);
            }
            if (expandedTerm == null || expandedTerm.trim().length() == 0) {
                if (firstPass) {
                    firstPass = false;
                    returnList = new ArrayList();
                    fullTerm = new StringBuffer(term + " ");
                    returnList.add(fullTerm);
                    continue;
                }
                for (int i = 0; i < returnList.size(); ++i) {
                    StringBuffer temp = (StringBuffer)returnList.get(i);
                    temp.append(term + " ");
                }
                continue;
            }
            if (firstPass) {
                firstPass = false;
            }
            abbrIter = new StringTokenizer(expandedTerm, ",", false);
            int abbrCount = abbrIter.countTokens();
            ArrayList<StringBuffer> tempList = new ArrayList<StringBuffer>((returnList.size() == 0 ? 1 : returnList.size()) * abbrCount);
            while (abbrIter.hasMoreTokens()) {
                String temp = abbrIter.nextToken();
                if (returnList.size() == 0) {
                    fullTerm = new StringBuffer(temp + " ");
                    tempList.add(fullTerm);
                    continue;
                }
                int lastPassListSize = returnList.size();
                for (int i = 0; i < lastPassListSize; ++i) {
                    StringBuffer sb2 = new StringBuffer(((StringBuffer)returnList.get(i)).toString());
                    sb2.append(temp + " ");
                    tempList.add(sb2);
                }
            }
            returnList = tempList;
        }
        return returnList.size() == 0 ? null : returnList;
    }

    static {
        try {
            NZL_Ordinals.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

