/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.NZL.NZL_Constraints;
import com.mapinfo.mapmarker.NZL.NZL_InternalConstants;
import com.mapinfo.mapmarker.NZL.parser.NZL_Abbreviations;
import com.mapinfo.mapmarker.NZL.parser.NZL_AddressTerm;
import com.mapinfo.mapmarker.NZL.parser.NZL_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NZL_ParseMainAddressRule
implements IParseRule {
    public static final String UNPARSED_HNR = "unparsed_hnr";
    private static ArrayList keyList = new ArrayList();
    private static Pattern poBoxPattern;
    private static Pattern mainStreetEndingInFigurePattern;
    private static Pattern mainStreetEndingInFigurePatternSpecial;
    private static Pattern houseNoPattern;
    private static Pattern frenchAddressPattern;
    private static Pattern directionalPattern;
    private static Pattern careOfPattern;
    private static final String POBOX = "pobox";
    private static final String SPECIAL_STREET = "special_street";
    private static final String SPECIAL_NORMAL_STREET = "special_normal_street";
    private static final String HOUSE_NO = "house_no";
    private static final String FRENCH_ADDRESS = "french_address";
    private static final String DIRECTIONAL = "directional";
    private static final String CARE_OF = "care_of";
    private static final String unitHouseNoSeparator = "/";
    private static final String HYPENATED_NO = "hypenated_no";
    private static Pattern hypenatedPattern;
    private static final String CORNER_INTERSECTION = "corner_intersection";
    private static Pattern CornerOf_Pattern;
    private static final String NORMAL_HNR = "normal_hnr";
    private static final String HNR_UNIT = "hnr_unit";
    private static Pattern hnrPattern;
    private static Pattern hnr_unitPattern;
    private static final String SPECIAL_HANDLING = "\\D{3}";
    private static Pattern SPECIAL_HANDLING_PATTERN;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String flatType;
        String str = null;
        String[] temp = null;
        ArrayList<String> tempBuffer = new ArrayList<String>();
        pa.setAddressNumber(NZL_ParseMainAddressRule.getProperHouseNumber(pa.getAddressNumber()));
        String mainAddress = NZL_AddressTerm.removeDoubleQuotes(pa.getMainAddress());
        str = NZL_ParseMainAddressRule.removeCorner(mainAddress);
        if (str != null) {
            temp = str.split("&| ");
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i].length() == 0) continue;
                tempBuffer.add(temp[i]);
            }
            if (tempBuffer.size() >= 2) {
                boolean result2;
                boolean result1 = tempBuffer.get(0) != null && (NZL_ParseMainAddressRule.isValidHouseNumberRange(tempBuffer.get(0).toString()) || NZL_ParseMainAddressRule.isValidHouseNumber(tempBuffer.get(0).toString()));
                boolean bl = result2 = tempBuffer.get(1) != null && (NZL_ParseMainAddressRule.isValidHouseNumberRange(tempBuffer.get(1).toString()) || NZL_ParseMainAddressRule.isValidHouseNumber(tempBuffer.get(1).toString()));
                if (result1 && result2) {
                    str = str.replaceFirst("&", "-");
                }
            }
        }
        if (this.isEmpty(str)) {
            return;
        }
        String ruralDeliveryPoint = NZL_AddressTerm.findRuralDeliveryPoint(str);
        if (ruralDeliveryPoint != null || !ruralDeliveryPoint.equalsIgnoreCase("")) {
            str = NZL_AddressTerm.removeDeliveryPoint(str);
        }
        StringBuffer strBuilder = new StringBuffer(str);
        strBuilder = NZL_ParseMainAddressRule.cleanAddress(strBuilder);
        NZL_ParseMainAddressRule.removePOBox(strBuilder);
        String street = NZL_ParseMainAddressRule.removeCareOfIndicator(strBuilder.toString().trim());
        NZL_Constraints nzlConstraints = (NZL_Constraints)constraints;
        boolean isDataCreation = false;
        if (nzlConstraints != null) {
            isDataCreation = nzlConstraints.getDataConstructionConstraint();
        }
        if ((flatType = NZL_AddressTerm.removeFlat(street, isDataCreation)) != null) {
            pa.setUnitType(flatType);
        }
        if (str != null && flatType != null) {
            street = street.replaceFirst(flatType, "");
        }
        StringBuffer strBuffer = new StringBuffer(street);
        this.separateStreetName(strBuffer, pa);
        this.checkForInvalidTypes(pa, ruralDeliveryPoint);
    }

    private void checkForInvalidTypes(Address pa, String ruralDeliveryPoint) {
        StringBuffer sb;
        String ptt = pa.getPreThoroughfareType();
        if (ptt != null && !NZL_ThoroughfareTypes.isStreetType(ptt)) {
            sb = new StringBuffer(pa.getPreThoroughfareType());
            sb.append(" ");
            sb.append(pa.getMainAddress());
            pa.setMainAddress(sb.toString());
            pa.setPreThoroughfareType("");
        }
        if (!this.isEmpty(ptt = pa.getPostThoroughfareType()) && !NZL_ThoroughfareTypes.isStreetType(ptt)) {
            sb = new StringBuffer(pa.getMainAddress());
            sb.append(" ");
            sb.append(pa.getPostThoroughfareType());
            pa.setMainAddress(sb.toString());
            pa.setPostThoroughfareType("");
        }
        this.handleFallbackFromRuralDelivery(pa, ruralDeliveryPoint);
    }

    private void handleFallbackFromRuralDelivery(Address pa, String ruralDeliveryPoint) {
        String ptt = pa.getPostThoroughfareType();
        String preTt = pa.getPreThoroughfareType();
        if (!(ptt != null || preTt != null || pa.getMainAddress() == null || this.isEmpty(ruralDeliveryPoint) || ruralDeliveryPoint.indexOf("RD") == -1 && ruralDeliveryPoint.indexOf("rd") == -1)) {
            pa.setPostThoroughfareType("RD");
            if (pa.getAddressNumber() == null) {
                pa.setAddressNumber(ruralDeliveryPoint.toUpperCase().replaceAll("RD", ""));
            }
        }
    }

    public static void removePOBox(StringBuffer str) {
        Matcher match = poBoxPattern.matcher(str);
        if (match.find()) {
            int start = match.start();
            int end = match.end();
            str.replace(start, end, "");
        }
    }

    public static StringBuffer cleanAddress(StringBuffer str) {
        String temp;
        str = new StringBuffer(str.toString().trim());
        while (str.length() > 0 && (temp = str.substring(0, 1)).length() == 1 && NZL_AddressTerm.isPunctuation(temp)) {
            str = new StringBuffer(str.substring(1));
        }
        while (str.length() > 0 && (temp = str.substring(str.length() - 1, str.length())).length() == 1 && NZL_AddressTerm.isPunctuation(temp)) {
            str = new StringBuffer(str.substring(0, str.length() - 1));
        }
        String lastPunctuation = null;
        for (int i = 0; i < str.length(); ++i) {
            String temp2 = str.substring(i, i + 1);
            if (temp2.length() == 1 && NZL_AddressTerm.isPunctuation(temp2)) {
                if (temp2.equals(lastPunctuation)) {
                    str.replace(i, i + 1, "");
                    break;
                }
                lastPunctuation = temp2;
                continue;
            }
            lastPunctuation = null;
        }
        StringTokenizer tokens = new StringTokenizer(str.toString(), ",.!;");
        str = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            str.append(tokens.nextToken()).append(" ");
        }
        str = new StringBuffer(str.toString().trim());
        return str;
    }

    protected void separateStreetName(StringBuffer str, Address pa) throws ParserException {
        if (this.isEmpty(str.toString())) {
            pa.setMainAddress(null);
            return;
        }
        String result = hypenatedPattern.matcher(str.toString().trim()).replaceAll(" - ");
        str = new StringBuffer(result);
        Matcher match = NZL_ParseMainAddressRule.checkStreetInput(hnr_unitPattern, str = NZL_ParseMainAddressRule.cleanAddress(str));
        if (match != null && pa.getUnitType() != null) {
            String hnr = null;
            String unitNo = this.removeUnitNo(match, str);
            StringBuffer buffer = null;
            if (pa.getUnitType() != null && unitNo != null) {
                pa.setUnitValue(unitNo);
            } else if (pa.getUnitType() != null && unitNo == null) {
                String unitType = pa.getUnitType();
                buffer = new StringBuffer(unitType + " ");
                buffer.append(str);
                pa.setUnitType(null);
            }
            str = buffer != null && !StringUtilities.isEmpty((String)buffer.toString()) ? new StringBuffer(buffer.toString().trim()) : new StringBuffer(str.toString().trim());
            if (str.indexOf(unitHouseNoSeparator) == 0 || str.indexOf("\\") == 0) {
                str.deleteCharAt(0);
                match = NZL_ParseMainAddressRule.checkStreetInput(houseNoPattern, str);
                if (match != null) {
                    hnr = NZL_ParseMainAddressRule.separateHouseNumber(match, str);
                }
            } else {
                match = NZL_ParseMainAddressRule.checkStreetInput(houseNoPattern, str);
                if (match != null) {
                    hnr = NZL_ParseMainAddressRule.separateHouseNumber(match, str);
                }
            }
            if (hnr == null && unitNo != null && !unitNo.equals("")) {
                int unitIndex = unitNo.indexOf(45);
                if (unitIndex > -1) {
                    unitNo = hypenatedPattern.matcher(unitNo.trim()).replaceAll("-");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(unitNo, "-");
                LinkedList listOfTokens = null;
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)stringTokenizer);
                if (listOfTokens.size() != 0 && listOfTokens.size() > 1) {
                    pa.setUnitValue(listOfTokens.get(0).toString());
                    pa.setAddressNumber(listOfTokens.get(1).toString());
                }
            } else {
                pa.setUnitValue(new ParsedNumber(unitNo).getCombinedAddressNumber());
                pa.setAddressNumber(hnr);
            }
            if (pa.getAddressNumber() == null && pa.getUnitValue() != null && !pa.getUnitValue().equals("") && pa.getUnitType() != null && pa.getUnitType().length() == 1) {
                pa.setAddressNumber(pa.getUnitValue());
                pa.setUnitValue(pa.getUnitType());
                pa.setUnitType(null);
            }
            if (pa.getAddressNumber() != null && pa.getAddressNumber().lastIndexOf(" ") > -1) {
                String temp = pa.getAddressNumber();
                int index = temp.lastIndexOf(" ");
                pa.setAddressNumber(temp.substring(0, index + 1).trim());
                String currentAddress = str.toString();
                str.delete(0, str.length());
                str.append(temp.substring(index + 1)).append(" ").append(currentAddress);
            }
        } else {
            str = this.processSpecialCase(str, pa);
        }
        str = new StringBuffer(hypenatedPattern.matcher(str.toString().trim()).replaceAll("-"));
        str = this.normalize(str);
        if (this.isEmpty(str.toString())) {
            if (pa.getAddressNumber() != null && pa.getAddressNumber().length() > 0) {
                pa.setMainAddress(pa.getAddressNumber());
                pa.setAddressNumber((String)null);
            } else {
                pa.setMainAddress(null);
            }
            return;
        }
        match = NZL_ParseMainAddressRule.checkStreetInput(frenchAddressPattern, str);
        if (match != null) {
            this.processFrenchAddress(match, str, pa);
        } else {
            match = NZL_ParseMainAddressRule.checkStreetInput(mainStreetEndingInFigurePattern, str);
            if (match != null) {
                this.processSpecialStreetName(match, str, pa);
            } else {
                match = NZL_ParseMainAddressRule.checkStreetInput(mainStreetEndingInFigurePatternSpecial, str);
                if (match != null) {
                    this.processSpecialNormalStreetName(match, str, pa);
                } else {
                    this.processNormalAddress(str, pa);
                }
            }
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static Matcher checkStreetInput(Pattern pattern, StringBuffer str) {
        Matcher match = pattern.matcher(str);
        if (!match.find()) {
            match = null;
        }
        return match;
    }

    private String removeUnitNo(Matcher match, StringBuffer str) {
        return NZL_ParseMainAddressRule.separateHouseNumber(match, str);
    }

    private static String separateHouseNumber(Matcher match, StringBuffer str) {
        String inputStr = null;
        String num = match.group().trim();
        if (num != null && !num.equals("")) {
            inputStr = str.toString();
            StringTokenizer tokenizer = new StringTokenizer(inputStr, " // \\");
            String token = tokenizer.nextToken();
            Matcher handleMatch = SPECIAL_HANDLING_PATTERN.matcher(token);
            if (handleMatch.find()) {
                return null;
            }
            str.delete(0, match.end(1));
        }
        return num;
    }

    private void processFrenchAddress(Matcher match, StringBuffer mainStreet, Address pa) {
        String substitute = "Rue";
        String group1 = match.group(1);
        if (group1 != null) {
            pa.setPreThoroughfareType(group1.trim());
        } else {
            pa.setPreThoroughfareType(substitute);
        }
        mainStreet.delete(match.start(), match.end());
        mainStreet = new StringBuffer(mainStreet.toString().trim());
        StringTokenizer tokens = new StringTokenizer(mainStreet.toString());
        if (!tokens.hasMoreTokens()) {
            pa.setMainAddress(pa.getPreThoroughfareType());
            pa.setPreThoroughfareType(null);
        } else if (tokens.countTokens() > 1) {
            int indexOfLastSpace = mainStreet.lastIndexOf(" ");
            pa.setMainAddress(mainStreet.substring(indexOfLastSpace + 1));
            pa.setPreAddress(mainStreet.substring(0, indexOfLastSpace).trim());
        } else {
            pa.setMainAddress(mainStreet.toString());
        }
    }

    private void processSpecialStreetName(Matcher match, StringBuffer mainStreet, Address pa) {
        String mainAddress = match.group(1);
        pa.setMainAddress(mainAddress.trim());
        mainStreet.delete(match.start(1), match.end(1));
        pa.setPreThoroughfareType(mainStreet.toString().trim());
    }

    private void processSpecialNormalStreetName(Matcher match, StringBuffer mainStreet, Address pa) {
        LinkedList list = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(mainStreet.toString()));
        boolean found = false;
        int m = -1;
        for (int j = 0; j < list.size(); ++j) {
            String temp = (String)list.get(j);
            if (!NZL_ThoroughfareTypes.isStreetType(temp)) continue;
            found = true;
            m = j;
        }
        if (found) {
            String str = (String)list.get(m);
            int index = mainStreet.lastIndexOf(str);
            pa.setPostAddress(mainStreet.substring(index + str.length()).trim());
            mainStreet.delete(index + str.length(), mainStreet.length());
        } else {
            boolean foundCommon = false;
            int n = -1;
            for (int k = 0; k < list.size(); ++k) {
                String temp = (String)list.get(k);
                if (!NZL_Abbreviations.isCommonTerm(temp)) continue;
                foundCommon = true;
                n = k;
            }
            if (foundCommon) {
                String str = (String)list.get(n);
                int index = mainStreet.lastIndexOf(str);
                pa.setPostAddress(mainStreet.substring(index).trim());
                mainStreet.delete(index, mainStreet.length());
            }
        }
        this.processNormalAddress(mainStreet, pa);
    }

    private void processNormalAddress(StringBuffer mainStreet, Address pa) {
        Matcher directional;
        pa.setMainAddress(null);
        if (pa.getAddressNumber() != null && pa.getUnitValue() == null) {
            StringBuffer sb = new StringBuffer();
            if (mainStreet.indexOf(unitHouseNoSeparator) > -1 || mainStreet.indexOf("\\") > -1) {
                String tempMain = mainStreet.toString();
                StringTokenizer mainTokenList = new StringTokenizer(tempMain, " ");
                boolean flag = false;
                while (mainTokenList.hasMoreTokens()) {
                    Matcher flatMatch;
                    String token = mainTokenList.nextToken();
                    Matcher match = SPECIAL_HANDLING_PATTERN.matcher(token);
                    if (match.find() && !(flatMatch = NZL_InternalConstants.FLAT_PATTERN.matcher(token)).find()) {
                        flag = true;
                    }
                    if (!flag || NZL_AddressTerm.isPunctuation(token)) continue;
                    sb.append(token);
                    sb.append(" ");
                }
                mainStreet = sb;
            }
            mainStreet = new StringBuffer(mainStreet.toString().trim());
        } else {
            mainStreet = new StringBuffer(mainStreet.toString().trim());
        }
        LinkedList list = StringUtilities.tokensToList((StringTokenizer)new StringTokenizer(mainStreet.toString()));
        int m = 0;
        boolean found = false;
        for (int j = 0; j < list.size(); ++j) {
            String temp = (String)list.get(j);
            if (!NZL_ThoroughfareTypes.isStreetType(temp)) continue;
            this.setProperPostThoroughfareType(pa, temp);
            found = true;
            m = j;
        }
        if (found) {
            if (m < list.size() - 1) {
                StringBuffer postAddress = this.convertListToString(list.subList(m + 1, list.size()));
                directional = directionalPattern.matcher(postAddress);
                if (directional.find()) {
                    pa.setPostDirectional(directional.group(0));
                    postAddress.delete(directional.start(), directional.end());
                    String postAddr = postAddress.toString();
                    if (postAddress != null) {
                        postAddr = postAddr.replaceAll("\\(", " ");
                        postAddr = postAddr.replaceAll("\\)", " ");
                        pa.setPostAddress(postAddr);
                    }
                }
                list = new LinkedList(list.subList(0, m));
            } else {
                list.remove(m);
            }
        }
        if (list.size() > 1) {
            StringBuffer temp = this.convertListToString(list);
            directional = directionalPattern.matcher(temp);
            if (directional.find()) {
                String preDirectional = directional.group(0);
                if (list.indexOf(preDirectional) < list.size() - 1 && found) {
                    pa.setPreDirectional(directional.group(0));
                    temp.delete(directional.start(), directional.end());
                    pa.setMainAddress(temp.toString().trim());
                } else if (list.indexOf(preDirectional) == list.size() - 1 && !found) {
                    pa.setPostDirectional(directional.group(0));
                    temp.delete(directional.start(), directional.end());
                    pa.setMainAddress(temp.toString().trim());
                } else if (list.indexOf(preDirectional) < list.size() - 1) {
                    if (temp != null && directional.start() != 0 && temp.charAt(directional.start() - 1) != '\'') {
                        pa.setPreDirectional(directional.group(0));
                        temp.delete(directional.start(), directional.end());
                    } else if (directional.start() == 0) {
                        pa.setPreDirectional(directional.group(0));
                        temp.delete(directional.start(), directional.end());
                    }
                    pa.setMainAddress(temp.toString().trim());
                } else {
                    pa.setMainAddress(temp.toString().trim());
                }
            } else {
                pa.setMainAddress(temp.toString().trim());
            }
        } else if (list.size() == 1) {
            pa.setMainAddress((String)list.getFirst());
        }
        if ((pa.getMainAddress() == null || pa.getMainAddress().equals("")) && pa.getPostThoroughfareType() != null) {
            pa.setMainAddress(pa.getPostThoroughfareType());
            pa.setPostThoroughfareType(null);
        }
        String hyphenSeparatedThoroughfare = "-";
        if (pa.getMainAddress() != null && pa.getMainAddress().indexOf(hyphenSeparatedThoroughfare) > -1) {
            String mainAddress = pa.getMainAddress();
            String possibleThoroughfare = null;
            int index = mainAddress.indexOf(hyphenSeparatedThoroughfare);
            possibleThoroughfare = mainAddress.substring(index + 1).trim();
            if (NZL_ThoroughfareTypes.isStreetType(possibleThoroughfare) && (pa.getPostThoroughfareType() == null || pa.getPostThoroughfareType().equals(""))) {
                this.setProperPostThoroughfareType(pa, possibleThoroughfare);
                pa.setMainAddress(mainAddress.substring(0, index));
            }
        }
    }

    private StringBuffer convertListToString(List list) {
        StringBuffer build = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                build.append(list.get(i)).append(" ");
            }
        }
        return build.delete(build.length() - 1, build.length());
    }

    private static void cleanBuffer(StringBuffer builder) {
        if (builder != null) {
            builder.delete(0, builder.length());
        }
    }

    private void setProperPostThoroughfareType(Address pa, String str) {
        if (str != null) {
            NZL_ThoroughfareTypes.NZL_ThoroughfareType keyInfo = NZL_ThoroughfareTypes.getThoroughfareType(str);
            if (keyInfo != null) {
                pa.setPostThoroughfareType(keyInfo.getProperTypeName());
            } else {
                pa.setPostThoroughfareType(str);
            }
        } else {
            pa.setPostThoroughfareType(null);
        }
    }

    public static String getProperHouseNumber(String inHnr) {
        if (inHnr == null) {
            return null;
        }
        String result = null;
        StringBuffer hnr = new StringBuffer(inHnr);
        Matcher match = NZL_ParseMainAddressRule.checkStreetInput(houseNoPattern, hnr);
        if (match != null) {
            result = NZL_ParseMainAddressRule.separateHouseNumber(match, hnr);
        }
        if ((hnr = new StringBuffer(hnr.toString().trim())).indexOf(unitHouseNoSeparator) == 0) {
            hnr.deleteCharAt(0);
            match = NZL_ParseMainAddressRule.checkStreetInput(houseNoPattern, hnr);
            if (match != null) {
                result = NZL_ParseMainAddressRule.separateHouseNumber(match, hnr);
            }
        }
        return result;
    }

    private StringBuffer normalize(StringBuffer str) {
        StringBuffer buf = new StringBuffer();
        if (str != null && str.length() != 0) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (i == 0 && !Character.isWhitespace(c)) {
                    buf.append(c);
                    continue;
                }
                if (Character.isDigit(c) && Character.isLetter(str.charAt(i - 1))) {
                    buf.append(" ").append(c);
                    continue;
                }
                buf.append(c);
            }
        }
        return buf;
    }

    private StringBuffer processSpecialCase(StringBuffer str, Address pa) {
        String possibleHnr;
        Matcher match;
        if (pa.getUnitValue() == null && pa.getAddressNumber() == null) {
            int firstSlashIndex = str.indexOf(unitHouseNoSeparator);
            int firstBackSlashIndex = str.indexOf("\\");
            String possibleHnr2 = null;
            String temp = null;
            if (firstSlashIndex > -1 || firstBackSlashIndex > -1) {
                if (firstSlashIndex > -1) {
                    temp = str.substring(0, firstSlashIndex + 1);
                    str.delete(0, firstSlashIndex + 1);
                }
                if (firstBackSlashIndex > -1) {
                    temp = str.substring(0, firstBackSlashIndex + 1);
                    str.delete(0, firstBackSlashIndex + 1);
                }
                if ((match = NZL_ParseMainAddressRule.checkStreetInput(houseNoPattern, str)) != null) {
                    possibleHnr2 = NZL_ParseMainAddressRule.separateHouseNumber(match, str);
                }
                String leftover = null;
                if (possibleHnr2 == null) {
                    leftover = str.toString();
                    str.delete(0, leftover.length());
                    str.append(temp).append(leftover);
                } else {
                    pa.setUnitValue(new ParsedNumber(temp.substring(0, temp.length() - 1)).getCombinedAddressNumber());
                    pa.setAddressNumber(possibleHnr2);
                }
            }
        }
        if (pa.getUnitValue() == null && pa.getAddressNumber() == null && (match = NZL_ParseMainAddressRule.checkStreetInput(hnrPattern, str)) != null && (possibleHnr = NZL_ParseMainAddressRule.separateHouseNumber(match, str)) != null) {
            int index = possibleHnr.indexOf(45);
            if (index > -1 && (possibleHnr = hypenatedPattern.matcher(possibleHnr.trim()).replaceAll("-")).charAt(possibleHnr.length() - 1) == '-') {
                String pMain = pa.getMainAddress();
                int hnrIndex = (pMain = hypenatedPattern.matcher(pMain.trim()).replaceAll("-")).indexOf(possibleHnr);
                if (hnrIndex > -1 && pMain.length() > possibleHnr.length() + 1 && NZL_AddressTerm.isAlpha(pMain.charAt(possibleHnr.length() + 1))) {
                    possibleHnr = hypenatedPattern.matcher(possibleHnr.trim()).replaceAll(" ");
                }
            }
            StringTokenizer stringTokenizer = new StringTokenizer(possibleHnr, " ");
            LinkedList listOfTokens = null;
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)stringTokenizer);
            if (listOfTokens.size() != 0) {
                if (listOfTokens.size() > 1) {
                    pa.setUnitValue(listOfTokens.get(0).toString());
                    pa.setAddressNumber(listOfTokens.get(1).toString());
                } else if (NZL_ParseMainAddressRule.isValidHouseNumber(listOfTokens.get(0).toString()) || NZL_ParseMainAddressRule.isValidHouseNumberRange(listOfTokens.get(0).toString())) {
                    pa.setAddressNumber(listOfTokens.get(0).toString());
                } else {
                    StringBuffer result = new StringBuffer(listOfTokens.get(0).toString());
                    result = result.append(" " + str);
                    return result;
                }
            }
        }
        return str;
    }

    private static String removeCareOfIndicator(String addressField) {
        Matcher matcher;
        if (addressField != null && (matcher = careOfPattern.matcher(addressField)).find()) {
            String careof = matcher.group();
            careof = careof.replaceAll("\\d+", "");
            addressField = addressField.replaceAll(careof, " ");
        }
        return addressField;
    }

    public static boolean isAlphaNumeric(String s) {
        char[] chars = s.toCharArray();
        for (int x = 0; x < chars.length; ++x) {
            char c = chars[x];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String removeCorner(String word) {
        if (word != null) {
            Matcher cornerMatcher = CornerOf_Pattern.matcher(word);
            String matchedString = "";
            if (cornerMatcher.find()) {
                matchedString = matchedString + cornerMatcher.group(3).trim();
            }
            if (matchedString != null && !matchedString.equalsIgnoreCase("")) {
                word = word.replaceFirst(matchedString, " ").trim();
                word = NZL_AddressTerm.removeExtraSpaces(word);
            }
        }
        return word;
    }

    public static String findCorner(String word) {
        Matcher cornerMatcher = CornerOf_Pattern.matcher(word);
        String matchedString = "";
        if (cornerMatcher.find()) {
            matchedString = matchedString + cornerMatcher.group();
        }
        return matchedString;
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-/&");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!NZL_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return NZL_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    public static boolean isValidHouseNumber(String hnr) {
        int hnrLen;
        int suffixStart;
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        hnr = hnr.trim();
        for (suffixStart = hnrLen = hnr.length(); suffixStart > -1 && suffixStart != 0 && Character.isLetter(hnr.charAt(suffixStart - 1)); --suffixStart) {
        }
        if (hnrLen - suffixStart > 2) {
            return false;
        }
        for (int index = 0; index < suffixStart; ++index) {
            if (Character.isDigit(hnr.charAt(index))) continue;
            return false;
        }
        if (hnrLen == 1 && !StringUtilities.isNumeric((String)hnr)) {
            return false;
        }
        int alphacount = 0;
        int digitCount = 0;
        for (int i = 0; i < hnrLen; ++i) {
            if (!NZL_AddressTerm.isAlpha(hnr.charAt(i))) {
                ++digitCount;
                continue;
            }
            ++alphacount;
        }
        return digitCount != 0;
    }

    public static void main(String[] args) {
        AddressImpl address = new AddressImpl();
        address.setMainAddress("POBOX 3-Flat 8 100 Howard Street");
        NZL_ParseMainAddressRule addressRule = new NZL_ParseMainAddressRule();
        try {
            addressRule.parse(null, (Address)address, (IConstraints)new NZL_Constraints());
            System.out.println(address);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    static {
        SPECIAL_HANDLING_PATTERN = Pattern.compile(SPECIAL_HANDLING);
        StringBuffer buf = new StringBuffer(20);
        if (NZL_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(NZL_AddressTerm.getPunctuationsAsString());
        }
        try {
            Properties properties = new Properties();
            properties.load(NZL_ParseMainAddressRule.class.getResourceAsStream("NZL_Regex.properties"));
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                keyList.add(e.nextElement());
            }
            Collections.sort(keyList);
            StringBuffer regexBuilder = new StringBuffer();
            for (String key : keyList) {
                if (!key.startsWith(POBOX)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            poBoxPattern = Pattern.compile(regexBuilder.toString(), 2);
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(SPECIAL_STREET)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            mainStreetEndingInFigurePattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(SPECIAL_NORMAL_STREET)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            mainStreetEndingInFigurePatternSpecial = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(HOUSE_NO)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            houseNoPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(FRENCH_ADDRESS)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            frenchAddressPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(DIRECTIONAL)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            directionalPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(NORMAL_HNR)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            hnrPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            for (String key : keyList) {
                if (!key.startsWith(HNR_UNIT)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            hnr_unitPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            careOfPattern = Pattern.compile(regexBuilder.toString());
            for (String key : keyList) {
                if (!key.startsWith(CARE_OF)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            careOfPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            hypenatedPattern = Pattern.compile(regexBuilder.toString());
            for (String key : keyList) {
                if (!key.startsWith(HYPENATED_NO)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            hypenatedPattern = Pattern.compile(regexBuilder.toString());
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            CornerOf_Pattern = Pattern.compile(regexBuilder.toString());
            for (String key : keyList) {
                if (!key.startsWith(CORNER_INTERSECTION)) continue;
                regexBuilder.append(properties.getProperty(key));
            }
            CornerOf_Pattern = Pattern.compile(regexBuilder.toString(), 2);
            NZL_ParseMainAddressRule.cleanBuffer(regexBuilder);
            Object var2_3 = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

