/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import java.util.Enumeration;
import java.util.Properties;

public class NZL_ProvinceAbbreviations {
    private static Properties m_provinces = null;
    private static Properties m_abbrProvinces = null;

    public static String getProvinceForAbbreviation(String abbr) {
        if (abbr == null || abbr.length() == 0) {
            return null;
        }
        return (abbr = NZL_ProvinceAbbreviations.removeDots(abbr)) == null ? null : m_abbrProvinces.getProperty(abbr);
    }

    public static String getProvinceAbbreviation(String province) {
        if (province == null) {
            return null;
        }
        province = NZL_ProvinceAbbreviations.replaceHyphensWithSpace(province.toUpperCase());
        return m_provinces.getProperty(province);
    }

    public static String removeDots(String str) {
        int len = (str = str == null ? "" : str.trim().toUpperCase()).length();
        if (len == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '.' || ch == ' ') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String getProperProvinceAbbr(String str) {
        String orgStr = str == null ? null : str.trim();
        String abbr = NZL_ProvinceAbbreviations.getProvinceAbbreviation(orgStr);
        if (abbr == null) {
            str = NZL_ProvinceAbbreviations.removeDots(orgStr);
            if ((str = NZL_ProvinceAbbreviations.getProvinceForAbbreviation(str)) != null) {
                abbr = NZL_ProvinceAbbreviations.getProvinceAbbreviation(str);
            }
        }
        return abbr;
    }

    public static boolean isAbbreviation(String prov) {
        if ((prov = NZL_ProvinceAbbreviations.removeDots(prov)) != null) {
            return m_abbrProvinces.containsKey(prov);
        }
        return false;
    }

    public static String replaceHyphensWithSpace(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        int pos = 0;
        while (pos >= 0) {
            pos = str.indexOf(45);
            if (pos < 0) continue;
            str = str.replace('-', ' ');
        }
        return str;
    }

    static {
        try {
            if (m_provinces == null) {
                m_provinces = new Properties();
                m_abbrProvinces = new Properties();
                m_provinces.load(NZL_ProvinceAbbreviations.class.getResourceAsStream("NZL_ProvinceAbbreviations.properties"));
                String province = null;
                String abbr = null;
                Enumeration<?> e = m_provinces.propertyNames();
                while (e.hasMoreElements()) {
                    abbr = (String)e.nextElement();
                    int pos = abbr.indexOf("_");
                    boolean change = true;
                    if (pos > 0) {
                        abbr = abbr.substring(0, pos);
                        change = false;
                    }
                    if ((province = m_provinces.getProperty(abbr).trim()) == null || province.length() <= 0) continue;
                    m_provinces.setProperty(province.toUpperCase(), abbr);
                    String orgProvince = m_abbrProvinces.getProperty(abbr = NZL_ProvinceAbbreviations.removeDots(abbr));
                    if (orgProvince != null && !change) continue;
                    m_abbrProvinces.setProperty(abbr, province);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for NZL_Parser.");
        }
    }
}

