/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.parser;

import com.mapinfo.mapmarker.NZL.parser.NZL_StreetNameAndType;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class NZL_ThoroughfareTypes {
    private static final Map m_lookupMaps;
    private static final String keySeparator = "+";

    private static String replaceKeySeparatorWithSpace(String type, String keySeparator) {
        if (type.indexOf(keySeparator) > -1) {
            int plus = type.indexOf(keySeparator);
            type = type.replace(type.charAt(plus), ' ').toUpperCase();
        }
        return type;
    }

    private NZL_ThoroughfareTypes() {
    }

    public static boolean isStreetType(String aTerm) {
        return aTerm != null && m_lookupMaps.containsKey(aTerm.toUpperCase());
    }

    public static NZL_StreetNameAndType separateStreet(String streetName) {
        if (streetName == null) {
            return new NZL_StreetNameAndType(null, null);
        }
        if ((streetName = streetName.trim()).length() == 0) {
            return new NZL_StreetNameAndType(null, null);
        }
        String streetNamePart = null;
        String streetTypePart = NZL_ThoroughfareTypes.findStreetType(streetName);
        if (streetTypePart != null) {
            int typeLen;
            int nameLen = streetName.length();
            if (nameLen > (typeLen = streetTypePart.length())) {
                int separatorPos = nameLen - typeLen;
                streetNamePart = streetName.substring(0, separatorPos);
                streetTypePart = streetName.substring(separatorPos, nameLen);
            } else {
                streetTypePart = streetName.substring(0, nameLen);
            }
        } else {
            streetNamePart = streetName;
        }
        return new NZL_StreetNameAndType(streetNamePart, streetTypePart);
    }

    public static String findStreetType(String str) {
        String string = str = str == null ? "" : str.trim().toUpperCase();
        if (str.length() == 0) {
            return null;
        }
        Iterator it = m_lookupMaps.keySet().iterator();
        String type = null;
        String possibleType = null;
        while (it.hasNext()) {
            String strTypeVariation = (String)it.next();
            if (!str.endsWith(strTypeVariation)) continue;
            if (strTypeVariation.equalsIgnoreCase("str") || strTypeVariation.equalsIgnoreCase("straat") || strTypeVariation.equalsIgnoreCase("weg") || strTypeVariation.equalsIgnoreCase("wg")) {
                possibleType = strTypeVariation;
                continue;
            }
            type = strTypeVariation;
            break;
        }
        if (type == null) {
            type = possibleType;
        }
        return type;
    }

    public static NZL_ThoroughfareType getThoroughfareType(String name) {
        if (name == null) {
            return null;
        }
        return (NZL_ThoroughfareType)m_lookupMaps.get(name.trim().toUpperCase());
    }

    public static boolean containsStreetType(String str) {
        return NZL_ThoroughfareTypes.findStreetType(str) != null;
    }

    static {
        HashMap keys = new HashMap();
        m_lookupMaps = new HashMap();
        try {
            Properties streetTypes = new Properties();
            streetTypes.load(NZL_ThoroughfareTypes.class.getResourceAsStream("NZL_ThoroughfareTypes.properties"));
            Enumeration<?> e = streetTypes.propertyNames();
            while (e.hasMoreElements()) {
                String type = (String)e.nextElement();
                String val = streetTypes.getProperty(type);
                type = NZL_ThoroughfareTypes.replaceKeySeparatorWithSpace(type, keySeparator);
                StringTokenizer tokens = new StringTokenizer(val, ",");
                String properType = tokens.nextToken();
                String expandedType = tokens.nextToken();
                boolean canStart = Boolean.valueOf(tokens.nextToken());
                boolean canEnd = Boolean.valueOf(tokens.nextToken());
                NZL_ThoroughfareType keyInfo = new NZL_ThoroughfareType(type, properType, expandedType, canStart, canEnd);
                m_lookupMaps.put(type, keyInfo);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load required files for NZL_Parser.", ex);
        }
    }

    public static class NZL_ThoroughfareType {
        private String m_typeName;
        private String m_expandedType;
        private String m_properType;
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        private NZL_ThoroughfareType(String typeName, String properType, String expandedType, boolean canStart, boolean canEnd) {
            this.m_typeName = typeName;
            this.m_properType = properType;
            this.m_expandedType = expandedType;
            this.m_canStart = canStart;
            this.m_canEnd = canEnd;
        }

        public String getTypeName() {
            return this.m_typeName;
        }

        public String getExpandedTypeName() {
            return this.m_expandedType;
        }

        public String getProperTypeName() {
            return this.m_properType;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }
    }
}

