/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NZL.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class NZL_NoNumericInAN4Rule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasNumeric1 = this.hasNumericAN4(o1);
        boolean hasNumeric2 = this.hasNumericAN4(o2);
        if (hasNumeric1 && !hasNumeric2) {
            return 1;
        }
        if (!hasNumeric1 && hasNumeric2) {
            return -1;
        }
        return 0;
    }

    private boolean hasNumericAN4(IAddressParsing parsing) {
        Address[] parseResult = parsing.getParse();
        if (parseResult.length > 0) {
            String an4 = parseResult[0].getAreaName4();
            return an4 != null && StringUtilities.hasNumeric((String)an4);
        }
        return false;
    }
}

