/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.SWE.SWE_Geocoder;
import com.mapinfo.mapmarker.SWE.SWE_Handler;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_DataManager;
import com.mapinfo.mapmarker.SWE.singleline.SWESingleLineParser;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;

public class SWEGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        SWEGeocodingFactory geocodingFactory = new SWEGeocodingFactory();
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)geocodingFactory, (ISingleLineParser)new SWESingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            SWE_DataManager data = new SWE_DataManager();
            data.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    private static class SWEGeocodingFactory
    implements IGeocoderFactory {
        private SWEGeocodingFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            return new SWE_Geocoder(SWE_Handler.buildHandler(address));
        }
    }
}

