/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.SWE.parser.SWE_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SWE_AddressUtils {
    private static final Map<String, String> sharedStreetTypeAbbreviations;
    private static final Map<String, String> commonAbbreviations;
    private static final Map<String, String> secondaryAbbreviations;
    private static final Map<String, String> directionalMap;

    private SWE_AddressUtils() {
    }

    public static String expandAbbreviations(String input) {
        return SWE_AddressUtils.expandAbbreviations(input, false);
    }

    public static String expandAbbreviations(String input, boolean bUseAlternates) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, " ");
        StringBuilder expanded = new StringBuilder(input.length());
        Set<String> keys = commonAbbreviations.keySet();
        Set<String> altKeys = secondaryAbbreviations.keySet();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String upper = token.toUpperCase();
            if (expanded.length() != 0) {
                expanded.append(' ');
            }
            if (bUseAlternates && altKeys.contains(upper)) {
                expanded.append(secondaryAbbreviations.get(upper));
                continue;
            }
            if (keys.contains(upper)) {
                expanded.append(commonAbbreviations.get(upper));
                continue;
            }
            expanded.append(token);
        }
        return expanded.toString();
    }

    public static String expandToken(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return input;
        }
        String upper = input.toUpperCase();
        if (commonAbbreviations.containsKey(upper)) {
            return commonAbbreviations.get(upper);
        }
        return input;
    }

    public static String getFormattedStreetAddressWithoutSpaces(Address addr, boolean bAppendAddressNumber) {
        String addrNum;
        String postAddr;
        String postTT;
        StringBuffer buf = new StringBuffer(100);
        String newMainAddress = addr.getMainAddress();
        if (newMainAddress != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress.trim());
        }
        if ((postTT = addr.getPostThoroughfareType()) != null && postTT.length() != 0) {
            buf.append(postTT.trim());
        }
        if ((postAddr = addr.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr.trim());
        }
        if (bAppendAddressNumber && (addrNum = addr.getAddressNumber()) != null && addrNum.length() != 0) {
            buf.append(addrNum.trim());
        }
        return buf.toString().trim();
    }

    public static String adjustPostCodeFormatting(String formattedString, String postCode1) {
        if (postCode1 == null || formattedString == null || postCode1.length() != 5) {
            return formattedString;
        }
        StringBuilder sb = new StringBuilder(formattedString);
        int idx = sb.indexOf(postCode1);
        if (idx >= 0) {
            sb.insert(idx + 3, ' ');
            return sb.toString();
        }
        return formattedString;
    }

    public static String uppercase(String input) {
        if (input == null) {
            return input;
        }
        return input.toUpperCase();
    }

    public static boolean isDirectional(String token) {
        return token != null && directionalMap.containsKey(token);
    }

    public static String expandDirectional(String token) {
        if (token == null) {
            return null;
        }
        return directionalMap.get(token);
    }

    public static boolean isSharedStreetTypes(String type1, String type2) {
        String abbr1 = sharedStreetTypeAbbreviations.get(SWE_ThoroughfareTypes.lookupPreferredName(type1));
        String abbr2 = sharedStreetTypeAbbreviations.get(SWE_ThoroughfareTypes.lookupPreferredName(type2));
        return abbr1 != null && abbr2 != null && abbr1.equals(abbr2);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("N:A", "NORRA");
        tmp.put("N.", "NORRA");
        tmp.put("N", "NORRA");
        tmp.put("NORRA", "NORRA");
        tmp.put("S:A", "S\u00d6DRA");
        tmp.put("S", "S\u00d6DRA");
        tmp.put("S.", "S\u00d6DRA");
        tmp.put("S\u00d6DRA", "S\u00d6DRA");
        tmp.put("SODRA", "S\u00d6DRA");
        tmp.put("O:A", "\u00d6STRA");
        tmp.put("\u00d6:A", "\u00d6STRA");
        tmp.put("\u00d6", "\u00d6STRA");
        tmp.put("O", "\u00d6STRA");
        tmp.put("\u00d6.", "\u00d6STRA");
        tmp.put("O.", "\u00d6STRA");
        tmp.put("OSTRA", "\u00d6STRA");
        tmp.put("\u00d6STRA", "\u00d6STRA");
        tmp.put("V:A", "V\u00c4STRA");
        tmp.put("V", "V\u00c4STRA");
        tmp.put("V.", "V\u00c4STRA");
        tmp.put("VASTRA", "V\u00c4STRA");
        tmp.put("V\u00c4STRA", "V\u00c4STRA");
        tmp.put("NV", "NORDV\u00c4STRA");
        tmp.put("NV.", "NORDV\u00c4STRA");
        tmp.put("NORDV\u00c4STRA", "NORDV\u00c4STRA");
        tmp.put("NORDVASTRA", "NORDV\u00c4STRA");
        tmp.put("NORD\u00d6STRA", "NORD\u00d6STRA");
        tmp.put("NORDOSTRA", "NORD\u00d6STRA");
        tmp.put("N\u00d6", "NORD\u00d6STRA");
        tmp.put("NO", "NORD\u00d6STRA");
        tmp.put("N\u00d6.", "NORD\u00d6STRA");
        tmp.put("NO.", "NORD\u00d6STRA");
        tmp.put("SV", "SYDV\u00c4STRA");
        tmp.put("SV.", "SYDV\u00c4STRA");
        tmp.put("SYDV\u00c4STRA", "SYDV\u00c4STRA");
        tmp.put("SYDVASTRA", "SYDV\u00c4STRA");
        tmp.put("S\u00d6", "SYD\u00d6STRA");
        tmp.put("SO", "SYD\u00d6STRA");
        tmp.put("S\u00d6.", "SYD\u00d6STRA");
        tmp.put("SO.", "SYD\u00d6STRA");
        tmp.put("SYD\u00d6STRA", "SYD\u00d6STRA");
        tmp.put("SYDOSTRA", "SYD\u00d6STRA");
        directionalMap = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.putAll(directionalMap);
        tmp.put("L:A", "Lilla".toUpperCase());
        tmp.put("G:A", "Gamla".toUpperCase());
        tmp.put("S:T", "Sankt".toUpperCase());
        tmp.put("DR", "Doktor".toUpperCase());
        tmp.put("EV", "EUROPAV\u00c4G");
        tmp.put("E", "EUROPAV\u00c4G");
        tmp.put("L", "Lilla".toUpperCase());
        tmp.put("L.", "Lilla".toUpperCase());
        tmp.put("RV", "RIKSV\u00c4G");
        tmp.put("LV", "L\u00c4NSV\u00c4G");
        tmp.put("STHLM", "STOCKHOLM");
        tmp.put("GBG", "G\u00d6TEBORG");
        tmp.put("1:A", "F\u00d6RSTA");
        tmp.put("2:A", "ANDRA");
        tmp.put("3:E", "TREDJE");
        tmp.put("4:E", "FJ\u00c4RDE");
        tmp.put("5:E", "FEMTE");
        tmp.put("6:E", "SJ\u00c4TTE");
        tmp.put("7:E", "SJUNDE");
        tmp.put("8:E", "\u00c5TTONDE");
        tmp.put("9:E", "NIONDE");
        tmp.put("10:E", "TIONDE");
        tmp.put("ST", "SANKT");
        tmp.put("ST.", "SANKT");
        tmp.put("\u00d6V", "\u00d6VRE");
        tmp.put("OV", "\u00d6VRE");
        tmp.put("\u00d6V.", "\u00d6VRE");
        tmp.put("OV.", "\u00d6VRE");
        tmp.put("ND", "NEDRE");
        tmp.put("ND.", "NEDRE");
        tmp.put("H", "H\u00d6GA");
        tmp.put("H.", "H\u00d6GA");
        tmp.put("STHLM", "STOCKHOLM");
        tmp.put("GBG", "G\u00d6TEBORG");
        commonAbbreviations = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("BACKE", "B");
        tmp.put("BACKEN", "B");
        tmp.put("GATA", "G");
        tmp.put("GATAN", "G");
        tmp.put("GR\u00c4ND", "GR");
        tmp.put("GR\u00c4NDEN", "GR");
        tmp.put("PARK", "P");
        tmp.put("PARKEN", "P");
        tmp.put("PLAN", "PL");
        tmp.put("PLANEN", "PL");
        tmp.put("PLATS", "PL");
        tmp.put("PLATSEN", "PL");
        tmp.put("SLINGA", "SL");
        tmp.put("SLINGAN", "SL");
        tmp.put("STRAND", "STR");
        tmp.put("STRANDEN", "STR");
        tmp.put("TRAPPA", "TR");
        tmp.put("TRAPPAN", "TR");
        tmp.put("V\u00c4G", "V");
        tmp.put("V\u00c4GEN", "V");
        sharedStreetTypeAbbreviations = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("SV", "SVENSKA");
        tmp.put("SV.", "SVENSKA");
        tmp.put("ST", "STORA");
        tmp.put("ST.", "STORA");
        tmp.put("O", "\u00d6VRE");
        tmp.put("O.", "\u00d6VRE");
        tmp.put("\u00d6", "\u00d6VRE");
        tmp.put("\u00d6.", "\u00d6VRE");
        tmp.put("N", "NEDRE");
        tmp.put("N.", "NEDRE");
        secondaryAbbreviations = Collections.unmodifiableMap(tmp);
    }
}

