/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class SWE_InternalBrowseAddress
extends InternalBrowseAddress {
    private StreetBasedIdentifier m_identifier = null;
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";

    public SWE_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        Segment segment = this.getSegmentAt(0);
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName2(this.getAreaName2());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        candidate.setPostCode1(segment.getLeftPostCode1());
        String postcode = candidate.getPostCode1();
        candidate.setPostCode1(SWE_AddressUtils.adjustPostCodeFormatting(postcode, postcode));
        if (candidate.getGenericField4() != null) {
            candidate.setMainAddress(candidate.getGenericField4());
        }
        candidate.setAdditionalFields(null);
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        return candidate;
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    protected String getFormattedStreetAddress() {
        String postAddr;
        String postTT;
        String postStrTypeSep;
        String newMainAddress;
        HashMap fields = this.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String preDir = this.getPreDirectional();
        if (!StringUtilities.isEmpty((String)preDir)) {
            buf.append(preDir);
            buf.append(' ');
        }
        if ((newMainAddress = this.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress);
        }
        if ((postStrTypeSep = (String)fields.get("POST_STREET_TYPE_SEPARATOR")) != null && buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postTT = this.getPostThoroughfareType()) != null && postTT.length() != 0) {
            buf.append(postTT);
        }
        if (buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postAddr = this.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (this.getGenericField4() != null) {
            return this.getGenericField4();
        }
        return buf.toString().trim();
    }

    public String getAreaName1() {
        String areaName = super.getAreaName1();
        if (areaName == null && this.getSegmentCount() > 0) {
            String right;
            Segment segment = this.getSegmentAt(0);
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName1();
            }
            String left = segment.getLeftAreaName1();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName1()))) {
                return left;
            }
        }
        return areaName;
    }

    public String getAreaName2() {
        String areaName = super.getAreaName2();
        if (areaName == null && this.getSegmentCount() > 0) {
            String right;
            Segment segment = this.getSegmentAt(0);
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName2();
            }
            String left = segment.getLeftAreaName2();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName2()))) {
                return left;
            }
        }
        return areaName;
    }

    public String getAreaName3() {
        String areaName = super.getAreaName3();
        if (areaName == null && this.getSegmentCount() > 0) {
            String right;
            Segment segment = this.getSegmentAt(0);
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName3();
            }
            String left = segment.getLeftAreaName3();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName3()))) {
                return left;
            }
        }
        return areaName;
    }

    public String getAreaName4() {
        String areaName = super.getAreaName4();
        if (areaName == null && this.getSegmentCount() > 0) {
            String right;
            Segment segment = this.getSegmentAt(0);
            GeoInfoRecord geoInfoRecord = segment.getGeoInfoRecord();
            if (geoInfoRecord != null) {
                return geoInfoRecord.getAreaName4();
            }
            String left = segment.getLeftAreaName4();
            if (StringUtilities.equalStrings((String)left, (String)(right = segment.getRightAreaName4()))) {
                return left;
            }
        }
        return areaName;
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

