/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.HashMap;

public class SWE_InternalIntersectionCandidateAddress
extends InternalIntersectionCandidateAddress {
    public SWE_InternalIntersectionCandidateAddress(InternalCandidateAddress address1, InternalCandidateAddress address2) {
        super(address1, address2);
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress returnCandidate = this.superToCandidateAddress(input, constraints);
        return returnCandidate;
    }

    public CandidateAddress superToCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        if (!this.isCloseMatch()) {
            return null;
        }
        InternalCandidateAddress interCand1 = this.getCandidate1();
        InternalCandidateAddress interCand2 = this.getCandidate2();
        Address[] addrs = constraints.getHandler().getParsedAddressArray();
        CandidateAddress cand1 = interCand1.toCandidateAddress(addrs[0], constraints);
        CandidateAddress cand2 = interCand2.toCandidateAddress(addrs[1], constraints);
        CandidateAddress returnCandidate = new CandidateAddress();
        returnCandidate.setAreaName1(cand1.getAreaName1());
        returnCandidate.setAreaName2(cand1.getAreaName2());
        returnCandidate.setAreaName3(cand1.getAreaName3());
        returnCandidate.setAreaName4(cand1.getAreaName4());
        returnCandidate.setGenericField2(cand1.getGenericField2());
        returnCandidate.setPostCode1(cand1.getPostCode1());
        returnCandidate.setPostCode2(cand1.getPostCode2());
        returnCandidate.setCountry(cand1.getCountry());
        if (cand1.doesPostalCode1Match() && cand2.doesPostalCode1Match()) {
            returnCandidate.setPostalCode1Matched();
        }
        if (cand1.doesPostalCode2Match() && cand2.doesPostalCode2Match()) {
            returnCandidate.setPostalCode2Matched();
        }
        if (cand1.doesAreaName1Match() && cand2.doesAreaName1Match()) {
            returnCandidate.setAreaName1Matched();
        }
        if (cand1.doesAreaName2Match() && cand2.doesAreaName2Match()) {
            returnCandidate.setAreaName2Matched();
        }
        if (cand1.doesAreaName3Match() && cand2.doesAreaName3Match()) {
            returnCandidate.setAreaName3Matched();
        }
        if (cand1.doesAreaName4Match() && cand2.doesAreaName4Match()) {
            returnCandidate.setAreaName4Matched();
        }
        if (cand1.doesCountryMatch() && cand2.doesCountryMatch()) {
            returnCandidate.setCountryMatched();
        }
        String street1HN = this.getApproximateHouseNumberforStreet1();
        String street2HN = this.getApproximateHouseNumberforStreet2();
        if (street1HN != null) {
            interCand1.setAddressNumber(street1HN);
        }
        if (street2HN != null) {
            interCand2.setAddressNumber(street2HN);
        }
        returnCandidate.setFormattedStreetAddress(interCand1.getFormattedStreetAddress() + " && " + interCand2.getFormattedStreetAddress());
        returnCandidate.setFormattedLocationAddress(interCand1.getFormattedLocationAddress());
        returnCandidate.setMainAddress(returnCandidate.getFormattedStreetAddress());
        if (cand1.doesStreetNameMatch() && cand2.doesStreetNameMatch()) {
            returnCandidate.setStreetNameMatched();
        }
        if (cand1.doesThoroughfareTypeMatch() && cand1.doesThoroughfareTypeMatch()) {
            returnCandidate.setThoroughfareTypeMatched();
        }
        if (cand1.doesPreDirectionalMatch() && cand2.doesPreDirectionalMatch()) {
            returnCandidate.setPreDirectionalMatched();
        }
        if (cand1.doesPostDirectionalMatch() && cand2.doesPostDirectionalMatch()) {
            returnCandidate.setPostDirectionalMatched();
        }
        returnCandidate.setCloseMatch();
        DirectPosition location = this.getIntersectionPoint();
        returnCandidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)constraints.getClientCoordinateSystemObject(), (DirectPosition)location));
        returnCandidate.setLocationPrecision(6);
        returnCandidate.setCoordSysString(interCand1.getSegment().getCoordSysInfo());
        String csys = returnCandidate.getCoordSysString();
        if (csys == null && constraints.getClientCoordinateSystem() != null) {
            csys = constraints.getClientCoordinateSystem().getSrsName();
            returnCandidate.setCoordSysString(csys);
        }
        if (interCand1.fromUserDictionary() || interCand2.fromUserDictionary()) {
            returnCandidate.setFromUserDictionary();
        }
        HashMap fields = returnCandidate.getAdditionalFields();
        fields.put(CandidateAddress.INTERSECTION_OUTPUT_STRING, returnCandidate.getFormattedStreetAddress());
        String geores = this.buildPrecisionCode(returnCandidate);
        returnCandidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        returnCandidate.addKeyValueToAdditionalFields("StreetDataType", this.m_candidate1.getVendorCode());
        return returnCandidate;
    }
}

