/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;

public class SWE_InternalPostalCandidate
extends InternalPostalCandidate {
    public void scorePostCode1(Address input) {
        super.scorePostCode1(input);
        if (this.getPostCode1Score() != 1.0) {
            String candPostCode = this.getPostCode1();
            String parsedPostCode = input.getPostCode1();
            if (candPostCode.length() == 3 && parsedPostCode != null && parsedPostCode.startsWith(candPostCode)) {
                this.setPostCode1Score(0.9);
            }
        }
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        candidate.setPostCode1(SWE_AddressUtils.adjustPostCodeFormatting(candidate.getPostCode1(), candidate.getPostCode1()));
        return candidate;
    }

    public int compareTo(Object o) {
        int result = super.compareTo(o);
        if (result == 0) {
            InternalPostalCandidate that = (InternalPostalCandidate)o;
            if (this.getUserDictionaryPriority() == that.getUserDictionaryPriority()) {
                return 0;
            }
            if (this.getUserDictionaryPriority() < that.getUserDictionaryPriority()) {
                return 1;
            }
            return -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.getUserDictionaryPriority() == ((InternalPostalCandidate)o).getUserDictionaryPriority();
    }
}

