/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.CoreMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;

public final class SWE_MatcherHandler
extends CoreMatcherHandler {
    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants matcherConstants, ScoringAddress scoringAddress) throws MatcherException {
        if (candidate.isPointHouseCandidate(null) && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)candidate.getAddressNumber()) && !candidate.isHouseNumberFromPlaceMatch()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPostAddressScore() != 1.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() < matcherConstants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() > 0.9) {
            if (candidate.getCombinedAdditionalFieldScore() < matcherConstants.getAdditionalFieldsCutOff() - 0.01) {
                candidate.setCloseMatchFlag(false);
                return;
            }
        } else if (candidate.getCombinedAdditionalFieldScore() < matcherConstants.getAdditionalFieldsCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (StringUtilities.equalStrings((String)"CENTRUM", (String)candidate.getMainAddress()) && candidate.getAreaName3Score() < 0.7) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() - 0.025 < matcherConstants.getCloseMatchCutOff() && candidate.getPostThoroughfareTypeScore() == 0.0 && !StringUtilities.isEmpty((String)candidate.getPostThoroughfareType()) && StringUtilities.isEmpty((String)scoringAddress.getPostThoroughfareType())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (StringUtilities.equalStrings((String)"CENTRUM", (String)scoringAddress.getPostThoroughfareType()) && !StringUtilities.equalStrings((String)"CENTRUM", (String)candidate.getPostThoroughfareType())) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        if (!StringUtilities.equalStrings((String)best.getPostCode1(), (String)other.getPostCode1())) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3())) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getAreaName4(), (String)other.getAreaName4())) {
            return false;
        }
        return StringUtilities.equalStrings((String)best.getPlaceName(), (String)other.getPlaceName());
    }
}

