/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.parser.SWE_ParseMainAddressRule;
import com.mapinfo.mapmarker.SWE.parser.SWE_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class SWE_StreetSingleAddressGeocoder
implements IStreetSingleAddressGeocoder {
    protected IStreetSingleAddressGeocoder m_coreStreetSingleAddressGeocoder;
    protected CoreHandler m_handler;
    protected IScoringHelper m_scoringHandler;
    protected SWE_ParseMainAddressRule m_mainAddressParserRule = new SWE_ParseMainAddressRule();
    private int m_currentCase = 0;
    private boolean resetParsedAddress;
    private Address savedParsedAddress;
    protected static final String TOKENIZERS = "- ,/";
    protected static final Set<String> commonDirectionals;

    public SWE_StreetSingleAddressGeocoder(IHandler handler) {
        this.m_coreStreetSingleAddressGeocoder = new CoreStreetSingleAddressGeocoder();
        this.m_handler = (CoreHandler)handler;
        this.m_scoringHandler = ((ICoreStreetGeocoder)handler).getScoringHelper();
        if (this.m_scoringHandler == null) {
            // empty if block
        }
        this.m_currentCase = 0;
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        boolean tryAgain = true;
        if (!this.resetParsedAddress) {
            this.savedParsedAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        } else {
            this.setParsedAddress((Address)new AddressImpl(this.savedParsedAddress));
            this.resetParsedAddress = false;
        }
        Address pa = constraints.getHandler().getParsedAddress();
        String city = pa.getAreaName3();
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                this.setSearchParsedAddress(pa);
                this.setParsedAddress(pa);
                this.resetParsedAddress = true;
                constraints.setCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL", "false");
                break;
            }
            case 1: {
                ++this.m_currentCase;
                Object test = pa.getAdditionalFields().get("street_suffix");
                if (test != null) {
                    pa.getAdditionalFields().remove("street_suffix");
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 2: {
                String alt;
                String main;
                ++this.m_currentCase;
                if (pa.hasAdditionalFields() && pa.getAdditionalFields().containsKey("KEY_ORIG_MAIN") && !StringUtilities.equalStrings((String)(main = (String)pa.getAdditionalFields().get("KEY_ORIG_MAIN")), (String)(alt = SWE_AddressUtils.expandAbbreviations(main, true)))) {
                    pa.setMainAddress(alt);
                    pa.setPostThoroughfareType(null);
                    pa.setAddressNumber((String)null);
                    pa.setPreDirectional(null);
                    this.m_mainAddressParserRule.parse(pa, pa, constraints);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                StringTokenizer st;
                ++this.m_currentCase;
                String main = pa.getMainAddress();
                if (main != null && (st = new StringTokenizer(main, TOKENIZERS)).countTokens() > 1) {
                    String token = st.nextToken();
                    String test = main.substring(token.length() + 1);
                    pa.setMainAddress(test);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 4: {
                ++this.m_currentCase;
                Object test = (String)pa.getAdditionalFields().get("street_suffix");
                if (test != null) {
                    pa.getAdditionalFields().remove("street_suffix");
                    pa.setPostThoroughfareType(null);
                    pa.setMainAddress(test);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 5: {
                ++this.m_currentCase;
                Object test = (String)pa.getAdditionalFields().get("street_suffix");
                if (test != null) {
                    pa.getAdditionalFields().remove("street_suffix");
                    pa.setPostThoroughfareType(null);
                    test = this.checkTypes((String)test, pa);
                    pa.setMainAddress(test);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 6: {
                StringTokenizer st;
                ++this.m_currentCase;
                String main = pa.getMainAddress();
                if (main != null && (st = new StringTokenizer(main, TOKENIZERS)).countTokens() > 2) {
                    st.nextToken();
                    st.nextToken();
                    StringBuilder sb = new StringBuilder(main.length());
                    while (st.hasMoreTokens()) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(st.nextToken());
                    }
                    pa.setMainAddress(sb.toString());
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 7: {
                StringTokenizer st;
                ++this.m_currentCase;
                String main = pa.getMainAddress();
                if (main != null && (st = new StringTokenizer(main, TOKENIZERS)).countTokens() > 1) {
                    StringBuilder sb = new StringBuilder(main.length());
                    int sz = st.countTokens();
                    for (int i = 0; i < sz - 1; ++i) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(st.nextToken());
                    }
                    pa.setPostThoroughfareType(null);
                    String test = sb.toString();
                    test = this.checkTypes(test, pa);
                    pa.setMainAddress(test);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    break;
                }
            }
            case 8: {
                int idx;
                ++this.m_currentCase;
                int n = idx = city == null ? -1 : city.indexOf(32);
                if (idx > 0) {
                    if (pa.getAreaName1() == null) {
                        pa.setAreaName1(city.substring(idx).trim());
                    } else if (pa.getAreaName2() == null) {
                        pa.setAreaName2(city.substring(idx).trim());
                    } else if (pa.getAreaName4() == null) {
                        pa.setAreaName4(city.substring(idx).trim());
                    }
                    pa.setAreaName3(city.substring(0, idx));
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    this.resetParsedAddress = true;
                    break;
                }
            }
            case 9: {
                int idx;
                ++this.m_currentCase;
                int n = idx = city == null ? -1 : city.indexOf(32);
                if (idx > 0) {
                    if (pa.getAreaName1() == null) {
                        pa.setAreaName1(city.substring(0, idx).trim());
                    } else if (pa.getAreaName2() == null) {
                        pa.setAreaName2(city.substring(0, idx).trim());
                    } else if (pa.getAreaName4() == null) {
                        pa.setAreaName4(city.substring(0, idx).trim());
                    }
                    pa.setAreaName3(city.substring(idx).trim());
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    this.resetParsedAddress = true;
                    break;
                }
            }
            case 10: {
                ++this.m_currentCase;
                if (city == null && !StringUtilities.isEmpty((String)pa.getAreaName4())) {
                    pa.setAreaName3(pa.getAreaName4());
                    pa.setAreaName4(null);
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    this.resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 11: {
                ++this.m_currentCase;
                String main = pa.getMainAddress();
                if (main != null && !main.endsWith("S")) {
                    String test = main + "S";
                    pa.setMainAddress(test);
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    tryAgain = true;
                    break;
                }
            }
            case 12: {
                int start;
                ++this.m_currentCase;
                String main = pa.getMainAddress();
                if (main != null && (start = this.findDirectionalIndex(main)) > 0) {
                    pa.setMainAddress(main.substring(start));
                    pa.setPreDirectional(main.substring(0, start));
                    this.resetParsedAddress = true;
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    tryAgain = true;
                    break;
                }
            }
            default: {
                tryAgain = false;
            }
        }
        return tryAgain;
    }

    public void combineCandidateLists(List savedCandidates, List newCandidates) {
        this.m_coreStreetSingleAddressGeocoder.combineCandidateLists(savedCandidates, newCandidates);
    }

    public void removeDuplicateCandidates(List candidates) {
        this.m_coreStreetSingleAddressGeocoder.removeDuplicateCandidates(candidates);
    }

    protected void setSearchParsedAddress(Address pa) {
        this.m_handler.setSearchParsedAddress(pa);
    }

    protected void setParsedAddress(Address pa) {
        this.m_handler.setParsedAddress(pa);
    }

    protected String checkTypes(String test, Address pa) {
        int len = test.length();
        if (len > 2) {
            String attachedType = SWE_ThoroughfareTypes.findAttachedType(test);
            if (attachedType != null) {
                pa.setPostThoroughfareType(attachedType);
                test = test.substring(0, len - attachedType.length());
            } else {
                switch (test.charAt(test.length() - 1)) {
                    case 'G': {
                        pa.setPostThoroughfareType("GATAN");
                        test = test.substring(0, test.length() - 1);
                        break;
                    }
                    case 'V': {
                        pa.setPostThoroughfareType("VAGEN");
                        test = test.substring(0, test.length() - 1);
                        break;
                    }
                }
            }
        }
        return test;
    }

    protected int findDirectionalIndex(String mainaddr) {
        if (!StringUtilities.isEmpty((String)mainaddr) && mainaddr.length() > 5) {
            for (String check : commonDirectionals) {
                if (!mainaddr.startsWith(check)) continue;
                return check.length();
            }
        }
        return -1;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("NORRA");
        tmp.add("SODRA");
        tmp.add("OSTRA");
        tmp.add("VASTRA");
        tmp.add("S\u00d6DRA");
        tmp.add("\u00d6STRA");
        tmp.add("V\u00c4STRA");
        commonDirectionals = Collections.unmodifiableSet(tmp);
    }
}

