/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp;

import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.SWE.parser.SWE_AddressTerm;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashSet;
import java.util.Properties;

public class SWE_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    public SWE_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        HashSet<MiSoundexGeoBase> baseHolder = new HashSet<MiSoundexGeoBase>();
        if (input.hasAreaName4()) {
            if (input.hasAreaName4()) {
                this.makeGeoBasesForArea(input.getAreaName4(), baseHolder);
            }
            if (input.hasAlternateAreaName4()) {
                this.makeGeoBasesForArea(input.getAlternateAreaName4(), baseHolder);
            }
        } else {
            if (input.hasAreaName3()) {
                this.makeGeoBasesForArea(input.getAreaName3(), baseHolder);
            }
            if (input.hasAlternateAreaName3()) {
                for (String alternate : this.splitAlternates(input.getAlternateAreaName3())) {
                    this.makeGeoBasesForArea(alternate, baseHolder);
                }
            }
        }
        if (baseHolder.size() > 0) {
            return (IGeoBase[])baseHolder.toArray(new MiSoundexGeoBase[baseHolder.size()]);
        }
        return null;
    }

    private void makeGeoBasesForArea(String areaname, HashSet<MiSoundexGeoBase> bases) throws DataSourceException {
        if (StringUtilities.isEmpty((String)areaname)) {
            return;
        }
        String shortVersion = SWE_AddressTerm.removeCommonTerms(areaname = areaname.toUpperCase());
        if (shortVersion == null) {
            shortVersion = areaname;
        }
        bases.add(new MiSoundexGeoBase((MiSoundexKey)this.makeSoundexKey(areaname)));
        bases.add(new MiSoundexGeoBase(this.getStringKey(areaname)));
        bases.add(new MiSoundexGeoBase((MiSoundexKey)this.makeSoundexKey(shortVersion)));
        bases.add(new MiSoundexGeoBase(this.getStringKey(shortVersion)));
    }

    private MiSoundexKey getStringKey(String str) {
        SWELanguageSoundex cfr_ignored_0 = (SWELanguageSoundex)this.m_soundex;
        return (MiSoundexKey)SWELanguageSoundex.getStringKey(str);
    }

    private String[] splitAlternates(String originalValue) {
        if (StringUtilities.isEmpty((String)originalValue)) {
            return new String[0];
        }
        return originalValue.split("/");
    }
}

