/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp;

import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class SWE_GeoInfoDataSourceRecordConvertorImpl
extends GeoInfoDataSourceRecordConvertorImpl {
    public SWE_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    protected GeoInfoRecord makeGeoInfoRecordType() {
        return new SWE_GeoInfoRecord();
    }

    protected GeoInfoRecord makeGeoInfoRecord(IGeoInfoDataSourceRecord input) throws DataSourceException {
        String alts;
        SWE_GeoInfoRecord record = (SWE_GeoInfoRecord)super.makeGeoInfoRecord(input);
        this.uppercaseData(record);
        if (!StringUtilities.isEmpty((String)record.getAreaName4())) {
            record.setPrecision((byte)11);
        } else if (!StringUtilities.isEmpty((String)record.getAreaName3())) {
            record.setPrecision((byte)10);
        } else if (!StringUtilities.isEmpty((String)record.getAreaName2())) {
            record.setPrecision((byte)9);
        } else {
            record.setPrecision((byte)8);
        }
        if (input.hasPrecision() && input.getPrecision() == 0) {
            record.setPrecision((byte)0);
        }
        if ((alts = record.getAltAreaName1()) != null) {
            record.setAltAreaName1Array(this.splitAltAreaNames(alts));
            record.setAltAreaName1(null);
        }
        if ((alts = record.getAltAreaName2()) != null) {
            record.setAltAreaName2Array(this.splitAltAreaNames(alts));
            record.setAltAreaName2(null);
        }
        if ((alts = record.getAltAreaName3()) != null) {
            record.setAltAreaName3Array(this.splitAltAreaNames(alts));
            record.setAltAreaName3(null);
        }
        if ((alts = record.getAltAreaName4()) != null) {
            record.setAltAreaName4Array(this.splitAltAreaNames(alts));
            record.setAltAreaName4(null);
        }
        return record;
    }

    protected MapMarkerIndexKey makeGeoInfoKey(GeoInfoRecord record) {
        MiStringIndexKey key = new MiStringIndexKey((record.getAreaName1() != null ? record.getAreaName1() : "") + (record.getAreaName2() != null ? record.getAreaName2() : "") + (record.getAreaName3() != null ? record.getAreaName3() : "") + (record.getAreaName4() != null ? record.getAreaName4() : ""));
        return key;
    }

    protected void uppercaseData(GeoInfoRecord record) {
        if (record == null) {
            return;
        }
        record.setAreaName1(SWE_AddressUtils.uppercase(record.getAreaName1()));
        record.setAreaName2(SWE_AddressUtils.uppercase(record.getAreaName2()));
        record.setAreaName3(SWE_AddressUtils.uppercase(record.getAreaName3()));
        record.setAreaName4(SWE_AddressUtils.uppercase(record.getAreaName4()));
        record.setAltAreaName1(SWE_AddressUtils.uppercase(record.getAltAreaName1()));
        record.setAltAreaName2(SWE_AddressUtils.uppercase(record.getAltAreaName2()));
        record.setAltAreaName3(SWE_AddressUtils.uppercase(record.getAltAreaName3()));
        record.setAltAreaName4(SWE_AddressUtils.uppercase(record.getAltAreaName4()));
    }

    protected String[] splitAltAreaNames(String areanames) {
        ArrayList<String> split = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(areanames, "/");
        while (st.hasMoreTokens()) {
            split.add(st.nextToken().trim());
        }
        return split.toArray(new String[split.size()]);
    }
}

