/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp;

import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJRangeRecord;
import com.mapinfo.mapmarker.common.ParsedNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SWE_InvalidRangeRecordFixer {
    public List<SWE_MMJRangeRecord> getReplacementRanges(SWE_MMJRangeRecord original) {
        int houseIncrement;
        if (original.isValid() || !this.isFixable(original)) {
            return Collections.singletonList(original);
        }
        ParsedNumber originalFrom = original.getFromHouse();
        ParsedNumber originalTo = original.getToHouse();
        boolean bAscending = original.isAscending();
        boolean bLeft = original.isLeft();
        int n = houseIncrement = original.getOddEven() == 0 ? 1 : 2;
        if (originalFrom.isPureNumeric() && !originalTo.isPureNumeric()) {
            ParsedNumber replacementTo = this.replaceHouse(originalTo, bAscending, houseIncrement);
            SWE_MMJRangeRecord artificialRange = this.makeArtificialRange(originalTo, bAscending, bAscending, bLeft, original.getOddEven());
            ArrayList<SWE_MMJRangeRecord> result = new ArrayList<SWE_MMJRangeRecord>(2);
            original.setToHouse(replacementTo.getCombinedAddressNumber());
            result.add(original);
            result.add(artificialRange);
            return result;
        }
        if (!originalFrom.isPureNumeric() && originalTo.isPureNumeric()) {
            ParsedNumber replacementFrom = this.replaceHouse(originalFrom, !bAscending, houseIncrement);
            SWE_MMJRangeRecord artificialRange = this.makeArtificialRange(originalFrom, !bAscending, bAscending, bLeft, original.getOddEven());
            ArrayList<SWE_MMJRangeRecord> result = new ArrayList<SWE_MMJRangeRecord>(2);
            original.setFromHouse(replacementFrom.getCombinedAddressNumber());
            result.add(artificialRange);
            result.add(original);
            return result;
        }
        ParsedNumber replacementFrom = this.replaceHouse(originalFrom, !bAscending, houseIncrement);
        ParsedNumber replacementTo = this.replaceHouse(originalTo, bAscending, houseIncrement);
        SWE_MMJRangeRecord artificialRange1 = this.makeArtificialRange(originalFrom, !bAscending, bAscending, bLeft, original.getOddEven());
        SWE_MMJRangeRecord artificialRange2 = this.makeArtificialRange(originalTo, bAscending, bAscending, bLeft, original.getOddEven());
        ArrayList<SWE_MMJRangeRecord> result = new ArrayList<SWE_MMJRangeRecord>(3);
        result.add(artificialRange1);
        original.setFromHouse(replacementFrom.getCombinedAddressNumber());
        original.setToHouse(replacementTo.getCombinedAddressNumber());
        result.add(original);
        result.add(artificialRange2);
        return result;
    }

    public boolean isFixable(SWE_MMJRangeRecord range) {
        return this.testHouse(range.getFromHouse()) && this.testHouse(range.getToHouse());
    }

    private boolean testHouse(ParsedNumber house) {
        int houseFieldCount = house.getNumFields();
        if (houseFieldCount > 2) {
            return false;
        }
        if (houseFieldCount == 2) {
            if (!house.getAddressNumberExists() || !house.hasAddressSuffix()) {
                return false;
            }
            if (house.getAddressSuffix().length() > 1) {
                return false;
            }
        } else if (!house.getAddressNumberExists()) {
            return false;
        }
        return true;
    }

    private ParsedNumber replaceHouse(ParsedNumber number, boolean bHigh, int increment) {
        if (bHigh) {
            return new ParsedNumber(number.getAddressNumber());
        }
        return new ParsedNumber(number.getAddressNumber() + (long)increment);
    }

    private SWE_MMJRangeRecord makeArtificialRange(ParsedNumber number, boolean bHigh, boolean bAscending, boolean bLeft, int oddEven) {
        ParsedNumber high;
        ParsedNumber low;
        SWE_MMJRangeRecord range = new SWE_MMJRangeRecord();
        range.setIsArtificialRange(true);
        range.setOddEven(oddEven);
        if (bLeft) {
            range.setLeft();
        } else {
            range.setRight();
        }
        if (bHigh) {
            low = new ParsedNumber(number.getAddressNumber() + "A");
            high = number;
        } else {
            low = number;
            high = new ParsedNumber(number.getAddressNumber() + "Z");
            range.setCountsAsSingleArtificialHouse(true);
        }
        if (bAscending) {
            range.setFromHouse(low.getCombinedAddressNumber());
            range.setToHouse(high.getCombinedAddressNumber());
        } else {
            range.setFromHouse(high.getCombinedAddressNumber());
            range.setToHouse(low.getCombinedAddressNumber());
        }
        return range;
    }
}

