/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.SWE.dp.SWE_InvalidRangeRecordFixer;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJRangeRecord;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJSegmentRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.InvalidRangeStatusDataSourceException;
import com.mapinfo.mapmarker.common.dp.StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class SWE_StreetDataSourceRecordConvertorImpl
extends StreetDataSourceRecordConvertorImpl {
    private static final String PCDIGITS = "1234567890";
    private static final String ADDRESS_POINT_PROCESSING = "AP_PROCESSING";
    private boolean m_bAPProcessing = false;
    private final SWE_InvalidRangeRecordFixer m_fixer = new SWE_InvalidRangeRecordFixer();

    public SWE_StreetDataSourceRecordConvertorImpl(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints);
        String isAPProcessing = dataProperties.getProperty(ADDRESS_POINT_PROCESSING);
        if (isAPProcessing != null && isAPProcessing.equalsIgnoreCase("true")) {
            this.m_bAPProcessing = true;
        }
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new MiSoundexGeo2SacRecord();
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyString = alternateBrowseString.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = SWE_ScoringHelper.getFirstNormChar(keyString.trim());
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
            char c = SWE_ScoringHelper.getFirstNormChar(keyBase.trim());
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    protected ArrayList getKeyBases(Address address) {
        String mainKey = address.getMainAddress();
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(mainKey);
        keys.add(SWE_AddressUtils.getFormattedStreetAddressWithoutSpaces(address, false));
        return keys;
    }

    public Address parseStreet(Address input) {
        Address addr = super.parseStreet(input);
        HashMap fields = addr.getAdditionalFields();
        String addrNum = (String)fields.get("street_suffix");
        if (addrNum != null && !addrNum.equalsIgnoreCase("")) {
            addr.setPostAddress(addrNum);
        }
        addr.setGenericField1(null);
        addr.setAreaName4(null);
        return addr;
    }

    protected String makeMainAddressString(String street, String houseNumber) {
        return street + " " + houseNumber;
    }

    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        record.setLeftAreaName1(SWE_AddressUtils.uppercase(record.getLeftAreaName1()));
        record.setLeftAreaName2(SWE_AddressUtils.uppercase(record.getLeftAreaName2()));
        record.setLeftAreaName3(SWE_AddressUtils.uppercase(record.getLeftAreaName3()));
        record.setLeftAreaName4(SWE_AddressUtils.uppercase(record.getLeftAreaName4()));
        record.setRightAreaName1(SWE_AddressUtils.uppercase(record.getRightAreaName1()));
        record.setRightAreaName2(SWE_AddressUtils.uppercase(record.getRightAreaName2()));
        record.setRightAreaName3(SWE_AddressUtils.uppercase(record.getRightAreaName3()));
        record.setRightAreaName4(SWE_AddressUtils.uppercase(record.getRightAreaName4()));
        String postCode = record.getLeftPostalCode1();
        if (postCode != null && postCode.indexOf(32) >= 0) {
            record.setLeftPostalCode1(StringUtilities.trimToChars((String)postCode, (String)PCDIGITS));
        }
        if ((postCode = record.getRightPostalCode1()) != null && postCode.indexOf(32) >= 0) {
            record.setRightPostalCode1(StringUtilities.trimToChars((String)postCode, (String)PCDIGITS));
        }
        return record;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        int result;
        int structValue;
        block13: {
            structValue = -1;
            String status = input.getStatus();
            try {
                structValue = Integer.parseInt(status);
            }
            catch (NumberFormatException ex) {
                String to;
                String from;
                if (!status.equalsIgnoreCase("B") || !(from = input.getFrom()).equalsIgnoreCase(to = input.getTo())) break block13;
                ParsedNumber temp = new ParsedNumber(from);
                switch (temp.isRangeOddEvenBoth()) {
                    case 2: {
                        structValue = 2;
                        break;
                    }
                    case 1: {
                        structValue = 3;
                        break;
                    }
                    case 0: {
                        structValue = 4;
                        break;
                    }
                    default: {
                        structValue = 5;
                    }
                }
            }
        }
        switch (structValue) {
            case 0: 
            case 1: 
            case 5: {
                result = 5;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            case 4: {
                result = 0;
                break;
            }
            default: {
                throw new InvalidRangeStatusDataSourceException(9, "The range will not be added as the range contains an unsupportedStruct field " + structValue);
            }
        }
        return result;
    }

    protected MMJStreetRecord createStreetRecord(IStreetDataSourceRecord input, int leftSac, int rightSac) throws DataSourceException, DataCreationException {
        MMJStreetRecord record = super.createStreetRecord(input, leftSac, rightSac);
        if (record != null && this.m_bAPProcessing && !record.getSegment().isPointHouseSegment()) {
            DataCreationLogger.getLogger().logError("No house found for point house segment'" + record.getSegment().getId() + "'");
            return null;
        }
        return record;
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        MMJRangeRecord record = super.convertRangeRecord(input, sac);
        if (record != null) {
            ParsedNumber parsedNumber = record.getFromHouse();
            if (parsedNumber != null && parsedNumber.hasAddressSuffix()) {
                record.setFromHouse(SWE_AddressUtils.uppercase(parsedNumber.getCombinedAddressNumber()));
            }
            if ((parsedNumber = record.getToHouse()) != null && parsedNumber.hasAddressSuffix()) {
                record.setToHouse(SWE_AddressUtils.uppercase(parsedNumber.getCombinedAddressNumber()));
            }
        }
        return record;
    }

    protected void addRangesToSegment(MMJSegmentRecord segment, ISegmentDataSourceRecord input, int sac, boolean addLeft, boolean addRight) throws DataSourceException {
        super.addRangesToSegment(segment, input, sac, addLeft, addRight);
        ArrayList ranges = new ArrayList();
        if (segment.getRanges() != null && segment.getRanges().size() > 0) {
            ranges.addAll(segment.getRanges());
            segment.getRanges().clear();
        }
        for (SWE_MMJRangeRecord range : ranges) {
            if (range.isValid()) {
                segment.addRange((MMJRangeRecord)range);
                continue;
            }
            if (this.m_fixer.isFixable(range)) {
                List<SWE_MMJRangeRecord> replacements = this.m_fixer.getReplacementRanges(range);
                for (SWE_MMJRangeRecord replacement : replacements) {
                    segment.addRange((MMJRangeRecord)replacement);
                }
                continue;
            }
            DataCreationLogger.getLogger().logInternalError("Unable to fix range for segment: " + segment.getId() + " from house: " + range.getFromHouse() + " to house: " + range.getToHouse());
            segment.addRange((MMJRangeRecord)range);
        }
    }

    protected boolean fixInvalidRange(MMJRangeRecord range) {
        return true;
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new SWE_MMJRangeRecord();
    }

    protected MMJSegmentRecord makeSegmentRecordType() {
        return new SWE_MMJSegmentRecord();
    }
}

