/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.SWE_ScoringHelper;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_AddressFetcher;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.SWE.parser.SWE_AddressTerm;
import com.mapinfo.mapmarker.SWE.parser.SWE_ParsePostAddressRule;
import com.mapinfo.mapmarker.common.AbstractDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;

public class SWE_DataDictionary
extends AbstractDataDictionary {
    public static final String KEY_SWE_ALTERNATE_SOUNDEX_CODES = "KEY_SWE_ALTERNATE_SOUNDEX_CODES";
    private static final Soundex m_soundex = new SWELanguageSoundex();
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("se", "SWE"), SWE_ScoringHelper.getCollationRules());

    public SWE_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    public IGeoBase[] getGeoBases(Address pa, IConstraints preferences) {
        String an3clean;
        String an3 = pa.getAreaName3();
        String an4 = pa.getAreaName4();
        if (an3 == null || an3.trim().length() == 0) {
            return null;
        }
        HashSet<MiSoundexGeoBase> bases = new HashSet<MiSoundexGeoBase>();
        ISoundexKey sndxKey = m_soundex.getSoundex(an3);
        if (sndxKey != null) {
            bases.add(new MiSoundexGeoBase((MiSoundexKey)sndxKey));
        }
        if ((an3clean = SWE_AddressTerm.removeCommonTerms(an3)) != null && (sndxKey = m_soundex.getSoundex(an3clean)) != null) {
            bases.add(new MiSoundexGeoBase((MiSoundexKey)sndxKey));
        }
        SWELanguageSoundex cfr_ignored_0 = (SWELanguageSoundex)m_soundex;
        sndxKey = SWELanguageSoundex.getStringKey(an3);
        if (sndxKey != null) {
            bases.add(new MiSoundexGeoBase((MiSoundexKey)sndxKey));
        }
        if (an4 != null && an4.length() != 0 && (sndxKey = m_soundex.getSoundex(an4)) != null) {
            bases.add(new MiSoundexGeoBase((MiSoundexKey)sndxKey));
        }
        if (bases.size() > 0) {
            return bases.toArray(new IGeoBase[bases.size()]);
        }
        return null;
    }

    protected IPostalBase makePostalBase(String zipCode) {
        if (zipCode == null || zipCode.trim().length() == 0) {
            return null;
        }
        if ((zipCode = SWE_ParsePostAddressRule.getOutwardSortingCode(zipCode)) == null || zipCode.trim().length() == 0) {
            return null;
        }
        return new StandardPostalBase(zipCode);
    }

    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        String postcode = addr.getPostCode1();
        IPostalBase base = this.makePostalBase(postcode);
        if (base != null) {
            IPostalBase[] retvals = new IPostalBase[]{base};
            return retvals;
        }
        return null;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new MiSoundexGeo2SacRecord();
    }

    protected IAddressFetcher initAddressFetcher() {
        return new SWE_AddressFetcher(this.getDataManagerSettings(), null);
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        String areaName3 = pa.getAreaName3();
        if (areaName3 == null || areaName3.length() == 0) {
            return null;
        }
        MiSoundexKey key = (MiSoundexKey)m_soundex.getSoundex(areaName3);
        if (key == null) {
            return null;
        }
        ArrayList alternatesList = new ArrayList();
        alternatesList.add(key);
        switch (i) {
            case 0: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 32, alternatesList);
                break;
            }
            case 1: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 1, alternatesList);
                break;
            }
            case 2: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 16, alternatesList);
                break;
            }
            case 3: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 2, alternatesList);
                break;
            }
            case 4: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 8, alternatesList);
                break;
            }
            case 5: {
                alternatesList = (ArrayList)m_soundex.calculateAlternateSoundexKeys(areaName3, (ISoundexKey)key, 4, alternatesList);
                break;
            }
            default: {
                return null;
            }
        }
        if (alternatesList == null) {
            return null;
        }
        int size = alternatesList.size();
        Object[] objs = alternatesList.toArray();
        MiSoundexGeoBase[] retvals = new MiSoundexGeoBase[size];
        for (int j = 0; j < size; ++j) {
            retvals[j] = new MiSoundexGeoBase((MiSoundexKey)objs[j]);
        }
        return retvals;
    }

    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new SWE_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        SWE_PostInfoFetcherImpl postInfoFetcher = null;
        if (!this.isUserDictionary()) {
            postInfoFetcher = new SWE_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return postInfoFetcher;
    }

    protected Soundex getSoundex() {
        return m_soundex;
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String secondaryKey;
        String mainAddress = addr.getMainAddress();
        if (StringUtilities.isEmpty((String)mainAddress)) {
            return null;
        }
        String browseStrKey = SWE_AddressUtils.getFormattedStreetAddressWithoutSpaces(addr, true);
        int count = browseStrKey.equals(secondaryKey = SWE_AddressUtils.getFormattedStreetAddressWithoutSpaces(addr, false)) ? 1 : 2;
        char c = SWE_ScoringHelper.getFirstNormChar(browseStrKey);
        int[] collationKey = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey);
        MapMarkerBrowseMultiLevelIndexKey[] keys = new MapMarkerBrowseMultiLevelIndexKey[count];
        keys[0] = key;
        if (count > 1) {
            collationKey = this.getCollationKeyGenerator().getCollationKey(secondaryKey);
            keys[1] = key = new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey);
        }
        return keys;
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        if (StringUtilities.isEmpty((String)addr.getPlaceName())) {
            return null;
        }
        String browseStrKey = addr.getPlaceName().trim();
        if (StringUtilities.isEmpty((String)browseStrKey)) {
            return null;
        }
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = SWE_ScoringHelper.getFirstNormChar(browseStrKey.trim());
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        String origStr = addr.getMainAddress();
        ISoundexKey origKey = m_soundex.getSoundex(origStr);
        if (origKey == null) {
            return null;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)KEY_SWE_ALTERNATE_SOUNDEX_CODES);
        int altTypes = 0;
        if (tmp == null) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        altTypes = tmp;
        if (altTypes <= 0) {
            ISoundexKey[] retvals = new ISoundexKey[]{origKey};
            return retvals;
        }
        ArrayList alternates = new ArrayList();
        alternates.add(origKey);
        alternates = (ArrayList)m_soundex.calculateAlternateSoundexKeys(origStr, origKey, altTypes, alternates);
        int size = alternates.size();
        Object[] objs = alternates.toArray();
        ISoundexKey[] retvals = new ISoundexKey[size];
        for (int i = 0; i < size; ++i) {
            retvals[i] = (ISoundexKey)objs[i];
        }
        return retvals;
    }

    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        SWE_DictionaryGeographyInfo info = new SWE_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        if (this.isUserDictionary()) {
            info.setIsUserDictionary(true);
        } else {
            info.setIsUserDictionary(false);
        }
        return info;
    }

    class SWE_DictionaryGeographyInfo
    extends AbstractDictionaryGeographyInfo {
        private List m_streets = new ArrayList();
        private Collection m_centroids = new TreeSet();

        public List getInfos() {
            ArrayList infos = new ArrayList();
            Collections.sort(this.m_streets);
            infos.addAll(this.m_streets);
            infos.addAll(this.m_centroids);
            return infos;
        }

        public boolean hasStreets() {
            return true;
        }

        public boolean hasCentroids() {
            return true;
        }
    }
}

