/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_DataDictionary;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

public class SWE_DataManager
extends AbstractDataManager {
    private static Throwable m_setupException;
    private static Properties m_dataResources;
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    static IDataDictionary[] m_dataDicts;
    static int m_numDicts;

    public SWE_DataManager() throws MMJEDataManagerInitializationException {
        if (m_setupException != null) {
            ResourceBundle rb = SWE_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG));
        }
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public static ArrayList getGeoInfoAlias(String strGeoKey, String strPostCode, int dictNum) {
        if (strGeoKey == null && strPostCode == null) {
            return null;
        }
        SWE_GeoInfoFetcherImpl geoFetcher = (SWE_GeoInfoFetcherImpl)m_dataDicts[dictNum].getGeoInfoFetcher();
        if (geoFetcher == null) {
            return null;
        }
        return null;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    protected LicenseFilter getLicenseFilter() {
        return null;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("SWE");
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            SWE_DataManager.start();
            if (m_setupException != null) {
                throw new MMJEDataManagerInitializationException(m_setupException.getMessage(), m_setupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            SWE_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    private static void start() {
        m_setupException = null;
        try {
            m_dataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("SWE");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_dataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new SWE_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    SWE_DataManager.m_dataDicts[i] = new SWE_DataDictionary(i, m_dataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_setupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_setupException = e;
        }
    }

    static {
        SWE_DataManager.start();
    }
}

