/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.SWE.SWE_InternalGeographicCandidate;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.SWE.parser.SWE_AddressTerm;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.SimpleLoadableMapMarkerIndex;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class SWE_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    protected Soundex m_soundex = new SWELanguageSoundex();

    public SWE_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages);
    }

    SWE_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages, boolean bInitNow) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages, bInitNow);
    }

    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        List results = super.getGeoInfoCandidates(addr, constraints);
        if (results != null && !results.isEmpty()) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                InternalGeographicCandidate candidate = (InternalGeographicCandidate)it.next();
                if (candidate.getPrecision() != 0) continue;
                it.remove();
            }
        }
        return results;
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new SWE_GeoInfoPreLoadedDataHelper();
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return new SWE_GeoInfoSoundexIndexFile();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        HashSet<MiSoundexIndexKey> list = new HashSet<MiSoundexIndexKey>();
        String areaName3 = addr.getAreaName3();
        if (areaName3 != null) {
            this.addKey(list, areaName3);
            this.addFirstAndLast(list, areaName3);
            this.addKey(list, SWE_AddressTerm.removeCommonTerms(areaName3));
        }
        this.addKey(list, addr.getAreaName2());
        this.addKey(list, addr.getAreaName1());
        MapMarkerIndexKey[] retvals = new MapMarkerIndexKey[list.size()];
        retvals = list.toArray(retvals);
        return retvals;
    }

    protected void addKey(HashSet<MiSoundexIndexKey> keySet, String value) {
        if (value != null) {
            keySet.add(new MiSoundexIndexKey((MiSoundexKey)this.m_soundex.getSoundex(value)));
        }
    }

    protected void addFirstAndLast(HashSet<MiSoundexIndexKey> keySet, String value) {
        StringTokenizer st = new StringTokenizer(value, " /-");
        if (st.countTokens() != 1) {
            this.addKey(keySet, st.nextToken());
            String result = null;
            while (st.hasMoreTokens()) {
                result = st.nextToken();
            }
            this.addKey(keySet, result);
        }
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new SWE_InternalGeographicCandidate();
    }

    class SWE_GeoInfoSoundexIndexFile
    extends SimpleLoadableMapMarkerIndex {
        SWE_GeoInfoSoundexIndexFile() {
        }

        protected MapMarkerIndexKey getIndexKeyType() {
            return new MiSoundexIndexKey();
        }

        protected MapMarkerIndexValue getIndexValueType() {
            return new MapMarkerIndexMultiValue();
        }
    }
}

